/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnalStatus;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.scan.BaseProfessionnalControl;
import ca.infodata.ofys.util.MiscUtil;
import java.util.Calendar;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ProfessionnalControl
extends BaseProfessionnalControl
implements IPreValidator {
    private static final String SECTION_AUTRES_PROFESSIONNEL = Messages.getString((String)"ProfessionnalControl.SECTION_AUTRES_PROFESSIONNEL", (String[])new String[0]);
    private static final String MSG_ERR_NO_DELETE = Messages.getString((String)"ProfessionnalControl.MSG_ERR_NO_DELETE", (String[])new String[0]);
    private static final String MSG_ERR_NO_DELETE_DEFAULT = Messages.getString((String)"ProfessionnalControl.MSG_ERR_NO_DELETE_DEFAUL", (String[])new String[0]);
    private static final String MSG_ERR_NO_ADD_P1 = Messages.getString((String)"ProfessionnalControl.MSG_ERR_NO_ADD_P1", (String[])new String[0]);
    private static final String MSG_ERR_NO_ADD_P2 = Messages.getString((String)"ProfessionnalControl.MSG_ERR_NO_ADD_P2", (String[])new String[0]);
    private static final String MSG_ERR_NO_PROF = Messages.getString((String)"ProfessionnalControl.MSG_ERR_NO_PROF", (String[])new String[0]);
    private String errorMsg = "";

    public ProfessionnalControl(Composite parent, IBaseEditor parentEditor, FormToolkit toolkit, boolean isEditionFormat) {
        super(parent, parentEditor, toolkit, isEditionFormat);
    }

    @Override
    public void fillProfessionnalList(XPatientImage image) {
        this.currentImage = image;
        if (image == null) {
            this.setStatusList((IEditableDataObjectList)new EditableDataObjectList());
        } else {
            this.setStatusList(image.getProfessionnals());
        }
    }

    public void setFirstFocus() {
        this.txtTreatingProfessionnal.setFocus();
    }

    protected void showDataObject(XPatientImageProfessionnal selection) {
        this.currentImageProfessionnal = selection;
        this.txtTreatingProfessionnal.setDataObjectId(selection.getProfessionnal());
        this.chkToResolve.setSelection(selection.getStatus().contains(XPatientImageProfessionnalStatus.TO_RESOLVE));
        this.chkToResolve.setEnabled(false);
        this.chkOpenWithFile.setSelection(selection.getStatus().contains(XPatientImageProfessionnalStatus.OPEN_WITH_FILE));
        this.chkOpenWithFile.setEnabled(false);
        XBaseProfessionnal professionnal = PersonUiPlugin.getDefault().getSessionProfessionnal();
        if (professionnal != null && selection.getProfessionnal() != null && MiscUtil.areObjectsEquals((Object)selection.getProfessionnal(), (Object)professionnal)) {
            this.chkToResolve.setEnabled(true);
            this.chkOpenWithFile.setEnabled(true);
        }
    }

    protected XPatientImageProfessionnal initializeNewDataObject() {
        XPatientImageProfessionnal patientImageProfessionnal = new XPatientImageProfessionnal();
        patientImageProfessionnal.setNew();
        patientImageProfessionnal.setDateAssigned(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
        patientImageProfessionnal.setNote("");
        patientImageProfessionnal.setProfessionnal(null);
        return patientImageProfessionnal;
    }

    protected String getTitle() {
        return SECTION_AUTRES_PROFESSIONNEL;
    }

    protected IPreValidator getPreValidatorNewInstance() {
        return this;
    }

    public boolean validForSave(EditableDataObject dataObject, EditableDataObject editorInput) {
        if (dataObject instanceof XPatientImageProfessionnal) {
            XPatientImageProfessionnal newXpip = (XPatientImageProfessionnal)dataObject;
            if (newXpip.getProfessionnal() != null) {
                int count = 0;
                for (XPatientImageProfessionnal xpip : this.getStatusList().getNotDeleted()) {
                    if (!xpip.getProfessionnal().equals(newXpip.getProfessionnal())) continue;
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    String name = PersonUiPlugin.getDefault().getBaseProfessionnal(newXpip.getProfessionnal()).getName();
                    this.errorMsg = String.valueOf(MSG_ERR_NO_ADD_P1) + name + MSG_ERR_NO_ADD_P2;
                    return false;
                }
            } else {
                this.errorMsg = MSG_ERR_NO_PROF;
                return false;
            }
        }
        return true;
    }

    public boolean validForDelete(EditableDataObject dataObject, EditableDataObject editorInput) {
        if (dataObject instanceof XPatientImageProfessionnal) {
            XPatientImageProfessionnal xpip = (XPatientImageProfessionnal)dataObject;
            if (xpip.getId() == null || xpip.getSeenDatetime() == null && xpip.getSignedDatetime() == null) {
                return true;
            }
            String name = PersonUiPlugin.getDefault().getBaseProfessionnal(xpip.getProfessionnal()).getName();
            this.errorMsg = String.valueOf(MSG_ERR_NO_DELETE) + name + ".";
            return false;
        }
        this.errorMsg = MSG_ERR_NO_DELETE_DEFAULT;
        return false;
    }

    public boolean validForEdition(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    public String getError() {
        return this.errorMsg;
    }
}

