/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter.medication;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PreferencesAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPreferencesContainer;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionPrintFormat;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientPreferences;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XUserPreferences;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.controls.BaseSubEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.util.EnumWithValue;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.Section;

public class PrescriptionPreferencesEditor
extends BaseSubEditor {
    private static final String AFFICHAGE_DU_NOM_DANS_ORDONNANCE_DETAIL = Messages.getString((String)"BasePrescriptionPreferencesEditor.AFFICHAGE_DU_NOM_DANS_ORDONNANCE_DETAIL", (String[])new String[0]);
    private static final String AFFICHAGE_DU_NOM_DANS_LES_PAGES_SOMMAIRES_PATIENT_ET_RENCONTRE = Messages.getString((String)"BasePrescriptionPreferencesEditor.AFFICHAGE_DU_NOM_DANS_LES_PAGES_SOMMAIRES_PATIENT_ET_RENCONTRE", (String[])new String[0]);
    private static final String FORMAT_DIMPRESSION_DES_ORDONNANCES_PAR_DEFAUT = Messages.getString((String)"BasePrescriptionPreferencesEditor.FORMAT_DIMPRESSION_DES_ORDONNANCES_PAR_DEFAUT", (String[])new String[0]);
    private static final String FORMAT_DIMPRESSION_DES_ORDONNANCES_PAR_DEFAUT_USER = Messages.getString((String)"BasePrescriptionPreferencesEditor.FORMAT_DIMPRESSION_DES_ORDONNANCES_PAR_DEFAUT_USER", (String[])new String[0]);
    private static final String FORMAT_DIMPRESSION_DES_ORDONNANCES_USER = Messages.getString((String)"BasePrescriptionPreferencesEditor.FORMAT_DIMPRESSION_DES_ORDONNANCES_USER", (String[])new String[0]);
    private static final String IMPORTER_LES_MODELES_DE_PRESCRIPTIONS = Messages.getString((String)"BasePrescriptionPreferencesEditor.IMPORTER_LES_MODELES_DE_PRESCRIPTIONS", (String[])new String[0]);
    private MyCombo<XPrescriptionDrugNameFormat> cmbDetail;
    private MyCombo<XPrescriptionDrugNameFormat> cmbSummary;
    private MyCombo<XPrescriptionPrintFormat> cboPrintFormat;
    private MyCombo<XPrescriptionPrintFormatUser> cboPrintFormatUser;
    private Section mainSection;

    public PrescriptionPreferencesEditor() {
    }

    public PrescriptionPreferencesEditor(BaseMultiEditor parentEditor) {
        super(parentEditor);
    }

    public void createMyControl(Composite parent) {
        FormData data;
        this.setTitleImage(ResourceGetter.getImage((String)"images/Heart-icon16.png"));
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 10;
        fillLayout.marginWidth = 10;
        parent.setLayout((Layout)fillLayout);
        this.mainSection = this.toolkit.createSection(parent, 64);
        this.mainSection.setText("Prescripteur");
        this.toolkit.createCompositeSeparator((Composite)this.mainSection);
        Composite main = this.toolkit.createComposite((Composite)this.mainSection);
        this.mainSection.setClient((Control)main);
        MyLabel lblDetail = new MyLabel(main, AFFICHAGE_DU_NOM_DANS_ORDONNANCE_DETAIL, 0, this.toolkit);
        this.cmbDetail = new MyCombo(main, 8, this.toolkit);
        this.cmbDetail.setItems((Object[])XPrescriptionDrugNameFormat.values());
        MyLabel lblSummary = new MyLabel(main, AFFICHAGE_DU_NOM_DANS_LES_PAGES_SOMMAIRES_PATIENT_ET_RENCONTRE, 0, this.toolkit);
        this.cmbSummary = new MyCombo(main, 8, this.toolkit);
        this.cmbSummary.setItems((Object[])XPrescriptionDrugNameFormat.values());
        MyLabel lblPrintFormat = new MyLabel(main, FORMAT_DIMPRESSION_DES_ORDONNANCES_PAR_DEFAUT, 0, this.toolkit);
        this.cboPrintFormat = new MyCombo(main, 8, this.toolkit);
        this.cboPrintFormat.setItems((Object[])XPrescriptionPrintFormat.values());
        MyLabel lblPrintFormatUser = new MyLabel(main, FORMAT_DIMPRESSION_DES_ORDONNANCES_PAR_DEFAUT_USER, 0, this.toolkit);
        this.cboPrintFormatUser = new MyCombo(main, 8, this.toolkit);
        this.cboPrintFormatUser.setItems((Object[])XPrescriptionPrintFormatUser.values());
        boolean showClientSection = Application.get().getGlobalInstances().hasRight(XRight.PRESCRIPTION_PREFERENCES_GLOBAL);
        this.cboPrintFormat.setVisible(showClientSection);
        lblPrintFormat.setVisible(showClientSection);
        boolean showUserSection = Application.get().getGlobalInstances().hasRight(XRight.PRESCRIPTION_PREFERENCES_USER);
        lblDetail.setVisible(showUserSection);
        this.cmbDetail.setVisible(showUserSection);
        lblSummary.setVisible(showUserSection);
        this.cmbSummary.setVisible(showUserSection);
        lblPrintFormatUser.setVisible(showUserSection);
        this.cboPrintFormatUser.setVisible(showUserSection);
        Application.get().getGlobalInstances().hasRight(XRight.IMPORT_PRESCRIPTION_MODELS);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.spacing = 5;
        main.setLayout((Layout)layout);
        Combo lastControl = null;
        if (showUserSection) {
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            if (!lblDetail.getVisible()) {
                data.height = 0;
            }
            lblDetail.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(lblDetail.getControl(), 0);
            data.left = new FormAttachment(0);
            data.width = 200;
            if (!this.cmbDetail.getVisible()) {
                data.height = 0;
            }
            this.cmbDetail.getControl().setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.cmbDetail.getControl(), 0);
            data.left = new FormAttachment(0);
            if (!lblSummary.getVisible()) {
                data.height = 0;
            }
            lblSummary.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(lblSummary.getControl(), 0);
            data.left = new FormAttachment(0);
            data.width = 200;
            if (!this.cmbSummary.getVisible()) {
                data.height = 0;
            }
            this.cmbSummary.getControl().setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.cmbSummary.getControl(), 5);
            data.left = new FormAttachment(0);
            if (!lblPrintFormatUser.getVisible()) {
                data.height = 0;
            }
            lblPrintFormatUser.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(lblPrintFormatUser.getControl(), 0);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(20);
            if (!this.cboPrintFormatUser.getVisible()) {
                data.height = 0;
            }
            this.cboPrintFormatUser.getControl().setLayoutData((Object)data);
            lastControl = this.cboPrintFormatUser.getControl();
        }
        if (showClientSection) {
            data = new FormData();
            data.top = showUserSection ? new FormAttachment(lastControl, 15) : new FormAttachment(0, 5);
            data.top = new FormAttachment(lastControl);
            data.left = new FormAttachment(0);
            if (!lblPrintFormat.getVisible()) {
                data.height = 0;
            }
            lblPrintFormat.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(lblPrintFormat.getControl());
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(20);
            if (!this.cboPrintFormat.getVisible()) {
                data.height = 0;
            }
            this.cboPrintFormat.getControl().setLayoutData((Object)data);
            lastControl = this.cboPrintFormat.getControl();
        }
        this.bindValues();
    }

    private void bindValues() {
        this.cmbDetail.addListener(13, (Listener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                XUserPreferences userPreferences = PrescriptionPreferencesEditor.this.getUserPreferences();
                if (userPreferences != null) {
                    userPreferences.setDrugNameFormatDetail((XPrescriptionDrugNameFormat)PrescriptionPreferencesEditor.this.cmbDetail.getSelection());
                }
            }
        });
        this.cmbSummary.addListener(13, (Listener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                XUserPreferences userPreferences = PrescriptionPreferencesEditor.this.getUserPreferences();
                if (userPreferences != null) {
                    userPreferences.setDrugNameFormatSummary((XPrescriptionDrugNameFormat)PrescriptionPreferencesEditor.this.cmbSummary.getSelection());
                }
            }
        });
        this.cboPrintFormatUser.addListener(13, (Listener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                XUserPreferences userPreferences = PrescriptionPreferencesEditor.this.getUserPreferences();
                if (userPreferences != null) {
                    userPreferences.setPrescriptionAutoPrint(Integer.valueOf(((XPrescriptionPrintFormatUser)((Object)PrescriptionPreferencesEditor.this.cboPrintFormatUser.getSelection())).getValue()));
                }
            }
        });
        this.cboPrintFormat.addListener(13, (Listener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                XClientPreferences clientPreferences = PrescriptionPreferencesEditor.this.getClientPreferences();
                if (clientPreferences != null) {
                    clientPreferences.setDefaultPrescriptionPrintFormat((XPrescriptionPrintFormat)PrescriptionPreferencesEditor.this.cboPrintFormat.getSelection());
                }
            }
        });
    }

    private void doImportPrescriptionsModels() {
        XSession session = Application.get().getGlobalInstances().getSession();
        JobCallback callback = new JobCallback(IMPORTER_LES_MODELES_DE_PRESCRIPTIONS, (IStatusHandler)DefaultStatusHandler.getInstance()){};
        try {
            PreferencesAccessorClient.getInstance().executeTask("synchronizeb2b", null, session, (ICallback)callback);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            callback.kill();
        }
        catch (Exception e) {
            MessageUtil.unexpectedExceptionMsg((Exception)e);
            Log.log((Throwable)e);
            callback.kill();
        }
    }

    public void showDataObjectOverride() {
        XClientPreferences clientPreferences = this.getClientPreferences();
        boolean enabled = clientPreferences != null;
        this.cboPrintFormat.setEnabled(enabled);
        if (clientPreferences == null) {
            this.cboPrintFormat.selectNone();
        } else {
            this.cboPrintFormat.select((Object)clientPreferences.getDefaultPrescriptionPrintFormat());
        }
        XUserPreferences userPreferences = this.getUserPreferences();
        enabled = userPreferences != null;
        this.cboPrintFormatUser.setEnabled(enabled);
        this.cmbDetail.setEnabled(enabled);
        this.cmbSummary.setEnabled(enabled);
        if (userPreferences == null) {
            this.cmbDetail.selectNone();
            this.cmbSummary.selectNone();
            this.cboPrintFormatUser.selectNone();
        } else {
            this.cmbDetail.select((Object)userPreferences.getDrugNameFormatDetail());
            this.cmbSummary.select((Object)userPreferences.getDrugNameFormatSummary());
            Integer i = userPreferences.getPrescriptionAutoPrint() == null ? -1 : userPreferences.getPrescriptionAutoPrint();
            this.cboPrintFormatUser.select((Object)XPrescriptionPrintFormatUser.from(i));
        }
    }

    private XPreferencesContainer getPreferencesContainer() {
        IEditorInput input = this.getEditorInput();
        return (XPreferencesContainer)(input == null ? null : ((EditorInput)input).getCompleteDataObject());
    }

    private XClientPreferences getClientPreferences() {
        XPreferencesContainer container = this.getPreferencesContainer();
        return container == null ? null : container.getClientPreferences();
    }

    private XUserPreferences getUserPreferences() {
        XPreferencesContainer container = this.getPreferencesContainer();
        return container == null ? null : container.getUserPreferences();
    }

    public void load() {
    }

    public static enum XPrescriptionPrintFormatUser implements EnumWithValue<XPrescriptionPrintFormatUser>
    {
        USER(-1){

            public String toString() {
                return FORMAT_DIMPRESSION_DES_ORDONNANCES_USER;
            }
        }
        ,
        LETTER(0){

            public String toString() {
                return Messages.getString((String)"FORMAT_LETTRE", (String[])new String[0]);
            }
        }
        ,
        PRESCRIPTION(1){

            public String toString() {
                return Messages.getString((String)"FORMAT_ORDONNANCE", (String[])new String[0]);
            }
        }
        ,
        PRESCRIPTION3PCES(2){

            public String toString() {
                return Messages.getString((String)"FORMAT_ORDONNANCE_3PCES", (String[])new String[0]);
            }
        };

        public final int value;

        public int getValue() {
            return this.value;
        }

        private XPrescriptionPrintFormatUser(int id) {
            this.value = id;
        }

        public XPrescriptionPrintFormatUser fromValue(Integer id) {
            return XPrescriptionPrintFormatUser.from(id);
        }

        public static XPrescriptionPrintFormatUser from(Integer id) {
            if (id != null) {
                XPrescriptionPrintFormatUser[] xPrescriptionPrintFormatUserArray = XPrescriptionPrintFormatUser.values();
                int n = xPrescriptionPrintFormatUserArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XPrescriptionPrintFormatUser v = xPrescriptionPrintFormatUserArray[n2];
                    if (v.value == id) {
                        return v;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }
}

