/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.professionnal;

import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.professionnal.NullXBaseProfessionnal;
import ca.infodata.ofys.ui.person.professionnal.SOXBaseProfessionnal;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ProfessionalCombo
extends MyCombo<XBaseProfessionnal> {
    public static final int SHOW_DELETED = 32768;
    private final boolean cso;
    private final boolean cnull;
    private final boolean showDeleted;
    private static final int STANDARD_TEXT_LIMIT = 100;
    private NullXBaseProfessionnal snull;
    private SOXBaseProfessionnal so;

    public ProfessionalCombo(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, toolkit);
        this.cso = (style | 0x2000) == style;
        this.cnull = (style | 0x10000) == style;
        this.showDeleted = (style | 0x8000) == style;
        this.setAutoComplete(true);
        this.setLabelProvider((ProviderAR)new ProviderAR<XBaseProfessionnal, String>(){

            public String get(XBaseProfessionnal prof) {
                if (prof == null || prof.getText() == null) {
                    return "";
                }
                if (Boolean.TRUE.equals(prof.getIsDeleted())) {
                    return "*" + prof.getName();
                }
                return prof.getName();
            }
        });
        this.setDisplayPredicate((PredicateA)new PredicateA<XBaseProfessionnal>(){

            public boolean evaluate(XBaseProfessionnal c) {
                if (c == null) {
                    return false;
                }
                if (Boolean.TRUE.equals(c.getIsDeleted())) {
                    return ProfessionalCombo.this.showDeleted;
                }
                return true;
            }
        });
        this.setTextLimit(100);
        this.fill();
    }

    public void fill() {
        this.fill(PersonUiPlugin.getDefault().getBaseProfessionnals());
    }

    public void fill(Stream<XBaseProfessionnal> professionals) {
        if (professionals != null) {
            XBaseProfessionnal[] temp;
            Object[] items = (XBaseProfessionnal[])professionals.toArray(XBaseProfessionnal[]::new);
            String text = this.getText();
            XBaseProfessionnal selection = this.getSelection();
            XBaseProfessionnal defaultSelection = (XBaseProfessionnal)this.getDefaultSelection();
            if (defaultSelection != null) {
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    XBaseProfessionnal i = objectArray[n2];
                    if (defaultSelection.equals((Object)i)) {
                        defaultSelection = i;
                        break;
                    }
                    ++n2;
                }
            }
            this.so = null;
            if (this.cso) {
                this.so = new SOXBaseProfessionnal();
                temp = new XBaseProfessionnal[items.length + 1];
                temp[0] = this.so;
                System.arraycopy(items, 0, temp, 1, items.length);
                items = temp;
            }
            this.snull = null;
            if (this.cnull) {
                this.snull = new NullXBaseProfessionnal();
                temp = new XBaseProfessionnal[items.length + 1];
                temp[0] = this.snull;
                System.arraycopy(items, 0, temp, 1, items.length);
                items = temp;
            }
            this.setItems(items);
            if (this.cso && defaultSelection == null) {
                defaultSelection = this.so;
            }
            if (this.cnull && (defaultSelection == null || defaultSelection instanceof NullXBaseProfessionnal)) {
                defaultSelection = this.snull;
            }
            if (defaultSelection != null) {
                this.setDefaultSelection(defaultSelection);
            }
            if (selection != null) {
                this.selectNoNotify(selection);
            } else {
                this.setTextNoNotify(text);
            }
        }
    }

    public XBaseProfessionnal getSelection() {
        XBaseProfessionnal selection = (XBaseProfessionnal)super.getSelection();
        if (selection instanceof NullXBaseProfessionnal) {
            return null;
        }
        return selection;
    }

    public void select(XBaseProfessionnal item) {
        if (item == null && this.cnull) {
            item = this.snull;
        }
        if (item == null && this.cso) {
            item = this.so;
        }
        if (this.contains(item)) {
            super.select((Object)item);
        } else {
            this.add(item);
            super.select((Object)item);
        }
    }

    public static void sortByProf(List<XBaseProfessionnal> list) {
        Collections.sort(list, new Comparator<XBaseProfessionnal>(){

            @Override
            public int compare(XBaseProfessionnal o1, XBaseProfessionnal o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1 instanceof NullXBaseProfessionnal) {
                    return -1;
                }
                if (o1 instanceof SOXBaseProfessionnal) {
                    return -1;
                }
                if (o2 instanceof NullXBaseProfessionnal) {
                    return 1;
                }
                if (o2 instanceof SOXBaseProfessionnal) {
                    return 1;
                }
                return StringUtils.compareAscii((String)o1.getName(), (String)o2.getName());
            }
        });
    }
}

