/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.simpleview;

import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.mb.listener.property.IPropertyListener;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.person.patient.simpleview.VerySimplePatientControl;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class SimplePatientView
extends ViewPart
implements IPropertyListener,
IRefreshFont {
    private VerySimplePatientControl verySimplePatientControl;
    private IPatient patient;

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = UI.createToolKit((Widget)parent);
        toolkit.adapt(parent);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        this.verySimplePatientControl = new VerySimplePatientControl(parent, toolkit);
        this.setPartName("Client");
        PropertyListenerManager.addListener((Object)((Object)PersonUiPlugin.getDefault()), (IPropertyListener)this);
        ResourceGetter.addListener((IRefreshFont)this);
        this.refresh();
    }

    public void dispose() {
        ResourceGetter.removeListener((IRefreshFont)this);
        super.dispose();
    }

    public void setFocus() {
        this.verySimplePatientControl.setFocus();
    }

    public void propertyChanged(int propertyId) {
        if (propertyId == 1) {
            this.refresh();
        }
    }

    private void refresh() {
        XPatient currentPatient = PersonUiPlugin.getDefault().getCurrentPatient();
        this.patient = currentPatient;
        if (this.verySimplePatientControl != null && !this.verySimplePatientControl.isDisposed()) {
            final XPatient patient = this.patient == null || this.patient.getId() == null ? null : PatientUtil.getSimplePatient(this.patient);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SimplePatientView.this.verySimplePatientControl.setPatient((IPatient)patient);
                    SimplePatientView.this.setPartName(patient == null ? "Client" : patient.getNameBirthdateSex());
                }
            });
        }
    }

    public void refreshFont() {
        this.verySimplePatientControl.refreshFont();
        this.verySimplePatientControl.getParent().layout(true, true);
    }
}

