/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.simpleview;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.PatientValueAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JustLogStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientValue;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.patient.PatientAlertDialog;
import ca.infodata.ofys.ui.person.patient.simpleview.BaseVerySimplePatientControl;
import ca.infodata.ofys.ui.person.patient.simpleview.CallbackMessageDialog;
import ca.infodata.ofys.ui.person.patient.simpleview.FlagControl;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PatientAlertFlagControl
extends FlagControl {
    private XPatientValue patientAlert;

    public PatientAlertFlagControl(Composite parent, XPatientValue patientAlert, FormToolkit toolkit) {
        super(parent, PatientAlertFlagControl.getImage(), Messages.getString((String)"PATIENT_ALERTS.TOOLTIP", (String[])new String[0]), toolkit);
        this.patientAlert = patientAlert;
    }

    private static Image getImage() {
        Image image = ResourceGetter.getImage((String)"images/flags/warning_red_24.png");
        image = ResourceGetter.getScaledImageFixed((Image)image, (float)20.0f, (float)20.0f);
        return image;
    }

    @Override
    public void onClick() {
        String oValue = this.patientAlert.value;
        if (StringUtils.isNotBlank((String)oValue)) {
            int r;
            String splitter = oValue.substring(0, 1);
            String[] split = oValue.substring(1).split(splitter);
            boolean haveChange = false;
            int i = 0;
            while (i < split.length) {
                PatientAlertDialog pad = new PatientAlertDialog(this.getShell(), split[i]);
                r = pad.open();
                if (r != 0) {
                    split[i] = null;
                    haveChange = true;
                }
                ++i;
            }
            if (haveChange) {
                String newValue = "";
                String[] stringArray = split;
                int n = split.length;
                r = 0;
                while (r < n) {
                    String s = stringArray[r];
                    if (StringUtils.isNotBlank((String)s)) {
                        newValue = String.valueOf(newValue) + splitter + s;
                    }
                    ++r;
                }
                this.patientAlert.setValue(newValue);
                SaveCallback callback = new SaveCallback(Application.get().getGlobalInstances().getSession(), (IStatusHandler)JustLogStatusHandler.getInstance());
                try {
                    PatientValueAccessorClient.getInstance().save(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), callback, (IDataObject)this.patientAlert, false);
                }
                catch (CannotConnectToServerException e) {
                    Logger.getLogger(BaseVerySimplePatientControl.class.getName()).log(Level.WARNING, "Unable to save new states of patient alerts.", e);
                }
            }
        } else {
            CallbackMessageDialog dialog = this.newCallbackCompositeDialog(Messages.getString((String)"PATIENT_ALERTS.TOOLTIP", (String[])new String[0]));
            dialog.buildAndOpen();
            dialog.getCallbackComposite().showLoadedCompositeInSwtThread(new ReturnObject("Aucune alerte"));
        }
    }
}

