/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.editor;

import apple.finder.search.ui.AbstractRow;
import apple.finder.search.ui.AppleFinderGrid;
import apple.finder.search.ui.GroupRow;
import apple.finder.search.ui.IAppleFinderGridFactory;
import apple.finder.search.ui.ICriteriaField;
import apple.finder.search.ui.ICriteriaRowFactory;
import apple.finder.search.ui.IGetFactory;
import apple.finder.search.ui.ISetFactory;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CommonAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.search.XSearchOrder;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.IDeleteablePart;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.IAppleFinderGridFactory2;
import ca.infodata.ofys.ui.person.patient.search.XmlGetFactory;
import ca.infodata.ofys.ui.person.patient.search.XmlSetFactory;
import ca.infodata.ofys.ui.person.patient.search.editor.ChooseTemplateDialog;
import ca.infodata.ofys.ui.person.patient.search.menu.TemplateInput;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.part.EditorPart;

public class SearchTemplateEditor
extends EditorPart
implements IAppleFinderGridFactory2,
IDeleteablePart,
IReusableEditor {
    private static final Logger logger = Logger.getLogger(SearchTemplateEditor.class.getName());
    public static final String PATIENT_SEARCH_CRITERIA_ID = "ca.infodata.ofys.ui.person.patientSearchCriteria";
    private Map<ICriteriaField, ICriteriaRowFactory> fields;
    private Map<ICriteriaField, AbstractCriteria> fields2;
    private ScrolledForm form;
    private MyText txtName;
    private AppleFinderGrid grid;
    private MyButton btnUseOrder;
    private MyButton btnUseTemplate;
    private MyButton btnClear;
    private boolean dirty;
    private boolean ignore;

    public void createPartControl(final Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        final FormToolkit toolkit = UI.createToolKit((Widget)parent);
        this.form = toolkit.createScrolledForm(parent);
        this.form.getBody().setLayout((Layout)new FormLayout());
        this.form.setAlwaysShowScrollBars(true);
        this.form.getHorizontalBar().setVisible(false);
        final Composite compMain = new Composite(this.form.getBody(), 0);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                toolkit.dispose();
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        data.width = this.form.getShell().getSize().x / 4 * 3;
        data.bottom = new FormAttachment(100);
        compMain.setLayoutData((Object)data);
        toolkit.adapt(compMain);
        if (compMain != null) {
            parent.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    FormData data = new FormData();
                    data.left = new FormAttachment(0);
                    data.top = new FormAttachment(0);
                    SearchTemplateEditor.this.form.getVerticalBar().setVisible(true);
                    data.width = parent.getSize().x - 18;
                    data.bottom = new FormAttachment(100);
                    compMain.setLayoutData((Object)data);
                }
            });
        }
        this.createMyControl(compMain, toolkit);
    }

    public void createMyControl(Composite parent, FormToolkit toolkit) {
        MyLabel lblName = new MyLabel(parent, Messages.getString((String)"NOM", (String[])new String[0]), 16384, toolkit);
        this.txtName = new MyText(parent, toolkit, 2052);
        this.txtName.setFont(ResourceGetter.getFontNormal((int)5));
        ControlDecorator.decorateWithRequiredField((Control)this.txtName.getControl());
        this.btnUseOrder = new MyButton(parent, "Utiliser une demande", 8, toolkit);
        this.btnUseOrder.setToolTipText("Utiliser une demande existante comme source");
        this.btnUseTemplate = new MyButton(parent, "Utiliser un mod\u00e8le", 8, toolkit);
        this.btnUseTemplate.setToolTipText("Utiliser un mod\u00e8le existant comme source");
        this.btnClear = new MyButton(parent, "Remettre \u00e0 z\u00e9ro", 8, toolkit);
        this.grid = new AppleFinderGrid(parent, 0){

            public void layoutRows() {
                super.layoutRows();
                if (!this.isDeferRowLayout()) {
                    SearchTemplateEditor.this.getForm().reflow(true);
                }
            }

            public void setDirty(boolean dirty) {
                super.setDirty(dirty);
                if (dirty && !SearchTemplateEditor.this.ignore) {
                    SearchTemplateEditor.this.setDirty(true);
                }
            }
        };
        this.grid.setFactory((IAppleFinderGridFactory)this);
        this.btnUseOrder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchTemplateEditor.this.querySourceFromOrders();
            }
        });
        this.btnUseTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchTemplateEditor.this.querySourceFromTemplates();
            }
        });
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchTemplateEditor.this.doClear();
                SearchTemplateEditor.this.setDirty(true);
            }
        });
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SearchTemplateEditor.this.ignore) {
                    return;
                }
                SearchTemplateEditor.this.getTemplate().setName(SearchTemplateEditor.this.txtName.getText().trim());
                SearchTemplateEditor.this.setDirty(true);
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        lblName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(25);
        this.btnUseOrder.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(this.btnUseOrder.getControl());
        data.right = new FormAttachment(50);
        this.btnUseTemplate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(75, 2);
        data.right = new FormAttachment(100);
        this.btnClear.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnUseOrder.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.grid.setLayoutData((Object)data);
        this.showDataObject(this.getTemplate());
    }

    protected void querySourceFromTemplates() {
        try {
            List list = TemplateAccessorClient.getInstance().find(XCompletionProposalType.PATIENT_COMPLEX_SEARCH, null);
            ChooseTemplateDialog dialog = new ChooseTemplateDialog(this.getSite().getShell(), -1);
            dialog.setModel(list);
            if (dialog.open() == 0) {
                XTemplate template = dialog.getSelectedTemplate();
                this.updateGrid(template);
                this.setDirty(true);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
            MessageUtil.unexpectedExceptionMsg((Shell)this.getSite().getShell(), (Exception)e);
        }
    }

    protected void querySourceFromOrders() {
        try {
            List list = CommonAccessorClient.getInstance().findSearchOrderSync(Application.get().getGlobalInstances().getSession());
            ArrayList<XTemplate> list2 = new ArrayList<XTemplate>();
            for (XSearchOrder order : list) {
                XTemplate template = new XTemplate();
                template.setName(order.getName());
                template.setText(order.getTemplateXml());
                template.setId(order.getTemplateId());
                list2.add(template);
            }
            ChooseTemplateDialog dialog = new ChooseTemplateDialog(this.getSite().getShell(), -1);
            dialog.setModel(list2);
            if (dialog.open() == 0) {
                XTemplate template = dialog.getSelectedTemplate();
                this.updateGrid(template);
                this.setDirty(true);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
            MessageUtil.unexpectedExceptionMsg((Shell)this.getSite().getShell(), (Exception)e);
        }
    }

    private void updateGrid(XTemplate template) {
        if (template == null) {
            return;
        }
        try {
            this.grid.setGroup((ISetFactory)new XmlSetFactory(this, template.getText()));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to update grid with template " + StringUtils.safeToString((Logger)logger, (Object)template));
            MessageUtil.show((Shell)this.getSite().getShell(), (Exception)e);
        }
    }

    public XTemplate getTemplate() {
        TemplateInput input = (TemplateInput)this.getEditorInput();
        return input.getTemplate();
    }

    public Set<ICriteriaField> getFields() {
        if (this.fields == null) {
            this.fields2 = new HashMap<ICriteriaField, AbstractCriteria>();
            this.fields = new TreeMap<ICriteriaField, ICriteriaRowFactory>(new Comparator<ICriteriaField>(){

                @Override
                public int compare(ICriteriaField o1, ICriteriaField o2) {
                    return StringUtils.compareAscii((String)o1.getText(), (String)o2.getText());
                }
            });
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(PATIENT_SEARCH_CRITERIA_ID);
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractCriteria factory;
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    AbstractCriteria field = factory = (AbstractCriteria)e.createExecutableExtension("factory");
                    this.fields.put(field, factory);
                    this.fields2.put(field, factory);
                    ++n2;
                }
            }
            catch (CoreException ex) {
                logger.log(Level.WARNING, "Failed to load patient search criteria extensions for " + this.getClass().getName(), ex);
            }
        }
        return this.fields.keySet();
    }

    public ICriteriaRowFactory get(ICriteriaField field) {
        return this.fields.get(field);
    }

    @Override
    public AbstractCriteria getCriteria(ICriteriaField field) {
        return this.fields2.get(field);
    }

    protected void doClear() {
        this.grid.deleteAll();
        try {
            this.grid.setDeferRowLayout(true);
            GroupRow g = this.grid.addGroup(null);
            this.grid.addCriteria((AbstractRow)g);
        }
        finally {
            this.grid.setDeferRowLayout(false);
        }
        this.grid.setDirty(false);
    }

    public void setFocus() {
    }

    public void doDelete(IProgressMonitor monitor) {
        TemplateAccessorClient.getInstance().delete(this.getTemplate().getId());
        this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            XmlGetFactory xmlFactory = new XmlGetFactory(this.fields2);
            this.grid.getGroup((IGetFactory)xmlFactory);
            String xml = xmlFactory.toXml();
            XTemplate template = this.getTemplate();
            template.setText(xml);
            template.setType2(XCompletionProposalType.PATIENT_COMPLEX_SEARCH);
            template.setType(Integer.valueOf(XCompletionProposalType.PATIENT_COMPLEX_SEARCH.id));
            XTemplate t = TemplateAccessorClient.getInstance().save(template);
            template.setId(t.getId());
            this.setDirty(false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to save template", e);
            throw new RuntimeException(e);
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        TemplateInput cfr_ignored_0 = (TemplateInput)input;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setTitleImage(ResourceGetter.getImage((String)"images/search-icon32.png"));
    }

    public void showDataObject(XTemplate template) {
        try {
            this.ignore = true;
            if (template == null) {
                this.setPartName("Mod\u00e8le --- ");
                this.txtName.clear();
                this.txtName.setEnabled(false);
                this.grid.deleteAll();
                this.grid.setEnabled(false);
            } else {
                this.setPartName("Mod\u00e8le --- " + StringUtils.defaultString((String)template.getName(), (String)""));
                this.txtName.setEnabled(true);
                this.txtName.setText(template.getName());
                try {
                    this.grid.setEnabled(true);
                    XmlSetFactory factory = new XmlSetFactory(this, template.getText());
                    this.grid.setGroup((ISetFactory)factory);
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Failed to load xml into grid for template " + StringUtils.safeToString((Logger)logger, (Object)template));
                    MessageUtil.bugMsg((Shell)this.getSite().getShell(), (String)"\u00c9chec du chargement de la grille de recherche");
                    this.grid.setEnabled(false);
                    this.txtName.setEnabled(false);
                }
            }
        }
        finally {
            this.ignore = false;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean dirty) {
        boolean diff = dirty ^ this.dirty;
        this.dirty = dirty;
        if (diff) {
            this.firePropertyChange(257);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected SharedScrolledComposite getForm() {
        return this.form;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.form != null) {
            this.showDataObject(this.getTemplate());
        }
    }

    public boolean isDeleteAllowed() {
        XTemplate template = this.getTemplate();
        return template != null && template.getId() != null && !this.isDirty();
    }
}

