/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search;

import apple.finder.search.ui.ICriteriaOperator;
import ca.infodata.ofys.data.middle.dataobjects.search.CID;
import ca.infodata.ofys.data.middle.dataobjects.search.Operator;
import ca.infodata.ofys.data.middle.dataobjects.search.ServerCriteria;
import ca.infodata.ofys.ui.controls.EasyLabelProvider;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.popup.CheckListPopupFeature;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.CriteriaOperator;
import ca.infodata.util1.JoinList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractChoiceCriteria
extends AbstractCriteria {
    private EasyLabelProvider<Object> provider;
    private Object defaultChoice;
    private boolean allowNullValue;

    public AbstractChoiceCriteria(CID cid) {
        super(cid);
    }

    public AbstractChoiceCriteria(CID cid, EasyLabelProvider<Object> provider, Object defaultChoice) {
        super(cid);
        this.provider = provider;
        this.defaultChoice = defaultChoice;
    }

    public String getOperatorPrefix() {
        return null;
    }

    public List<? extends ICriteriaOperator> getOperators() {
        List<CriteriaOperator> list = Arrays.asList(CriteriaOperator.IS_NULL, CriteriaOperator.EQ, CriteriaOperator.IN);
        return list;
    }

    public ICriteriaOperator getDefaultOperator() {
        return CriteriaOperator.EQ;
    }

    public Object createValueControl(Composite parent, ICriteriaOperator operator, Object valueReference) {
        if (this.operatorIn(operator, CriteriaOperator.EQ)) {
            final Set list = (Set)(valueReference == null ? new HashSet() : valueReference);
            final MyCombo combo = new MyCombo(parent, 8);
            combo.setLabelProvider(this.provider);
            combo.setItems((Collection)this.provider.getKeys());
            if (list.isEmpty()) {
                if (this.isAllowNullValue() || this.defaultChoice != null) {
                    list.add(this.defaultChoice);
                    combo.select(this.defaultChoice);
                }
            } else {
                combo.select(list.iterator().next());
            }
            combo.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    list.clear();
                    Object selection = combo.getSelection();
                    if (AbstractChoiceCriteria.this.isAllowNullValue() || selection != null) {
                        list.add(selection);
                    }
                }
            });
            return list;
        }
        if (this.operatorIn(operator, CriteriaOperator.IN)) {
            final Set list = (Set)(valueReference == null ? new HashSet() : valueReference);
            final Label label = new Label(parent, 18432);
            label.setText(this.computeText(list));
            CheckListPopupFeature<Object> feature = new CheckListPopupFeature<Object>((Control)label){

                protected String getTextForItem(Object e) {
                    return AbstractChoiceCriteria.this.provider.get(e);
                }

                protected List<Object> getItems() {
                    return AbstractChoiceCriteria.this.provider.getKeys();
                }

                protected boolean getChecked(Object e) {
                    return list.contains(e);
                }

                public void checked(Object e, boolean checked) {
                    if (checked) {
                        list.add(e);
                    } else {
                        list.remove(e);
                    }
                    label.setText(AbstractChoiceCriteria.this.computeText(list));
                }
            };
            label.addMouseListener((MouseListener)new MouseAdapter((CheckListPopupFeature)feature){
                private final /* synthetic */ CheckListPopupFeature val$feature;
                {
                    this.val$feature = checkListPopupFeature;
                }

                public void mouseDown(MouseEvent e) {
                    this.val$feature.openPopupWindow();
                }
            });
            return list;
        }
        return null;
    }

    protected String computeText(Set<Object> list) {
        if (list.isEmpty()) {
            return "Cliquez ici pour ouvrir le dialogue de s\u00e9lection";
        }
        JoinList joinList = new JoinList(" , ");
        for (Object e2 : list) {
            joinList.add((CharSequence)this.provider.get(e2));
        }
        return joinList.toString();
    }

    public EasyLabelProvider<Object> getProvider() {
        return this.provider;
    }

    public void setProvider(EasyLabelProvider<Object> provider) {
        this.provider = provider;
    }

    public Object getDefaultChoice() {
        return this.defaultChoice;
    }

    public void setDefaultChoice(Object defaultChoice) {
        this.defaultChoice = defaultChoice;
    }

    @Override
    public ServerCriteria toCriteria(ICriteriaOperator operator, Object valueReference) {
        ServerCriteria sc = new ServerCriteria();
        sc.id = this.cid;
        if (valueReference != null) {
            Set list = (Set)valueReference;
            if (list.size() == 1) {
                sc.operator = Operator.EQ;
                sc.value = this.criteriaValueOf(list.iterator().next());
            } else {
                sc.operator = Operator.IN;
                HashSet<Object> list2 = new HashSet<Object>();
                for (Object e : list) {
                    list2.add(this.criteriaValueOf(e));
                }
                sc.value = list2;
            }
        } else {
            sc.operator = ((CriteriaOperator)operator).getOperator();
            sc.value = null;
        }
        return sc;
    }

    protected Object criteriaValueOf(Object e) {
        return e;
    }

    @Override
    public Map<String, String> valueToXml(ICriteriaOperator operator, Object valueReference) {
        Collection c = (Collection)valueReference;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (c != null) {
            int i = 0;
            for (Object e : c) {
                map.put("e" + String.valueOf(i++), this.xmlValueOf(e));
            }
        }
        return map;
    }

    protected String xmlValueOf(Object e) {
        return String.valueOf(e);
    }

    @Override
    public Collection<Object> xmlToValue(Map<String, String> map) {
        HashSet<Object> set = new HashSet<Object>();
        Collection<String> values = map.values();
        for (String s : values) {
            set.add(this.objectValueOf(s));
        }
        set.retainAll(this.provider.getKeys());
        return set;
    }

    protected Object objectValueOf(String xmlValue) {
        return xmlValue;
    }

    public boolean isAllowNullValue() {
        return this.allowNullValue;
    }

    public void setAllowNullValue(boolean allowNullValue) {
        this.allowNullValue = allowNullValue;
    }
}

