/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.patient.XFusionPatient;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.search.PatientSearchView;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;

public class FusionPatientEditor
extends BaseEditor {
    private static final String CLIENT = Messages.getString((String)"CLIENT", (String[])new String[0]);
    private static final String DDN = Messages.getString((String)"DDN", (String[])new String[0]);
    private static final String SEX = Messages.getString((String)"SEXE", (String[])new String[0]);
    private static final String DOSSIER = Messages.getString((String)"DOSSIER", (String[])new String[0]);
    private static final String _PATIENT_RACINE = Messages.getString((String)"FusionPatientEditor.PATIENT_RACINE", (String[])new String[0]);
    private static final String AJOUTER_UN_CLIENT = Messages.getString((String)"FusionPatientEditor.AJOUTER_UN_CLIENT", (String[])new String[0]);
    private Table tblPatients;
    private MyLabel lblRootPatient;
    private MyButton cmdSearchPatient;
    private IReferenceControl searchPatientSelectionReferenceControl;

    public void createMyControl(Composite parent) {
        this.lblRootPatient = new MyLabel(parent, String.valueOf(_PATIENT_RACINE) + " : ", 0, this.toolkit);
        this.cmdSearchPatient = new MyButton(parent, AJOUTER_UN_CLIENT, 8, this.toolkit);
        this.tblPatients = this.toolkit.createTable(parent, 2084);
        this.tblPatients.setHeaderVisible(true);
        this.addColumn(this.tblPatients, 200, CLIENT);
        this.addColumn(this.tblPatients, 90, SEX);
        this.addColumn(this.tblPatients, 90, DDN);
        this.addColumn(this.tblPatients, 80, DOSSIER);
        this.searchPatientSelectionReferenceControl = new IReferenceControl(){

            public void callback(Object o) {
                XFusionPatient fusion = FusionPatientEditor.this.getFusionPatient();
                if (fusion != null) {
                    FusionPatientEditor.this.addPatientToTable(FusionPatientEditor.this.getPatient(o), false);
                }
                FusionPatientEditor.this.checkDirty();
            }
        };
        this.cmdSearchPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FusionPatientEditor.this.btnSearchPatientSelected();
            }
        });
        this.tblPatients.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = FusionPatientEditor.this.tblPatients.getItems();
                boolean updated = false;
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    updated = item.getChecked() ? FusionPatientEditor.this.getFusionPatient().getTargetPatients().add((IPatient)item.getData()) || updated : FusionPatientEditor.this.getFusionPatient().getTargetPatients().remove(item.getData()) || updated;
                    ++n2;
                }
                if (updated) {
                    FusionPatientEditor.this.getFusionPatient().setUpdated();
                    FusionPatientEditor.this.checkDirty();
                }
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginTop = 10;
        layout.marginWidth = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblRootPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblRootPatient.getControl());
        data.left = new FormAttachment(0);
        this.cmdSearchPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.cmdSearchPatient.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.tblPatients.setLayoutData((Object)data);
    }

    private void addColumn(Table table, int width, String title) {
        TableColumn tblCol = new TableColumn(table, 2048);
        tblCol.setWidth(width);
        tblCol.setText(title);
    }

    private void btnSearchPatientSelected() {
        PatientSearchView view = (PatientSearchView)BaseSearchView.openView(PatientSearchView.class);
        view.setSelectionReferenceControl(this.searchPatientSelectionReferenceControl);
    }

    private IPatient getPatient(Object object) {
        if (object instanceof IPatient) {
            return (IPatient)object;
        }
        if (object instanceof IPatientRelated) {
            return ((IPatientRelated)object).getPatient();
        }
        return null;
    }

    public void setToolBarStatus() {
    }

    private XFusionPatient getFusionPatient() {
        IEditorInput input = this.getEditorInput();
        return (XFusionPatient)(input == null ? null : ((EditorInput)input).getCompleteDataObject());
    }

    public void showDataObject() {
        this.tblPatients.removeAll();
        XFusionPatient fusion = this.getFusionPatient();
        if (fusion == null) {
            this.tblPatients.setEnabled(false);
            this.cmdSearchPatient.setEnabled(false);
            this.lblRootPatient.setText(_PATIENT_RACINE);
        } else {
            this.tblPatients.setEnabled(true);
            this.cmdSearchPatient.setEnabled(true);
            IPatient rootPatient = fusion.getRootPatient();
            if (rootPatient == null) {
                this.lblRootPatient.setText(_PATIENT_RACINE);
            } else {
                this.lblRootPatient.setText(String.valueOf(_PATIENT_RACINE) + " : " + rootPatient.getName());
            }
            Set targetPatients = fusion.getTargetPatients();
            if (targetPatients != null) {
                for (IPatient patient : targetPatients) {
                    this.addPatientToTable(patient, true);
                }
            }
        }
        this.setToolBarStatus();
    }

    private void addPatientToTable(IPatient patient, boolean checked) {
        if (patient != null) {
            TableItem item = new TableItem(this.tblPatients, 0);
            item.setData((Object)patient);
            item.setChecked(checked);
            String[] text = new String[]{StringUtils.defaultString((String)patient.getName()), StringUtils.defaultString((String)patient.getGender()), LocalDateFormat.nullSafeFormat((LocalDate)patient.getBirthDate(), (String)FormatDateProvider.getFormatDate().toString()), StringUtils.defaultString((String)patient.getPatientRecordNumber())};
            item.setText(text);
        }
    }

    public Image getEditorTitleImage() {
        return null;
    }

    public void initDataOverride() {
        IDataObject dataObject = ((EditorInput)this.getEditorInput()).getDataObject();
        if (dataObject instanceof IPatient) {
            if (dataObject.getId() == null) {
                throw new IllegalArgumentException("Patient must have an id != null");
            }
            JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(final ReturnObject response) {
                    if (response != null && response.getObj() instanceof XFusionPatient) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                FusionPatientEditor.this.initializeCompleteDataObject((EditableDataObject)((XFusionPatient)response.getObj()));
                            }
                        });
                    }
                }
            };
            try {
                PatientAccessorClient.getInstance().getFusionPatient(this.getUniqueKey(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, dataObject.getId().intValue());
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                callback.kill();
            }
            catch (Exception e) {
                callback.kill();
                Log.severe((String)"Erreur", (Exception)e);
            }
        } else if (dataObject instanceof XFusionPatient) {
            this.initializeCompleteDataObject((EditableDataObject)((XFusionPatient)dataObject));
        }
    }

    public String getEditorTitle() {
        return Messages.getString((String)"FUSION/DEFUSION_DE_CLIENT", (String[])new String[0]);
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return PatientAccessorClient.getInstance();
    }

    public boolean isDataDirty() {
        return this.getFusionPatient() != null && this.getFusionPatient().isDirty();
    }
}

