/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.employee;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.EmployeeAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XEmployee;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IVariablesReplacer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.data.middle.dataobjects.variablereplacer.PersonVariableReplacer;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonMultiEditor;
import ca.infodata.ofys.ui.person.employee.EmployeeEditor;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;

public class EmployeeMultiEditor
extends PersonMultiEditor {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.person.employee.EmployeeMultiEditor");
    private EmployeeEditor employeeEditor;
    private int iNextPage;

    public void createMyPages() throws PartInitException {
        this.iNextPage = 0;
        this.employeeEditor = new EmployeeEditor(this);
        this.addPage(this.employeeEditor, this.getEditorInput());
        this.setPageText(this.iNextPage, GENERAL);
        this.setPageImage(this.iNextPage, ResourceGetter.getImage((String)"images/pen.gif"));
        ++this.iNextPage;
    }

    public XEmployee getEmployee() {
        return (XEmployee)this.getPerson();
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return EmployeeAccessorClient.getInstance();
    }

    public void initDataOverride() {
        if (((EditorInput)this.getEditorInput()).getDataObject() instanceof XBaseEmployee) {
            XBaseEmployee baseEmployee = (XBaseEmployee)((EditorInput)this.getEditorInput()).getDataObject();
            if (baseEmployee.getId() == null) {
                XEmployee patient = new XEmployee();
                patient.initialize();
                this.initializeCompleteDataObject((EditableDataObject)patient);
            } else {
                try {
                    EmployeeAccessorClient.getInstance().getEmployee(this.getUniqueKey(), Application.get().getGlobalInstances().getSession(), (ICallback)new JobCallback("getEmployee", (IStatusHandler)DefaultStatusHandler.getInstance()){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    EmployeeMultiEditor.this.initializeCompleteDataObject((EditableDataObject)response.getObj());
                                }
                            });
                        }
                    }, baseEmployee.getId().intValue());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to get employee: " + StringUtils.safeToString((Logger)logger, (Object)baseEmployee), e);
                }
            }
        } else if (((EditorInput)this.getEditorInput()).getDataObject() instanceof XEmployee) {
            this.initializeCompleteDataObject((EditableDataObject)((EditorInput)this.getEditorInput()).getDataObject());
        }
    }

    public boolean isDataDirty() {
        return this.getEmployee().isDirty();
    }

    public IVariablesReplacer getVariablesReplacerNewInstance() {
        return new PersonVariableReplacer();
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/employee.gif");
    }

    public String getEditorTitle() {
        XEmployee c = this.getEmployee();
        if (c != null) {
            if (c.isNewOrNewUpdated()) {
                return Messages.getString((String)"NOUVEL_EMPLOYE", (String[])new String[0]);
            }
            return c.getName();
        }
        EditorInput input = (EditorInput)this.getEditorInput();
        if (input != null && input.getDataObject() instanceof XBaseEmployee) {
            return ((XBaseEmployee)input.getDataObject()).getName();
        }
        return Messages.getString((String)"EMPLOYE", (String[])new String[0]);
    }

    @Override
    protected boolean showInactivationCondition(boolean forDcd) {
        return true;
    }

    @Override
    protected String getInactiveText() {
        return null;
    }

    @Override
    protected XPatientInactiveRaison getInactiveRaison() {
        return null;
    }

    @Override
    public void setInactiveRaison(XPatientInactiveRaison r) {
    }
}

