/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ProfessionnalAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.ObjectCache;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ProfCache
extends ObjectCache<XProfessionnal> {
    private static final Logger logger = Logger.getLogger(ProfCache.class.getName());
    private static final String PROF_PERSON = "prps";
    private static final String PROF = "prof";
    private IConsumerListenerImplementation listener = new IConsumerListenerImplementation();

    public ProfCache() {
        super(PROF);
        Application.get().getGlobalInstances().getNotificationSystem().addListener((IConsumerListener)this.listener);
    }

    protected void load(int uniqueKey, XSession session, ICallback callback) throws Exception {
        CompletionComboAccessorClient.getInstance().findAllAsync(session, callback, XProfessionnal.class.getName());
    }

    protected void add(Map<ObjectCache.Key, XProfessionnal> map, XProfessionnal e) {
        if (e != null && e.getId() != null) {
            map.put(new ObjectCache.Key(PROF, e.getId()), e);
            map.put(new ObjectCache.Key(PROF_PERSON, e.getIdPerson()), e);
        }
    }

    public XProfessionnal getById(Integer id, boolean logIfNotFound) {
        return this.getById(id, logIfNotFound, true);
    }

    public XProfessionnal getById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XProfessionnal)this.get(new ObjectCache.Key(PROF, id), logIfNotFound, mustTryToFindServer);
    }

    public XProfessionnal getByNoProf(String noprof) {
        if (noprof == null) {
            return null;
        }
        Optional<XProfessionnal> first = this.getAll().filter(prof -> prof.code.startsWith(noprof)).findFirst();
        return first.orElse(null);
    }

    public XProfessionnal getByIdPerson(Integer id, boolean logIfNotFound) {
        return this.getByIdPerson(id, logIfNotFound, true);
    }

    public XProfessionnal getByIdPerson(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XProfessionnal)this.get(new ObjectCache.Key(PROF_PERSON, id), logIfNotFound, mustTryToFindServer);
    }

    protected XProfessionnal loadSync(XSession session, ObjectCache.Key key) throws Exception {
        if (key == null) {
            return null;
        }
        if (PROF.equals(key.type)) {
            return (XProfessionnal)ProfessionnalAccessorClient.getInstance().getProfessionnalSync(session, key.id.intValue(), false);
        }
        if (PROF_PERSON.equals(key.type)) {
            return (XProfessionnal)ProfessionnalAccessorClient.getInstance().getProfessionnalByIdPersonSync(session, key.id.intValue(), false);
        }
        return null;
    }

    public Stream<XProfessionnal> getAll() {
        ArrayList<XProfessionnal> all = new ArrayList<XProfessionnal>();
        for (Map.Entry es : this.getMap().entrySet()) {
            if (!((ObjectCache.Key)es.getKey()).type.startsWith(PROF)) continue;
            all.add((XProfessionnal)es.getValue());
        }
        return all.stream().sorted();
    }

    public Stream<XProfessionnal> getAllTreatingPhysicians() {
        return this.getAll().filter(prof -> prof.isProfTx);
    }

    protected void loadSync(int uniqueKey, XSession session, ICallback callback) throws Exception {
        CompletionComboAccessorClient.getInstance().findAll(session, callback, XProfessionnal.class.getName());
    }

    private final class IConsumerListenerImplementation
    implements IConsumerListener {
        private IConsumerListenerImplementation() {
        }

        public void handle(DataObjectUpdatedNotification notification) {
            try {
                IDataObject object;
                if (notification != null && (object = notification.getObject()) instanceof XProfessionnal) {
                    ProfCache.this.add((Map<ObjectCache.Key, XProfessionnal>)ProfCache.this.getMap(), (XProfessionnal)object);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in IConsumerListenerImplementation.handle", e);
            }
        }

        public void handleOther(Notification notification) {
        }

        public void forceRefresh() {
            try {
                ProfCache.this.reload(true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in ProfCache.forceRefresh", e);
            }
        }
    }
}

