/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.ui.controls.PartAdapter2;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.search.PatientSearchView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class PersonUiPluginStartup
implements IStartup {
    public void earlyStartup() {
        System.out.println("PersonUiPluginStartup.earlyStartup()");
        final PersonUiPlugin plugin = PersonUiPlugin.getDefault();
        final IWorkbench workbench = plugin.getWorkbench();
        final IWorkbenchWindow[] activeWorkbenchWindow = new IWorkbenchWindow[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                activeWorkbenchWindow[0] = workbench.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow[0] == null) {
                    activeWorkbenchWindow[0] = workbench.getWorkbenchWindows()[0];
                }
            }
        });
        ISelectionService service = activeWorkbenchWindow[0].getSelectionService();
        service.addPostSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof PatientMultiEditor) {
                    XPatient patient = ((PatientMultiEditor)part).getPatient();
                    if (patient != null) {
                        plugin.setCurrentPatient((IPatient)patient);
                    } else {
                        IDataObject basePatient = ((PatientMultiEditor)part).getBasePatient();
                        if (basePatient instanceof IPatient) {
                            plugin.setCurrentPatient((IPatient)basePatient);
                        } else {
                            plugin.setCurrentPatient2(basePatient);
                        }
                    }
                } else if (part instanceof IPatientRelated) {
                    IPatient element = ((IPatientRelated)part).getPatient();
                    if (part instanceof PatientSearchView) {
                        PatientSearchView searchView = (PatientSearchView)part;
                        if (searchView.getReferenceControl() == null) {
                            plugin.setCurrentPatient(element);
                        }
                    } else {
                        plugin.setCurrentPatient(element);
                    }
                } else if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object element = structuredSelection.getFirstElement();
                    if (element instanceof IPatientRelated) {
                        IPatient patient = ((IPatientRelated)element).getPatient();
                        plugin.setCurrentPatient(patient);
                    } else if (element instanceof IPatient) {
                        plugin.setCurrentPatient((IPatient)element);
                    }
                } else if (selection instanceof IPatientRelated) {
                    IPatient element = ((IPatientRelated)selection).getPatient();
                    plugin.setCurrentPatient(element);
                }
            }
        });
        activeWorkbenchWindow[0].getPartService().addPartListener((IPartListener2)new PartAdapter2(){

            public void partActivated(IWorkbenchPartReference rpart) {
                this.process(plugin, rpart);
            }

            public void partInputChanged(IWorkbenchPartReference rpart) {
                this.process(plugin, rpart);
            }

            private void process(PersonUiPlugin plugin2, IWorkbenchPartReference rpart) {
                IWorkbenchPart part = rpart.getPart(false);
                if (part instanceof PatientMultiEditor) {
                    XPatient patient = ((PatientMultiEditor)part).getPatient();
                    if (patient != null) {
                        plugin2.setCurrentPatient((IPatient)patient);
                    } else {
                        IDataObject basePatient = ((PatientMultiEditor)part).getBasePatient();
                        if (basePatient instanceof IPatient) {
                            plugin2.setCurrentPatient((IPatient)basePatient);
                        } else {
                            plugin2.setCurrentPatient2(basePatient);
                        }
                    }
                } else if (part instanceof IPatientRelated) {
                    IPatient patient = ((IPatientRelated)part).getPatient();
                    plugin2.setCurrentPatient(patient);
                }
            }

            public void partClosed(IWorkbenchPartReference rpart) {
                IDataObject basePatient;
                IWorkbenchPart part = rpart.getPart(false);
                if (part instanceof PatientMultiEditor && ((basePatient = ((PatientMultiEditor)part).getBasePatient()) == null || basePatient.getId() == null)) {
                    plugin.setCurrentPatient(null, true);
                }
            }
        });
    }
}

