/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.nightlabs.util.DeadLockException;
import org.nightlabs.util.RWLock;

public class RWLockMan {
    private static final Logger logger = Logger.getLogger((String)RWLockMan.class.getName());
    private static RWLockMan rwLockMan;
    private Object mutex = new Object();
    private HashMap heldLocksToThreadsMap = new HashMap();
    private HashMap threadsToHeldLocksMap = new HashMap();
    private HashMap waitingThreadsToLocksMap = new HashMap();
    public static final byte MODE_READ = 120;
    public static final byte MODE_WRITE = 121;

    public static synchronized RWLockMan getRWLockMan() {
        if (rwLockMan == null) {
            rwLockMan = new RWLockMan();
        }
        return rwLockMan;
    }

    protected RWLockMan() {
    }

    public static String modeToString(byte mode) {
        if (mode == 120) {
            return "MODE_READ";
        }
        if (mode == 121) {
            return "MODE_WRITE";
        }
        throw new IllegalArgumentException("unknown mode: " + mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginWaitForLock(RWLock rwLock, byte mode) throws DeadLockException {
        try {
            if (mode != 120 && mode != 121) {
                throw new IllegalArgumentException("unknown mode!");
            }
            Thread currentThread = Thread.currentThread();
            Object object = this.mutex;
            synchronized (object) {
                RWLockCounter rwLockCounter;
                HashMap<RWLock, RWLockCounter> waitingForRWLocks;
                HashMap ourHeldLocks = (HashMap)this.threadsToHeldLocksMap.get(currentThread);
                HashMap threads = (HashMap)this.heldLocksToThreadsMap.get(rwLock);
                if (threads != null) {
                    for (Thread thread : threads.keySet()) {
                        HashMap waitingForRWLocks2;
                        if (thread == currentThread || (waitingForRWLocks2 = (HashMap)this.waitingThreadsToLocksMap.get(thread)) == null || ourHeldLocks == null) continue;
                        for (RWLockCounter rwLockCounter2 : waitingForRWLocks2.values()) {
                            RWLockCounter ourHeldLockCounter = (RWLockCounter)ourHeldLocks.get(rwLockCounter2.getRWLock());
                            if (ourHeldLockCounter == null || ourHeldLockCounter.rwLockCountWrite <= 0 && rwLockCounter2.rwLockCountWrite <= 0) continue;
                            throw new DeadLockException(currentThread + ": We are about to wait for lock " + rwLock + "(" + RWLockMan.modeToString(mode) + ") which is held by thread " + thread + ". This thread is waiting for lock " + rwLockCounter2 + " which is held by us: " + ourHeldLockCounter);
                        }
                    }
                }
                if ((waitingForRWLocks = (HashMap<RWLock, RWLockCounter>)this.waitingThreadsToLocksMap.get(currentThread)) == null) {
                    waitingForRWLocks = new HashMap<RWLock, RWLockCounter>();
                    this.waitingThreadsToLocksMap.put(currentThread, waitingForRWLocks);
                }
                if ((rwLockCounter = (RWLockCounter)waitingForRWLocks.get(rwLock)) == null) {
                    rwLockCounter = new RWLockCounter(rwLock);
                    waitingForRWLocks.put(rwLock, rwLockCounter);
                }
                if (mode == 120) {
                    ++rwLockCounter.rwLockCountRead;
                } else {
                    ++rwLockCounter.rwLockCountWrite;
                }
            }
        }
        catch (RuntimeException x) {
            logger.log((Priority)Level.FATAL, (Object)("Exception in thread " + Thread.currentThread()), (Throwable)x);
            throw x;
        }
        catch (Throwable t) {
            logger.log((Priority)Level.FATAL, (Object)("Exception in thread " + Thread.currentThread()), t);
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endWaitForLock(RWLock rwLock, byte mode) {
        try {
            if (mode != 120 && mode != 121) {
                throw new IllegalArgumentException("unknown mode!");
            }
            Thread currentThread = Thread.currentThread();
            Object object = this.mutex;
            synchronized (object) {
                HashMap waitingForRWLocks = (HashMap)this.waitingThreadsToLocksMap.get(currentThread);
                if (waitingForRWLocks == null) {
                    throw new IllegalStateException(currentThread + ": No waiting locks registered for this thread! Unable to end wait for lock: " + rwLock);
                }
                RWLockCounter rwLockCounter = (RWLockCounter)waitingForRWLocks.get(rwLock);
                if (rwLockCounter == null) {
                    throw new IllegalStateException(currentThread + ": No waiting lockCounter registered for this thread! Unable to end wait for lock: " + rwLock);
                }
                if (mode == 120) {
                    --rwLockCounter.rwLockCountRead;
                } else {
                    --rwLockCounter.rwLockCountWrite;
                }
                if (rwLockCounter.rwLockCountRead == 0 && rwLockCounter.rwLockCountWrite == 0) {
                    waitingForRWLocks.remove(rwLock);
                    if (waitingForRWLocks.isEmpty()) {
                        this.waitingThreadsToLocksMap.remove(currentThread);
                    }
                }
            }
        }
        catch (RuntimeException x) {
            logger.log((Priority)Level.FATAL, (Object)("Exception in thread " + Thread.currentThread()), (Throwable)x);
            throw x;
        }
        catch (Throwable t) {
            logger.log((Priority)Level.FATAL, (Object)("Exception in thread " + Thread.currentThread()), t);
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireLock(RWLock rwLock, byte mode, int count) {
        try {
            if (mode != 120 && mode != 121) {
                throw new IllegalArgumentException("unknown mode!");
            }
            Thread currentThread = Thread.currentThread();
            Object object = this.mutex;
            synchronized (object) {
                RWLockCounter rwLockCounter;
                ThreadCounter threadCounter;
                HashMap<Thread, ThreadCounter> threads = (HashMap<Thread, ThreadCounter>)this.heldLocksToThreadsMap.get(rwLock);
                if (threads == null) {
                    threads = new HashMap<Thread, ThreadCounter>();
                    this.heldLocksToThreadsMap.put(rwLock, threads);
                }
                if ((threadCounter = (ThreadCounter)threads.get(currentThread)) == null) {
                    threadCounter = new ThreadCounter(currentThread);
                    threads.put(currentThread, threadCounter);
                }
                threadCounter.threadCount += count;
                HashMap<RWLock, RWLockCounter> heldLocks = (HashMap<RWLock, RWLockCounter>)this.threadsToHeldLocksMap.get(currentThread);
                if (heldLocks == null) {
                    heldLocks = new HashMap<RWLock, RWLockCounter>();
                    this.threadsToHeldLocksMap.put(currentThread, heldLocks);
                }
                if ((rwLockCounter = (RWLockCounter)heldLocks.get(rwLock)) == null) {
                    rwLockCounter = new RWLockCounter(rwLock);
                    heldLocks.put(rwLock, rwLockCounter);
                }
                if (mode == 120) {
                    rwLockCounter.rwLockCountRead += count;
                } else {
                    rwLockCounter.rwLockCountWrite += count;
                }
            }
        }
        catch (RuntimeException x) {
            logger.log((Priority)Level.FATAL, (Object)("Exception in thread " + Thread.currentThread()), (Throwable)x);
            throw x;
        }
        catch (Throwable t) {
            logger.log((Priority)Level.FATAL, (Object)("Exception in thread " + Thread.currentThread()), t);
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(RWLock rwLock, byte mode, int count) {
        try {
            if (mode != 120 && mode != 121) {
                throw new IllegalArgumentException("unknown mode!");
            }
            Thread currentThread = Thread.currentThread();
            Object object = this.mutex;
            synchronized (object) {
                HashMap threads = (HashMap)this.heldLocksToThreadsMap.get(rwLock);
                if (threads == null) {
                    throw new IllegalStateException(currentThread + ": No possessing threads registered for this lock! Unable to release lock: " + rwLock);
                }
                ThreadCounter threadCounter = (ThreadCounter)threads.get(currentThread);
                if (threadCounter == null) {
                    throw new IllegalStateException(currentThread + ": No thread counter registered for this lock & current thread! Unable to release lock: " + rwLock);
                }
                HashMap heldLocks = (HashMap)this.threadsToHeldLocksMap.get(currentThread);
                if (heldLocks == null) {
                    throw new IllegalStateException(currentThread + ": No held locks registered for this thread! Unable to release lock: " + rwLock);
                }
                RWLockCounter rwLockCounter = (RWLockCounter)heldLocks.get(rwLock);
                if (rwLockCounter == null) {
                    throw new IllegalStateException(currentThread + ": No lock counter registered for this thread & lock! Unable to release lock: " + rwLock);
                }
                threadCounter.threadCount -= count;
                if (mode == 120) {
                    rwLockCounter.rwLockCountRead -= count;
                } else {
                    rwLockCounter.rwLockCountWrite -= count;
                }
                if (threadCounter.threadCount == 0) {
                    threads.remove(currentThread);
                    if (threads.isEmpty()) {
                        this.heldLocksToThreadsMap.get(rwLock);
                    }
                }
                if (rwLockCounter.rwLockCountRead == 0 && rwLockCounter.rwLockCountWrite == 0) {
                    heldLocks.remove(rwLock);
                    if (heldLocks.isEmpty()) {
                        this.threadsToHeldLocksMap.remove(currentThread);
                    }
                }
            }
        }
        catch (RuntimeException x) {
            logger.log((Priority)Level.FATAL, (Object)("Exception in thread " + Thread.currentThread()), (Throwable)x);
            throw x;
        }
        catch (Throwable t) {
            logger.log((Priority)Level.FATAL, (Object)("Exception in thread " + Thread.currentThread()), t);
            throw new RuntimeException(t);
        }
    }

    private static class RWLockCounter {
        private RWLock rwLock;
        public int rwLockCountRead = 0;
        public int rwLockCountWrite = 0;

        public RWLock getRWLock() {
            return this.rwLock;
        }

        public RWLockCounter(RWLock _rwLock) {
            this.rwLock = _rwLock;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RWLockCounter{");
            sb.append(this.rwLock.toString());
            sb.append(",reads=");
            sb.append(this.rwLockCountRead);
            sb.append(",writes=");
            sb.append(this.rwLockCountWrite);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class ThreadCounter {
        private Thread thread;
        public int threadCount = 0;

        public Thread getThread() {
            return this.thread;
        }

        public ThreadCounter(Thread _thread) {
            this.thread = _thread;
        }
    }
}

