/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.nightlabs.i18n.I18nText;
import org.nightlabs.i18n.I18nTextBuffer;
import org.nightlabs.io.IOFilter;
import org.nightlabs.io.IOFilterInformationProvider;

public abstract class AbstractIOFilter
implements IOFilter {
    private String[] fileExtensions = this.initFileExtensions();
    private Map<String, I18nText> fileExtension2Description = this.initDescriptions();
    private I18nText name;
    private I18nText description;
    private IOFilterInformationProvider informationProvider;

    public AbstractIOFilter() {
        this.getName().setText(Locale.getDefault().getLanguage(), this.initName());
        this.getDescription().setText(Locale.getDefault().getLanguage(), this.initDescription());
    }

    @Override
    public String[] getFileExtensions() {
        if (this.fileExtensions == null) {
            this.fileExtensions = new String[0];
        }
        return this.fileExtensions;
    }

    @Override
    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    private Map<String, I18nText> getFileExtension2Description() {
        if (this.fileExtension2Description == null) {
            this.fileExtension2Description = new HashMap<String, I18nText>();
        }
        return this.fileExtension2Description;
    }

    @Override
    public I18nText getName() {
        if (this.name == null) {
            this.name = new I18nTextBuffer();
        }
        return this.name;
    }

    @Override
    public void setName(I18nText name) {
        this.name = name;
    }

    @Override
    public I18nText getDescription() {
        if (this.description == null) {
            this.description = new I18nTextBuffer();
        }
        return this.description;
    }

    @Override
    public void setDescription(I18nText description) {
        this.description = description;
    }

    @Override
    public I18nText getFileExtensionDescription(String fileExtension) {
        return this.getFileExtension2Description().get(fileExtension);
    }

    @Override
    public void setFileExtensionDescription(String fileExtension, I18nText description) {
        this.getFileExtension2Description().put(fileExtension, description);
    }

    @Override
    public IOFilterInformationProvider getInformationProvider() {
        return this.informationProvider;
    }

    @Override
    public void setInformationProvider(IOFilterInformationProvider provider) {
        this.informationProvider = provider;
    }

    protected abstract String[] initFileExtensions();

    protected abstract Map<String, I18nText> initDescriptions();

    protected abstract String initName();

    protected abstract String initDescription();
}

