/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.menu;

import ca.infodata.ofys.ui.menu.IDelegate;
import ca.infodata.ofys.ui.menu.TreeContent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class DecoratingColumnLabelProvider
extends ColumnLabelProvider
implements IDelegate<TreeContent> {
    private final TreeContent provider;
    private ILabelDecorator decorator;
    private final ListenerList listeners = new ListenerList();
    private IDecorationContext decorationContext = DecorationContext.DEFAULT_CONTEXT;

    public DecoratingColumnLabelProvider(TreeContent provider, ILabelDecorator decorator) {
        Assert.isNotNull((Object)((Object)provider));
        this.provider = provider;
        this.decorator = decorator;
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.provider.addListener(listener);
        if (this.decorator != null) {
            this.decorator.addListener(listener);
        }
        this.listeners.add((Object)listener);
    }

    public void dispose() {
        this.provider.dispose();
        if (this.decorator != null) {
            this.decorator.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        Image image = this.provider.getImage(element);
        if (this.decorator != null) {
            if (this.decorator instanceof LabelDecorator) {
                LabelDecorator ld2 = (LabelDecorator)this.decorator;
                Image decorated = ld2.decorateImage(image, element, this.getDecorationContext());
                if (decorated != null) {
                    return decorated;
                }
            } else {
                Image decorated = this.decorator.decorateImage(image, element);
                if (decorated != null) {
                    return decorated;
                }
            }
        }
        return image;
    }

    public ILabelDecorator getLabelDecorator() {
        return this.decorator;
    }

    @Override
    public TreeContent getDelegate() {
        return this.provider;
    }

    public String getText(Object element) {
        String text = this.provider.getText(element);
        if (this.decorator != null) {
            if (this.decorator instanceof LabelDecorator) {
                LabelDecorator ld2 = (LabelDecorator)this.decorator;
                String decorated = ld2.decorateText(text, element, this.getDecorationContext());
                if (decorated != null) {
                    return decorated;
                }
            } else {
                String decorated = this.decorator.decorateText(text, element);
                if (decorated != null) {
                    return decorated;
                }
            }
        }
        return text;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this.provider.isLabelProperty(element, property)) {
            return true;
        }
        return this.decorator != null && this.decorator.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.provider.removeListener(listener);
        if (this.decorator != null) {
            this.decorator.removeListener(listener);
        }
        this.listeners.remove((Object)listener);
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
        ILabelDecorator oldDecorator = this.decorator;
        if (oldDecorator != decorator) {
            Object element;
            int n;
            int n2;
            Object[] objectArray;
            Object[] listenerList = this.listeners.getListeners();
            if (oldDecorator != null) {
                objectArray = listenerList;
                n2 = listenerList.length;
                n = 0;
                while (n < n2) {
                    element = objectArray[n];
                    oldDecorator.removeListener((ILabelProviderListener)element);
                    ++n;
                }
            }
            this.decorator = decorator;
            if (decorator != null) {
                objectArray = listenerList;
                n2 = listenerList.length;
                n = 0;
                while (n < n2) {
                    element = objectArray[n];
                    decorator.addListener((ILabelProviderListener)element);
                    ++n;
                }
            }
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public Color getBackground(Object element) {
        return this.provider.getBackground(element);
    }

    public Font getFont(Object element) {
        return this.provider.getFont(element);
    }

    public Color getForeground(Object element) {
        return this.provider.getForeground(element);
    }

    public IDecorationContext getDecorationContext() {
        return this.decorationContext;
    }

    public void setDecorationContext(IDecorationContext decorationContext) {
        Assert.isNotNull((Object)decorationContext);
        this.decorationContext = decorationContext;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        String oldText = cell.getText();
        ILabelDecorator currentDecorator = this.getLabelDecorator();
        if (currentDecorator instanceof LabelDecorator) {
            LabelDecorator labelDecorator = (LabelDecorator)currentDecorator;
            labelDecorator.prepareDecoration(element, oldText, this.getDecorationContext());
        }
        cell.setBackground(this.getBackground(element));
        cell.setForeground(this.getForeground(element));
        cell.setFont(this.getFont(element));
        super.update(cell);
    }

    public Image getToolTipImage(Object object) {
        return this.provider.getToolTipImage(object);
    }

    public String getToolTipText(Object element) {
        return this.provider.getToolTipText(element);
    }

    public Color getToolTipBackgroundColor(Object object) {
        return this.provider.getToolTipBackgroundColor(object);
    }

    public Color getToolTipForegroundColor(Object object) {
        return this.provider.getToolTipForegroundColor(object);
    }

    public Font getToolTipFont(Object object) {
        return this.provider.getToolTipFont(object);
    }

    public Point getToolTipShift(Object object) {
        return this.provider.getToolTipShift(object);
    }

    public boolean useNativeToolTip(Object object) {
        return this.provider.useNativeToolTip(object);
    }

    public int getToolTipTimeDisplayed(Object object) {
        return this.provider.getToolTipTimeDisplayed(object);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return this.provider.getToolTipDisplayDelayTime(object);
    }

    public int getToolTipStyle(Object object) {
        return this.provider.getToolTipStyle(object);
    }
}

