/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library;

import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.h2cache.BigDataEncryptedFileSystem;
import ca.infodata.ofys.util.MiscUtil;
import java.io.File;
import java.io.FileFilter;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class PrpCache
extends BigDataEncryptedFileSystem {
    private static final Logger logger = Logger.getLogger(PrpCache.class.getName());
    private static final String prefix = "prpCache";
    private static final String suffix = ".mv.db";

    public PrpCache() throws ClassNotFoundException, SQLException {
        super(new File(LibPlugin.OFYS_HOME_FILE, prefix + System.currentTimeMillis()), MiscUtil.randomPassword((int)16));
    }

    public static void cleanupOldFilesAsync() {
        try {
            Job job = new Job("Nettoyage des vieux fichiers ... "){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        PrpCache.cleanup();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to clean cities old files", e);
                        return new Status(4, "ca.infodata.ofys.ui.library", "Erreur lors du nettoyage des vieux fichiers");
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (Exception exception) {}
    }

    private static void cleanup() {
        try {
            File[] listFiles;
            final long now = System.currentTimeMillis();
            File[] fileArray = listFiles = LibPlugin.OFYS_HOME_FILE.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.canWrite() && pathname.exists() && pathname.getName().startsWith(PrpCache.prefix) && pathname.getName().endsWith(PrpCache.suffix) && pathname.lastModified() < now - TimeUnit.DAYS.toMillis(2L);
                }
            });
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    file.delete();
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        catch (Exception exception) {}
    }
}

