/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro.login.autolog;

import ca.infodata.ofys.data.dataaccess.autolog.AutologConnexionRespond;
import ca.infodata.ofys.data.dataaccess.service.autolog.AutologAccessorClient;
import ca.infodata.ofys.ui.intro.login.autolog.ADManager;
import ca.infodata.util1.StringUtils;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ADManagement {
    public static final Logger logger = Logger.getLogger(ADManagement.class.getName());
    public static final int S_INITIATE = 0;
    public static final int S_ASK_CON = 1;
    public static final int S_CON_POS = 2;
    public static final int S_CON_NEG = 3;
    public static final int S_ASK_ADD = 4;
    public static final int S_ADD_POS = 5;
    public static final int S_ADD_NEG = 6;
    public static final int S_ASK_DEL = 7;
    public static final int S_DEL_POS = 8;
    public static final int S_DEL_NEG = 9;
    private int state = 0;
    private Date requestStart = null;
    private Date requestResponse = null;

    public boolean isEnabled() {
        return AutologAccessorClient.getInstance().isEnabled();
    }

    public String askForConnexionString(String client) {
        AutologConnexionRespond acr = this.askForConnexion(client);
        return acr == null ? null : acr.getUsername();
    }

    public AutologConnexionRespond askForConnexion(String client) {
        String sid = null;
        try {
            sid = ADManager.getUID();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "SID not found", e);
        }
        return this.askForConnexion(client, sid);
    }

    public String askForConnexionString(String client, String sid) {
        AutologConnexionRespond acr = this.askForConnexion(client, sid);
        return acr == null ? null : acr.getUsername();
    }

    public AutologConnexionRespond askForConnexion(String client, String sid) {
        AutologConnexionRespond racr = null;
        this.state = 1;
        if (!StringUtils.isBlank((CharSequence)sid)) {
            this.requestStart = new Date();
            this.requestResponse = null;
            try {
                AutologConnexionRespond acr = AutologAccessorClient.getInstance().get(sid, client);
                this.requestResponse = new Date();
                if (acr != null && !StringUtils.isBlank((CharSequence)acr.getUsername())) {
                    racr = acr;
                    this.state = 2;
                } else {
                    this.state = 3;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error on asking", e);
            }
        }
        return racr;
    }

    public String askForPassword(String client, String sid) {
        try {
            return AutologAccessorClient.getInstance().getPsw(sid, client);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error on askForPassword client=" + client + ", sid=" + sid, e);
            return null;
        }
    }

    public String askForPassword(String client) {
        String sid = null;
        try {
            sid = ADManager.getUID();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "SID not found client=" + client, e);
        }
        return this.askForPassword(client, sid);
    }

    public boolean askForValidatePassword(String username, String password, String client) {
        try {
            return AutologAccessorClient.getInstance().validatePassword(username, password, client);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error on askForPassword client=" + client + ", username=" + username, e);
            return false;
        }
    }

    public boolean askForAdding(String userName, String client) {
        return this.askForAdding(userName, client, false);
    }

    public boolean askForAdding(String userName, String client, boolean force) {
        this.state = 4;
        String sid = null;
        try {
            sid = ADManager.getUID();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "SID not found for username : " + userName, e);
        }
        return this.askForAdding(userName, client, sid, force);
    }

    public boolean askForAdding(String userName, String client, String sid) {
        return this.askForAdding(userName, client, sid, false);
    }

    public boolean askForAdding(String userName, String client, String sid, boolean force) {
        boolean haveAdd = false;
        this.state = 4;
        if (!(StringUtils.isBlank((CharSequence)sid) || StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)client))) {
            this.requestStart = new Date();
            this.requestResponse = null;
            try {
                AutologConnexionRespond autolog = new AutologConnexionRespond();
                autolog.setSid(sid);
                autolog.setUsername(userName);
                autolog.setClient(client);
                autolog.setIsForced(Integer.valueOf(force ? 1 : 0));
                AutologAccessorClient.getInstance().create(autolog);
                this.requestResponse = new Date();
                this.state = 5;
                haveAdd = true;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error in adding", e);
            }
        }
        return haveAdd;
    }

    public boolean askForDeleting(String client) {
        this.state = 7;
        String sid = null;
        try {
            sid = ADManager.getUID();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "SID not found", e);
        }
        return this.askForDeleting(client, sid);
    }

    public boolean askForDeleting(String client, String sid) {
        boolean haveDel = false;
        this.state = 7;
        if (!StringUtils.isBlank((CharSequence)sid) && !StringUtils.isBlank((CharSequence)client)) {
            this.requestStart = new Date();
            this.requestResponse = null;
            try {
                int newId = AutologAccessorClient.getInstance().delete(sid, client);
                this.requestResponse = new Date();
                if (newId > 0) {
                    this.state = 8;
                    haveDel = true;
                } else {
                    this.state = 9;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error in deleting", e);
            }
        }
        return haveDel;
    }

    public boolean hasResponse() {
        return this.requestStart != null && this.requestResponse != null || this.requestStart == null && this.requestResponse == null;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }
}

