/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro.handlers;

import ca.infodata.ofys.ui.controls.DownloadProgressDialogSWT;
import ca.infodata.ofys.ui.library.DaemonThread;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.MyAbstractHandler;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.http.download.Download;
import ca.infodata.util1.http.download.Util;
import ca.infodata.util1.http.download.ValidatedDownload;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class RemoteDesktopHandler
extends MyAbstractHandler {
    private static final Logger logger = Logger.getLogger(RemoteDesktopHandler.class.getName());
    final String md5ForAnyDeskTgz = "908a78fb1d9b1a785b721f3d845528b3";
    final String md5ForAnyDeskExe = "3cdec920f6fb60176327c26333f97474";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            try {
                this.openFromHost(event);
            }
            catch (Exception exception) {
                this.openFromWeb(event);
            }
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to run RemoteDesktopHandler", (Throwable)e);
        }
        return null;
    }

    private void openFromWeb(ExecutionEvent event) throws Exception {
        try {
            String enUrl = "https://www.ofys.ca/en/remotehelp.html";
            String frUrl = "https://www.ofys.ca/fr/remotehelp.html";
            String surl = LocaleProvider.isEnglish() ? enUrl : frUrl;
            URL url = new URL(surl);
            IWorkbenchWindow window = this.getOrOpenActiveWorkbenchWindow(event);
            IWorkbenchBrowserSupport browserSupport = window.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(128, "ca.infodata.ofys.ui.remotehelp", null, null);
            browser.openURL(url);
        }
        catch (Exception e) {
            String s = "Failed to open teamviewer client from web";
            logger.log(Level.SEVERE, s, e);
            throw new ExecutionException(s, (Throwable)e);
        }
    }

    private void openFromHost(ExecutionEvent event) throws Exception {
        if (LibPlugin.ON_MAC) {
            this.openFromMacHost(event);
        } else if (LibPlugin.ON_WIN) {
            this.openFromWindowsHost(event);
        }
    }

    private void openFromMacHost(ExecutionEvent event) throws Exception {
        String filename = "anydesk.tgz";
        String address = "https://www.ofys.ca/tv/" + filename;
        File zipFile = this.getOrDownload("908a78fb1d9b1a785b721f3d845528b3", event, filename, new URL(address));
        if (zipFile == null) {
            throw new Exception("Failed to download " + filename + " from " + address);
        }
        File appFile = null;
        try {
            RemoteDesktopHandler.unTarFile(zipFile.getAbsolutePath(), zipFile.getParentFile());
            appFile = new File(zipFile.getParent(), "AnyDesk.app");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to unzip " + zipFile.getAbsolutePath(), e);
            throw e;
        }
        Object[] cmd = new String[]{"open", appFile.getAbsolutePath()};
        try {
            Runtime.getRuntime().exec((String[])cmd);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to execute windows command " + Arrays.toString(cmd), e);
            throw e;
        }
    }

    private static void unTarFile(String tarFile, File destFile) {
        block13: {
            TarArchiveInputStream tis = null;
            try {
                try {
                    FileInputStream fis = new FileInputStream(tarFile);
                    GZIPInputStream gzipInputStream = new GZIPInputStream(new BufferedInputStream(fis));
                    tis = new TarArchiveInputStream((InputStream)gzipInputStream);
                    TarArchiveEntry tarEntry = null;
                    while ((tarEntry = tis.getNextTarEntry()) != null) {
                        if (tarEntry.isDirectory() || tarEntry.getName().contains("/._")) continue;
                        System.out.println(" tar entry: " + tarEntry.getName());
                        File outputFile = new File(destFile + File.separator + tarEntry.getName());
                        outputFile.getParentFile().mkdirs();
                        IOUtils.copy((InputStream)tis, (OutputStream)new FileOutputStream(outputFile));
                        outputFile.setExecutable(true, false);
                        outputFile.getName().equalsIgnoreCase("TeamViewerQS");
                    }
                }
                catch (IOException ex) {
                    System.out.println("Error while untarring a file- " + ex.getMessage());
                    if (tis == null) break block13;
                    try {
                        tis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (tis != null) {
                    try {
                        tis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private File getOrDownload(String referenceMD5, ExecutionEvent event, String filename, URL url) throws ExecutionException {
        File userDir = new File(Platform.getLocation().toString()).getParentFile();
        File file = new File(userDir, filename);
        if (file.exists()) {
            try {
                boolean delete;
                String computedMd5 = Util.computeMd5((File)file);
                if (!referenceMD5.equals(computedMd5) && !(delete = file.delete())) {
                    logger.severe("Failed to delete invalid file ... " + file.getName());
                    return null;
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failed to compute md5 sum of file " + file);
                return null;
            }
        }
        if (!file.exists()) {
            Shell shell = this.getOrOpenActiveWorkbenchWindow(event).getShell();
            final DownloadProgressDialogSWT dialog = new DownloadProgressDialogSWT(shell);
            dialog.setBlockOnOpen(true);
            final ValidatedDownload download = new ValidatedDownload(url, file);
            download.setMd5(referenceMD5);
            download.setMonitor(dialog.getMonitor());
            DaemonThread downloadThread = new DaemonThread(new Runnable(){

                @Override
                public void run() {
                    download.run();
                    dialog.setDone();
                }
            }, "download-" + filename);
            downloadThread.start();
            dialog.open();
            if (download.getStatus() != Download.STATUS.COMPLETE) {
                return null;
            }
        }
        return file;
    }

    private void openFromWindowsHost(ExecutionEvent event) throws Exception {
        String filename = "AnyDesk.exe";
        String address = "https://www.ofys.ca/tv/" + filename;
        File file = this.getOrDownload("3cdec920f6fb60176327c26333f97474", event, filename, new URL(address));
        if (file == null) {
            throw new Exception("Failed to download " + filename + " from " + address);
        }
        Object[] cmd = new String[]{file.getAbsolutePath()};
        try {
            Runtime.getRuntime().exec((String[])cmd);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to execute windows command " + Arrays.toString(cmd), e);
            throw e;
        }
    }
}

