/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro;

import ca.infodata.ofys.ui.intro.PerspectiveManager;
import ca.infodata.ofys.ui.library.DaemonThread;
import ca.infodata.ofys.ui.library.LibPlugin;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public final class ApplicationTimeoutTool {
    private static final Logger logger = Logger.getLogger(ApplicationTimeoutTool.class.getName());
    private volatile int idleTimeInMinute;
    private Listener actionListener;
    private static ApplicationTimeoutTool instance;

    public static ApplicationTimeoutTool getInstance() {
        return instance;
    }

    public ApplicationTimeoutTool() {
        instance = this;
        this.actionListener = new Listener(){

            public void handleEvent(Event event) {
                ApplicationTimeoutTool.this.resetTimer();
            }
        };
        DaemonThread thread = new DaemonThread(new Runnable(){

            @Override
            public void run() {
                ApplicationTimeoutTool.this.run();
            }
        });
        thread.start();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().addFilter(1, ApplicationTimeoutTool.this.actionListener);
                Display.getDefault().addFilter(5, ApplicationTimeoutTool.this.actionListener);
            }
        });
    }

    public void resetTimer() {
        this.idleTimeInMinute = 0;
    }

    private void run() {
        try {
            while (true) {
                TimeUnit.MINUTES.sleep(1L);
                ++this.idleTimeInMinute;
                boolean shouldForceQuit = (long)this.idleTimeInMinute >= TimeUnit.HOURS.toMinutes(3L);
                if (!shouldForceQuit || new File(String.valueOf(LibPlugin.OFYS_HOME) + "/../notimeout.txt").exists()) continue;
                this.forceQuit();
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Automatic application closer was interrupted", e);
            return;
        }
    }

    private void forceQuit() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!workbench.isClosing()) {
                    PerspectiveManager.closeAll(true);
                    workbench.close();
                }
            }
        });
    }
}

