/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq.controller;

import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.client.dataaccess.DSQAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.controls.MySubProgressMonitor;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.dsq.controller.ListDischargeCareSummaryControllerCallback;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ListDischargeCareSummaryController {
    private static final String OBTENTION_DE_LA_LISTE = "Obtention de la liste des sommaires d'hospitalisation";
    private static final Logger logger = Logger.getLogger(ListDischargeCareSummaryController.class.getName());
    private final ListDischargeCareSummaryControllerCallback callback;
    private IPatient patient;
    private LocalDate start = null;
    private LocalDate end = null;
    private Boolean mostRecentByTypeIndicator;
    private QueryContinuationResult result;
    private FindCandidateAction findCandidateAction;
    private BaseDSQAction dsq;
    private Job listJob;

    public ListDischargeCareSummaryController(ListDischargeCareSummaryControllerCallback callback, BaseDSQAction dsq, FindCandidateAction findCandidateAction) {
        if (dsq == null) {
            throw new NullPointerException("dsq");
        }
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (findCandidateAction == null) {
            throw new NullPointerException("findCandidateAction");
        }
        this.dsq = dsq;
        this.callback = callback;
        this.findCandidateAction = findCandidateAction;
    }

    public void list() {
        if (this.listJob == null) {
            this.listJob = new Job(OBTENTION_DE_LA_LISTE){

                protected org.eclipse.core.runtime.IStatus run(IProgressMonitor monitor) {
                    ListDischargeCareSummaryController.this.list2(monitor);
                    return Status.OK_STATUS;
                }
            };
        }
        if (this.listJob.getState() == 4) {
            this.callback.list((DsqCallback<QueryContinuationResult>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.listJob.schedule();
        }
    }

    public void list2(IProgressMonitor monitor) {
        if (this.result == null) {
            DsqCallback<QueryContinuationResult> r = this.list3(monitor);
            if (r.result != null) {
                this.result = (QueryContinuationResult)r.result;
            }
            this.callback.list(r);
        } else {
            this.callback.list((DsqCallback<QueryContinuationResult>)new DsqCallback((Object)this.result));
        }
    }

    public MultiStatus valid() {
        MultiStatus status = new MultiStatus();
        if (this.start != null && this.start.before((IPartialDate)LocalDate.from((int)1, (int)1, (int)2007))) {
            status.add((IStatus)new ca.infodata.ofys.status.Status(IStatus.Severity.ERROR, "La date de d\u00e9but ne doit pas \u00eatre avant le 1er janvier 2007"));
        }
        if (this.end != null && this.end.before((IPartialDate)LocalDate.from((int)1, (int)1, (int)2007))) {
            status.add((IStatus)new ca.infodata.ofys.status.Status(IStatus.Severity.ERROR, "La date de fin ne doit pas \u00eatre avant le 1er janvier 2007"));
        }
        if (this.start != null && this.start.after((IPartialDate)LocalDate.today())) {
            status.add((IStatus)new ca.infodata.ofys.status.Status(IStatus.Severity.ERROR, "La date de d\u00e9but ne doit pas \u00eatre dans le futur"));
        }
        if (this.end != null && this.end.after((IPartialDate)LocalDate.today())) {
            status.add((IStatus)new ca.infodata.ofys.status.Status(IStatus.Severity.ERROR, "La date de fin ne doit pas \u00eatre dans le futur"));
        }
        if (this.end != null && this.start != null && this.end.before((IPartialDate)this.start)) {
            status.add((IStatus)new ca.infodata.ofys.status.Status(IStatus.Severity.ERROR, "La date de d\u00e9but doit \u00eatre avant la date de fin"));
        }
        if (this.patient == null) {
            status.add((IStatus)new ca.infodata.ofys.status.Status(IStatus.Severity.ERROR, "Veuillez sp\u00e9cifier un client"));
        }
        return status;
    }

    public DsqCallback<QueryContinuationResult> list3(IProgressMonitor monitor) {
        DsqCallback callback = new DsqCallback();
        try {
            if (this.start != null && this.start.before((IPartialDate)LocalDate.from((int)1, (int)1, (int)2007))) {
                callback.message = "La date de d\u00e9but ne doit pas \u00eatre avant le 1er janvier 2007";
                monitor.done();
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.end != null && this.end.before((IPartialDate)LocalDate.from((int)1, (int)1, (int)2007))) {
                callback.message = "La date de fin ne doit pas \u00eatre avant le 1er janvier 2007";
                monitor.done();
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.start != null && this.start.after((IPartialDate)LocalDate.today())) {
                callback.message = "La date de \u00e9but ne doit pas \u00eatre dans le futur";
                monitor.done();
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.end != null && this.end.after((IPartialDate)LocalDate.today())) {
                callback.message = "La date de fin ne doit pas \u00eatre dans le futur";
                monitor.done();
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.end != null && this.start != null && this.end.before((IPartialDate)this.start)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                monitor.done();
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.patient == null) {
                callback.message = "Veuillez sp\u00e9cifier un client";
                monitor.done();
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            try {
                monitor.beginTask(OBTENTION_DE_LA_LISTE, 2);
                XmlSignatureI signature = null;
                XmlSignatureI signatureNiu = null;
                if (!this.dsq.hasSignatures(this.patient.getId())) {
                    if (!UI.OS_WINDOWS) {
                        throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                    }
                    this.dsq.checkIfActionWasCanceled(monitor);
                    Alias alias = this.dsq.getAlias(monitor);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    String niu = this.findCandidateAction.getNiu(this.patient, (IProgressMonitorWithLog)new MySubProgressMonitor(monitor, 1));
                    this.dsq.checkIfActionWasCanceled(monitor);
                    signature = this.dsq.getSignatureI(monitor, alias, null);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, null, niu);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    monitor.worked(1);
                    this.dsq.checkIfActionWasCanceled(monitor);
                }
                monitor.subTask("Recherche");
                XSession session = Application.get().getGlobalInstances().getSession();
                ReturnObject r = DSQAccessorClient.getInstance().listPatientDischargeCareSummary(session, this.patient.getId(), this.start, this.end, this.mostRecentByTypeIndicator, (Signature)signature, (Signature)signatureNiu);
                if (r == null) {
                    throw new AbortException("Erreur lors de l'" + OBTENTION_DE_LA_LISTE.toLowerCase());
                }
                this.dsq.manageDsqStatus(r.getStatus());
                callback.result = (QueryContinuationResult)r.getObj();
                this.dsq.checkIfActionWasCanceled(monitor);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                callback.message = MessageUtil.CANNOT_CONNECT_TO_SERVER_MESSAGE;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (AbortException | StatusException e) {
                callback.message = e.getMessage();
            }
            catch (CancelException cancelException) {
            }
            catch (Exception e) {
                callback.exception = e;
                callback.message = e.getMessage();
                logger.log(Level.SEVERE, String.format("Failed to list discharge care summary %s, %s, %s, %s", StringUtils.safeToString((Logger)logger, (Object)this.patient), this.start, this.end, this.mostRecentByTypeIndicator), e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void setPatient(IPatient patient) {
        this.clear();
        this.patient = patient;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void clear() {
        this.result = null;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public void setStart(LocalDate start) {
        this.clear();
        this.start = start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public void setEnd(LocalDate end) {
        this.clear();
        this.end = end;
    }

    public Boolean getMostRecentByTypeIndicator() {
        return this.mostRecentByTypeIndicator;
    }

    public void setMostRecentByTypeIndicator(Boolean mostRecentByTypeIndicator) {
        this.mostRecentByTypeIndicator = mostRecentByTypeIndicator;
        this.clear();
    }
}

