/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.cache;

import ca.infodata.ofys.client.cache.IResourceCache;
import ca.infodata.ofys.client.util.SupplierE;
import ca.infodata.util1.StringUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceCacheImpl
implements IResourceCache {
    private static final Logger logger = Logger.getLogger(ResourceCacheImpl.class.getName());
    private Cache<String, byte[]> cache = Caffeine.newBuilder().maximumSize(100L).build();

    public byte[] get(String resourceName, SupplierE<byte[]> ifAbsent) {
        byte[] value = this.get(resourceName);
        if (value == null) {
            try {
                value = (byte[])ifAbsent.get();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error getting value from ifAbsent supplier" + StringUtils.safeToString((Logger)logger, ifAbsent) + " and key " + StringUtils.safeToString((Logger)logger, (Object)resourceName), e);
            }
            if (value != null) {
                this.put(resourceName, value);
            }
        }
        return value;
    }

    private void put(String resourceName, byte[] value) {
        this.cache.put((Object)resourceName, (Object)value);
    }

    private byte[] get(String resourceName) {
        return (byte[])this.cache.getIfPresent((Object)resourceName);
    }

    public void dispose() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }
}

