/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard;

import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.HtmlResource;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.browser.BrowserComposite;
import ca.infodata.ofys.ui.controls.webbrowser.AdvancedBrowser;
import ca.infodata.ofys.ui.dashboard.DashboardData;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;

public class DashboardEditor
extends BaseEditor {
    private BrowserComposite browser;
    boolean isMacBigSurPlus = false;
    protected AdvancedBrowser advancedBrowser = null;

    public DashboardEditor() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        if (osName.startsWith("Mac") && osVersion.compareTo("10.15") >= 1) {
            this.isMacBigSurPlus = true;
        }
    }

    public void dispose() {
        if (this.advancedBrowser != null && !this.advancedBrowser.isDisposed()) {
            this.advancedBrowser.dispose();
        }
        super.dispose();
    }

    public boolean isDirty() {
        return false;
    }

    public String getEditorTitle() {
        return Messages.getString((String)"DASHBOARD", (String[])new String[0]);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        EditorInput editorInput2;
        if (input instanceof EditorInput && (editorInput2 = (EditorInput)input).getDataObject() == null) {
            input = new EditorInput((IDataObject)new DashboardData());
        }
        super.init(site, input);
    }

    public void createPartControl(Composite parent) {
        this.browser = new BrowserComposite(parent, 0);
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                System.out.println("browser disposed");
            }
        });
        new EmbededBrowser(this.browser, "EmbededBrowser");
        new OpenExternalBrowser(this.browser, "openExternalBroswer");
        this.browser.setUrl(HtmlBrowserTools.getUrl((String)"/dashboard/resources/dashboard.html", null));
        parent.setLayout((Layout)new FillLayout());
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void showDataObject() {
    }

    public Image getEditorTitleImage() {
        return null;
    }

    public void initDataOverride() {
    }

    public void createMyControl(Composite parent) {
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return null;
    }

    public boolean isDataDirty() {
        return false;
    }

    public void setToolBarStatus() {
    }

    public class EmbededBrowser
    extends BrowserFunction {
        public EmbededBrowser(BrowserComposite browser, String name) {
            super(browser.getInnerBrowser(), name);
        }

        public Object function(Object[] arguments) {
            return true;
        }
    }

    public class OpenExternalBrowser
    extends BrowserFunction {
        public OpenExternalBrowser(BrowserComposite browser, String name) {
            super(browser.getInnerBrowser(), name);
        }

        public Object function(Object[] arguments) {
            if (arguments != null && arguments.length == 1) {
                String s = (String)arguments[0];
                if (s.startsWith("http")) {
                    try {
                        Desktop.getDesktop().browse(new URI(s));
                    }
                    catch (IOException | URISyntaxException exception) {
                        Program.launch((String)s);
                    }
                } else {
                    String htmlPage = "html" + System.currentTimeMillis();
                    HtmlResource htmlResource = HtmlBrowserTools.getOrCreateHtmlResource((String)htmlPage, null, (Object)s, (boolean)false);
                    String url = htmlResource.getUrl();
                    try {
                        Desktop.getDesktop().browse(new URI(url));
                    }
                    catch (IOException | URISyntaxException exception) {
                        Program.launch((String)url);
                    }
                }
            }
            return true;
        }

        private boolean openModuleConnectAndCloseIt(String s) {
            if (s.startsWith("http") && s.contains("module/connect/index")) {
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ((OpenExternalBrowser)(this).OpenExternalBrowser.this).DashboardEditor.this.advancedBrowser.hide();
                            }
                        });
                    }
                };
                Timer timer = new Timer();
                timer.schedule(task, 500L);
                return false;
            }
            return true;
        }
    }
}

