/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.AbstractAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;

public final class AppendingPackedLongBuffer
extends AbstractAppendingLongBuffer {
    public AppendingPackedLongBuffer(int initialPageCount, int pageSize, float acceptableOverheadRatio) {
        super(initialPageCount, pageSize, acceptableOverheadRatio);
    }

    public AppendingPackedLongBuffer() {
        this(16, 1024, 0.2f);
    }

    public AppendingPackedLongBuffer(float acceptableOverheadRatio) {
        this(16, 1024, acceptableOverheadRatio);
    }

    @Override
    long get(int block, int element) {
        if (block == this.valuesOff) {
            return this.pending[element];
        }
        return this.values[block].get(element);
    }

    @Override
    int get(int block, int element, long[] arr, int off, int len) {
        if (block == this.valuesOff) {
            int sysCopyToRead = Math.min(len, this.pendingOff - element);
            System.arraycopy(this.pending, element, arr, off, sysCopyToRead);
            return sysCopyToRead;
        }
        return this.values[block].get(element, arr, off, len);
    }

    @Override
    void packPendingValues() {
        long minValue = this.pending[0];
        long maxValue = this.pending[0];
        int i = 1;
        while (i < this.pendingOff) {
            minValue = Math.min(minValue, this.pending[i]);
            maxValue = Math.max(maxValue, this.pending[i]);
            ++i;
        }
        int bitsRequired = minValue < 0L ? 64 : PackedInts.bitsRequired(maxValue);
        PackedInts.Mutable mutable = PackedInts.getMutable(this.pendingOff, bitsRequired, this.acceptableOverheadRatio);
        int i2 = 0;
        while (i2 < this.pendingOff) {
            i2 += mutable.set(i2, this.pending, i2, this.pendingOff - i2);
        }
        this.values[this.valuesOff] = mutable;
    }
}

