/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingStoredFieldsReader
extends StoredFieldsReader {
    private static final int BUFFER_REUSE_THRESHOLD = 32768;
    private static final byte[] SKIP_BUFFER = new byte[1024];
    private final int version;
    private final FieldInfos fieldInfos;
    private final CompressingStoredFieldsIndexReader indexReader;
    private final IndexInput fieldsStream;
    private final int chunkSize;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final Decompressor decompressor;
    private final BytesRef bytes;
    private final int numDocs;
    private boolean closed;

    private static void skipBytes(DataInput in, long numBytes) throws IOException {
        assert (numBytes >= 0L);
        long skipped = 0L;
        while (skipped < numBytes) {
            int toRead = (int)Math.min(numBytes - skipped, (long)SKIP_BUFFER.length);
            in.readBytes(SKIP_BUFFER, 0, toRead);
            skipped += (long)toRead;
        }
    }

    private CompressingStoredFieldsReader(CompressingStoredFieldsReader reader) {
        this.version = reader.version;
        this.fieldInfos = reader.fieldInfos;
        this.fieldsStream = reader.fieldsStream.clone();
        this.indexReader = reader.indexReader.clone();
        this.chunkSize = reader.chunkSize;
        this.packedIntsVersion = reader.packedIntsVersion;
        this.compressionMode = reader.compressionMode;
        this.decompressor = reader.decompressor.clone();
        this.numDocs = reader.numDocs;
        this.bytes = new BytesRef(reader.bytes.bytes.length);
        this.closed = false;
    }

    public CompressingStoredFieldsReader(Directory d, SegmentInfo si, String segmentSuffix, FieldInfos fn, IOContext context, String formatName, CompressionMode compressionMode) throws IOException {
        this.compressionMode = compressionMode;
        String segment = si.name;
        boolean success = false;
        this.fieldInfos = fn;
        this.numDocs = si.getDocCount();
        IndexInput indexStream = null;
        try {
            String indexStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, "fdx");
            indexStream = d.openInput(indexStreamFN, context);
            String codecNameIdx = String.valueOf(formatName) + "Index";
            this.version = CodecUtil.checkHeader(indexStream, codecNameIdx, 0, 1);
            assert ((long)CodecUtil.headerLength(codecNameIdx) == indexStream.getFilePointer());
            this.indexReader = new CompressingStoredFieldsIndexReader(indexStream, si);
            indexStream.close();
            indexStream = null;
            String fieldsStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, "fdt");
            this.fieldsStream = d.openInput(fieldsStreamFN, context);
            String codecNameDat = String.valueOf(formatName) + "Data";
            int fieldsVersion = CodecUtil.checkHeader(this.fieldsStream, codecNameDat, 0, 1);
            if (this.version != fieldsVersion) {
                throw new CorruptIndexException("Version mismatch between stored fields index and data: " + this.version + " != " + fieldsVersion);
            }
            assert ((long)CodecUtil.headerLength(codecNameDat) == this.fieldsStream.getFilePointer());
            this.chunkSize = this.version >= 1 ? this.fieldsStream.readVInt() : -1;
            this.packedIntsVersion = this.fieldsStream.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.bytes = new BytesRef();
            success = true;
        }
        catch (Throwable throwable) {
            if (!success) {
                IOUtils.closeWhileHandlingException(this, indexStream);
            }
            throw throwable;
        }
        if (!success) {
            IOUtils.closeWhileHandlingException(this, indexStream);
        }
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.fieldsStream);
            this.closed = true;
        }
    }

    private static void readField(DataInput in, StoredFieldVisitor visitor, FieldInfo info, int bits) throws IOException {
        switch (bits & CompressingStoredFieldsWriter.TYPE_MASK) {
            case 1: {
                int length = in.readVInt();
                byte[] data = new byte[length];
                in.readBytes(data, 0, length);
                visitor.binaryField(info, data);
                break;
            }
            case 0: {
                int length = in.readVInt();
                byte[] data = new byte[length];
                in.readBytes(data, 0, length);
                visitor.stringField(info, new String(data, IOUtils.CHARSET_UTF_8));
                break;
            }
            case 2: {
                visitor.intField(info, in.readInt());
                break;
            }
            case 3: {
                visitor.floatField(info, Float.intBitsToFloat(in.readInt()));
                break;
            }
            case 4: {
                visitor.longField(info, in.readLong());
                break;
            }
            case 5: {
                visitor.doubleField(info, Double.longBitsToDouble(in.readLong()));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    private static void skipField(DataInput in, int bits) throws IOException {
        switch (bits & CompressingStoredFieldsWriter.TYPE_MASK) {
            case 0: 
            case 1: {
                int length = in.readVInt();
                CompressingStoredFieldsReader.skipBytes(in, length);
                break;
            }
            case 2: 
            case 3: {
                in.readInt();
                break;
            }
            case 4: 
            case 5: {
                in.readLong();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    @Override
    public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
        DataInput documentInput;
        int totalLength;
        int length;
        int offset;
        int numStoredFields;
        this.fieldsStream.seek(this.indexReader.getStartPointer(docID));
        int docBase = this.fieldsStream.readVInt();
        int chunkDocs = this.fieldsStream.readVInt();
        if (docID < docBase || docID >= docBase + chunkDocs || docBase + chunkDocs > this.numDocs) {
            throw new CorruptIndexException("Corrupted: docID=" + docID + ", docBase=" + docBase + ", chunkDocs=" + chunkDocs + ", numDocs=" + this.numDocs + " (resource=" + this.fieldsStream + ")");
        }
        if (chunkDocs == 1) {
            numStoredFields = this.fieldsStream.readVInt();
            offset = 0;
            totalLength = length = this.fieldsStream.readVInt();
        } else {
            int bitsPerStoredFields = this.fieldsStream.readVInt();
            if (bitsPerStoredFields == 0) {
                numStoredFields = this.fieldsStream.readVInt();
            } else {
                if (bitsPerStoredFields > 31) {
                    throw new CorruptIndexException("bitsPerStoredFields=" + bitsPerStoredFields + " (resource=" + this.fieldsStream + ")");
                }
                long filePointer = this.fieldsStream.getFilePointer();
                PackedInts.Reader reader = PackedInts.getDirectReaderNoHeader(this.fieldsStream, PackedInts.Format.PACKED, this.packedIntsVersion, chunkDocs, bitsPerStoredFields);
                numStoredFields = (int)reader.get(docID - docBase);
                this.fieldsStream.seek(filePointer + PackedInts.Format.PACKED.byteCount(this.packedIntsVersion, chunkDocs, bitsPerStoredFields));
            }
            int bitsPerLength = this.fieldsStream.readVInt();
            if (bitsPerLength == 0) {
                length = this.fieldsStream.readVInt();
                offset = (docID - docBase) * length;
                totalLength = chunkDocs * length;
            } else {
                if (bitsPerStoredFields > 31) {
                    throw new CorruptIndexException("bitsPerLength=" + bitsPerLength + " (resource=" + this.fieldsStream + ")");
                }
                PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(this.fieldsStream, PackedInts.Format.PACKED, this.packedIntsVersion, chunkDocs, bitsPerLength, 1);
                int off = 0;
                int i = 0;
                while (i < docID - docBase) {
                    off = (int)((long)off + it.next());
                    ++i;
                }
                offset = off;
                length = (int)it.next();
                off += length;
                i = docID - docBase + 1;
                while (i < chunkDocs) {
                    off = (int)((long)off + it.next());
                    ++i;
                }
                totalLength = off;
            }
        }
        if (length == 0 != (numStoredFields == 0)) {
            throw new CorruptIndexException("length=" + length + ", numStoredFields=" + numStoredFields + " (resource=" + this.fieldsStream + ")");
        }
        if (numStoredFields == 0) {
            return;
        }
        if (this.version >= 1 && totalLength >= 2 * this.chunkSize) {
            assert (this.chunkSize > 0);
            assert (offset < this.chunkSize);
            this.decompressor.decompress(this.fieldsStream, this.chunkSize, offset, Math.min(length, this.chunkSize - offset), this.bytes);
            documentInput = new DataInput(){
                int decompressed;
                {
                    this.decompressed = ((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.length;
                }

                void fillBuffer() throws IOException {
                    if (!$assertionsDisabled && this.decompressed > length) {
                        throw new AssertionError();
                    }
                    if (this.decompressed == length) {
                        throw new EOFException();
                    }
                    int toDecompress = Math.min(length - this.decompressed, CompressingStoredFieldsReader.this.chunkSize);
                    CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, CompressingStoredFieldsReader.this.bytes);
                    this.decompressed += toDecompress;
                }

                @Override
                public byte readByte() throws IOException {
                    if (((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.length == 0) {
                        this.fillBuffer();
                    }
                    --((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.length;
                    return ((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.bytes[((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.offset++];
                }

                @Override
                public void readBytes(byte[] b, int offset, int len) throws IOException {
                    while (len > ((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.length) {
                        System.arraycopy(((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.bytes, ((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.offset, b, offset, ((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.length);
                        len -= ((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.length;
                        offset += ((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.length;
                        this.fillBuffer();
                    }
                    System.arraycopy(((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.bytes, ((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.offset, b, offset, len);
                    ((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.offset += len;
                    ((CompressingStoredFieldsReader)CompressingStoredFieldsReader.this).bytes.length -= len;
                }
            };
        } else {
            BytesRef bytes = totalLength <= 32768 ? this.bytes : new BytesRef();
            this.decompressor.decompress(this.fieldsStream, totalLength, offset, length, bytes);
            assert (bytes.length == length);
            documentInput = new ByteArrayDataInput(bytes.bytes, bytes.offset, bytes.length);
        }
        int fieldIDX = 0;
        while (fieldIDX < numStoredFields) {
            long infoAndBits = documentInput.readVLong();
            int fieldNumber = (int)(infoAndBits >>> CompressingStoredFieldsWriter.TYPE_BITS);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
            int bits = (int)(infoAndBits & (long)CompressingStoredFieldsWriter.TYPE_MASK);
            assert (bits <= 5) : "bits=" + Integer.toHexString(bits);
            switch (visitor.needsField(fieldInfo)) {
                case YES: {
                    CompressingStoredFieldsReader.readField(documentInput, visitor, fieldInfo, bits);
                    break;
                }
                case NO: {
                    CompressingStoredFieldsReader.skipField(documentInput, bits);
                    break;
                }
                case STOP: {
                    return;
                }
            }
            ++fieldIDX;
        }
    }

    @Override
    public StoredFieldsReader clone() {
        this.ensureOpen();
        return new CompressingStoredFieldsReader(this);
    }

    int getVersion() {
        return this.version;
    }

    CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    ChunkIterator chunkIterator(int startDocID) throws IOException {
        this.ensureOpen();
        this.fieldsStream.seek(this.indexReader.getStartPointer(startDocID));
        return new ChunkIterator();
    }

    @Override
    public long ramBytesUsed() {
        return this.indexReader.ramBytesUsed();
    }

    final class ChunkIterator {
        BytesRef spare;
        BytesRef bytes = new BytesRef();
        int docBase = -1;
        int chunkDocs;
        int[] numStoredFields;
        int[] lengths;

        private ChunkIterator() {
            this.spare = new BytesRef();
            this.numStoredFields = new int[1];
            this.lengths = new int[1];
        }

        int chunkSize() {
            int sum = 0;
            int i = 0;
            while (i < this.chunkDocs) {
                sum += this.lengths[i];
                ++i;
            }
            return sum;
        }

        void next(int doc) throws IOException {
            assert (doc >= this.docBase + this.chunkDocs) : String.valueOf(doc) + " " + this.docBase + " " + this.chunkDocs;
            CompressingStoredFieldsReader.this.fieldsStream.seek(CompressingStoredFieldsReader.this.indexReader.getStartPointer(doc));
            int docBase = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            int chunkDocs = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            if (docBase < this.docBase + this.chunkDocs || docBase + chunkDocs > CompressingStoredFieldsReader.this.numDocs) {
                throw new CorruptIndexException("Corrupted: current docBase=" + this.docBase + ", current numDocs=" + this.chunkDocs + ", new docBase=" + docBase + ", new numDocs=" + chunkDocs + " (resource=" + CompressingStoredFieldsReader.this.fieldsStream + ")");
            }
            this.docBase = docBase;
            this.chunkDocs = chunkDocs;
            if (chunkDocs > this.numStoredFields.length) {
                int newLength = ArrayUtil.oversize(chunkDocs, 4);
                this.numStoredFields = new int[newLength];
                this.lengths = new int[newLength];
            }
            if (chunkDocs == 1) {
                this.numStoredFields[0] = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                this.lengths[0] = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            } else {
                int bitsPerStoredFields = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (bitsPerStoredFields == 0) {
                    Arrays.fill(this.numStoredFields, 0, chunkDocs, CompressingStoredFieldsReader.this.fieldsStream.readVInt());
                } else {
                    if (bitsPerStoredFields > 31) {
                        throw new CorruptIndexException("bitsPerStoredFields=" + bitsPerStoredFields + " (resource=" + CompressingStoredFieldsReader.this.fieldsStream + ")");
                    }
                    PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, CompressingStoredFieldsReader.this.packedIntsVersion, chunkDocs, bitsPerStoredFields, 1);
                    int i = 0;
                    while (i < chunkDocs) {
                        this.numStoredFields[i] = (int)it.next();
                        ++i;
                    }
                }
                int bitsPerLength = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (bitsPerLength == 0) {
                    Arrays.fill(this.lengths, 0, chunkDocs, CompressingStoredFieldsReader.this.fieldsStream.readVInt());
                } else {
                    if (bitsPerLength > 31) {
                        throw new CorruptIndexException("bitsPerLength=" + bitsPerLength);
                    }
                    PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, CompressingStoredFieldsReader.this.packedIntsVersion, chunkDocs, bitsPerLength, 1);
                    int i = 0;
                    while (i < chunkDocs) {
                        this.lengths[i] = (int)it.next();
                        ++i;
                    }
                }
            }
        }

        void decompress() throws IOException {
            int chunkSize = this.chunkSize();
            if (CompressingStoredFieldsReader.this.version >= 1 && chunkSize >= 2 * CompressingStoredFieldsReader.this.chunkSize) {
                this.bytes.length = 0;
                this.bytes.offset = 0;
                int decompressed = 0;
                while (decompressed < chunkSize) {
                    int toDecompress = Math.min(chunkSize - decompressed, CompressingStoredFieldsReader.this.chunkSize);
                    CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, this.spare);
                    this.bytes.bytes = ArrayUtil.grow(this.bytes.bytes, this.bytes.length + this.spare.length);
                    System.arraycopy(this.spare.bytes, this.spare.offset, this.bytes.bytes, this.bytes.length, this.spare.length);
                    this.bytes.length += this.spare.length;
                    decompressed += toDecompress;
                }
            } else {
                CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, chunkSize, 0, chunkSize, this.bytes);
            }
            if (this.bytes.length != chunkSize) {
                throw new CorruptIndexException("Corrupted: expected chunk size = " + this.chunkSize() + ", got " + this.bytes.length + " (resource=" + CompressingStoredFieldsReader.this.fieldsStream + ")");
            }
        }

        void copyCompressedData(DataOutput out) throws IOException {
            long chunkEnd = this.docBase + this.chunkDocs == CompressingStoredFieldsReader.this.numDocs ? CompressingStoredFieldsReader.this.fieldsStream.length() : CompressingStoredFieldsReader.this.indexReader.getStartPointer(this.docBase + this.chunkDocs);
            out.copyBytes(CompressingStoredFieldsReader.this.fieldsStream, chunkEnd - CompressingStoredFieldsReader.this.fieldsStream.getFilePointer());
        }
    }
}

