/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.swt.layout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;

public final class MyFormAttachment {
    public int numerator;
    public int denominator = 100;
    public int offset;
    public Control control;
    public int alignment;

    public MyFormAttachment() {
    }

    public MyFormAttachment(int numerator) {
        this(numerator, 100, 0);
    }

    public MyFormAttachment(int numerator, int offset) {
        this(numerator, 100, offset);
    }

    public MyFormAttachment(int numerator, int denominator, int offset) {
        if (denominator == 0) {
            SWT.error((int)7);
        }
        this.numerator = numerator;
        this.denominator = denominator;
        this.offset = offset;
    }

    public MyFormAttachment(Control control) {
        this(control, 0, -1);
    }

    public MyFormAttachment(Control control, int offset) {
        this(control, offset, -1);
    }

    public MyFormAttachment(Control control, int offset, int alignment) {
        this.control = control;
        this.offset = offset;
        this.alignment = alignment;
    }

    MyFormAttachment divide(int value) {
        return new MyFormAttachment(this.numerator, this.denominator * value, this.offset / value);
    }

    int gcd(int m, int n) {
        int temp;
        if ((m = Math.abs(m)) < (n = Math.abs(n))) {
            temp = m;
            m = n;
            n = temp;
        }
        while (n != 0) {
            temp = m;
            m = n;
            n = temp % n;
        }
        return m;
    }

    MyFormAttachment minus(MyFormAttachment attachment) {
        MyFormAttachment solution = new MyFormAttachment();
        solution.numerator = this.numerator * attachment.denominator - this.denominator * attachment.numerator;
        solution.denominator = this.denominator * attachment.denominator;
        int gcd = this.gcd(solution.denominator, solution.numerator);
        solution.numerator /= gcd;
        solution.denominator /= gcd;
        solution.offset = this.offset - attachment.offset;
        return solution;
    }

    MyFormAttachment minus(int value) {
        return new MyFormAttachment(this.numerator, this.denominator, this.offset - value);
    }

    MyFormAttachment plus(MyFormAttachment attachment) {
        MyFormAttachment solution = new MyFormAttachment();
        solution.numerator = this.numerator * attachment.denominator + this.denominator * attachment.numerator;
        solution.denominator = this.denominator * attachment.denominator;
        int gcd = this.gcd(solution.denominator, solution.numerator);
        solution.numerator /= gcd;
        solution.denominator /= gcd;
        solution.offset = this.offset + attachment.offset;
        return solution;
    }

    MyFormAttachment plus(int value) {
        return new MyFormAttachment(this.numerator, this.denominator, this.offset + value);
    }

    int solveX(int value) {
        if (this.denominator == 0) {
            SWT.error((int)7);
        }
        return this.numerator * value / this.denominator + this.offset;
    }

    int solveY(int value) {
        if (this.numerator == 0) {
            SWT.error((int)7);
        }
        return (value - this.offset) * this.denominator / this.numerator;
    }

    public String toString() {
        String string = this.control != null ? this.control.toString() : String.valueOf(this.numerator) + "/" + this.denominator;
        return "{y = (" + string + (this.offset >= 0 ? ")x + " + this.offset : ")x - " + -this.offset) + "}";
    }
}

