/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.windows;

import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AskTextQuestionDialog {
    private static final Logger logger = Logger.getLogger(AskTextQuestionDialog.class.getName());
    private Shell dialog;
    private FormToolkit toolkit;
    private String title;
    private String[] description;
    private String answer;
    private int buttonClicked = -1;
    private MyText textBox;

    public AskTextQuestionDialog(Shell parent, String defaultAnswer, String title, String ... description) {
        this.title = title;
        this.description = description;
        this.answer = defaultAnswer;
        this.createDialog(parent);
    }

    private void createDialog(Shell parent) {
        this.dialog = new Shell(parent, 67680);
        this.dialog.setText(this.title == null ? "" : this.title);
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        ResourceGetter.linkResourceWithWidgetLife((Object)white, (Widget)this.dialog);
        this.dialog.setBackground(white);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.spacing = 5;
        this.dialog.setLayout((Layout)layout);
        this.toolkit = UI.createToolKit((Widget)this.dialog);
        this.createChilds(this.dialog);
    }

    public int getButtonClicked() {
        return this.buttonClicked;
    }

    public String getAnswer() {
        return this.answer;
    }

    private void createChilds(Shell parent) {
        FormData data;
        MyLabel[] lblDesc = new MyLabel[this.description.length];
        int i = 0;
        while (i < this.description.length) {
            lblDesc[i] = new MyLabel((Composite)parent, this.description[i], 0, this.toolkit);
            ++i;
        }
        this.textBox = new MyText((Composite)parent, this.toolkit);
        if (this.answer != null) {
            this.textBox.setText(this.answer);
        }
        MyButton btnOki = new MyButton((Composite)parent, "OK", 8, this.toolkit);
        MyButton btnCancel = new MyButton((Composite)parent, "Annuler", 8, this.toolkit);
        this.textBox.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    AskTextQuestionDialog.this.oki();
                } else if (UI.ESC((KeyEvent)e)) {
                    AskTextQuestionDialog.this.cancel();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AskTextQuestionDialog.this.cancel();
            }
        });
        btnOki.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AskTextQuestionDialog.this.oki();
            }
        });
        Control last = null;
        MyLabel[] myLabelArray = lblDesc;
        int n = lblDesc.length;
        int n2 = 0;
        while (n2 < n) {
            MyLabel lbl = myLabelArray[n2];
            if (last == null) {
                data = new FormData();
                data.top = new FormAttachment(0);
                data.left = new FormAttachment(0);
                lbl.setLayoutData(data);
            } else {
                data = new FormData();
                data.top = new FormAttachment(last, 5);
                data.left = new FormAttachment(0);
                lbl.setLayoutData(data);
            }
            last = lbl.getControl();
            ++n2;
        }
        if (last == null) {
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.textBox.setLayoutData(data);
        } else {
            data = new FormData();
            data.top = new FormAttachment(last, 5);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.textBox.setLayoutData(data);
        }
        data = new FormData();
        data.top = new FormAttachment(this.textBox.getControl(), 10);
        data.right = new FormAttachment(49);
        data.left = new FormAttachment(0);
        btnOki.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.textBox.getControl(), 10);
        data.left = new FormAttachment(btnOki.getControl(), 2);
        data.right = new FormAttachment(100);
        btnCancel.setLayoutData(data);
    }

    protected void cancel() {
        this.buttonClicked = 1;
        this.dialog.close();
    }

    protected void oki() {
        this.buttonClicked = 0;
        this.answer = this.textBox.getText();
        this.dialog.close();
    }

    public void open() {
        this.dialog.pack();
        UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
        this.dialog.open();
        UI.waitForWindowToClose((Shell)this.dialog);
    }
}

