/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.textAssistant;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IVariablesReplacer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IdentityVariablesReplacer;
import ca.infodata.ofys.ui.controls.IProposalListener;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class BaseCompletionProposal
implements ICompletionProposal {
    private SourceViewer viewer;
    protected List<IProposalListener> lstProposalListener = new ArrayList<IProposalListener>();
    public static final String[] VARIABLE_TEXT = new String[]{Messages.getString((String)"NOM", (String[])new String[0]), Messages.getString((String)"DATEDENAISSANCE", (String[])new String[0]), Messages.getString((String)"SEXE", (String[])new String[0]), Messages.getString((String)"DATEDUJOUR", (String[])new String[0]), Messages.getString((String)"NODOSSIER", (String[])new String[0]), Messages.getString((String)"TITRE", (String[])new String[0]), Messages.getString((String)"DATEDERENCONTRE", (String[])new String[0]), Messages.getString((String)"RAISONDECONSULTATION", (String[])new String[0])};
    public static final int VARIABLE_NAME = 0;
    public static final int VARIABLE_BIRTH_DATE = 1;
    public static final int VARIABLE_GENDER = 2;
    public static final int VARIABLE_CURRENT_DATE = 3;
    public static final int VARIABLE_PATIENT_NO_DOSSIER = 4;
    public static final int VARIABLE_TITLE = 5;
    public static final int VARIABLE_ENCOUNTER_DATE = 6;
    public static final int VARIABLE_ENCOUNTER_REASON = 7;
    private final IVariablesReplacer<?> variablesReplacer;

    public BaseCompletionProposal() {
        this((IVariablesReplacer<?>)new IdentityVariablesReplacer());
    }

    public BaseCompletionProposal(IVariablesReplacer<?> variablesReplacer) {
        this.variablesReplacer = variablesReplacer == null ? new IdentityVariablesReplacer() : variablesReplacer;
    }

    public void apply(IDocument document) {
        int caretPosition = this.viewer.getTextWidget().getCaretOffset();
        StringBuilder viewerText = new StringBuilder(this.viewer.getTextWidget().getText());
        int firstSpace = StringUtils.reverseIndexOf((CharSequence)viewerText, (int)Math.min(caretPosition - 1, viewerText.length() - 1), (char[])new char[]{'\n', ' '});
        int wordBeginPosition = firstSpace == -1 || viewerText.length() == 0 ? 0 : firstSpace + 1;
        String text = this.variablesReplacer.replaceVariables(this.getWriteString());
        this.viewer.getTextWidget().replaceTextRange(wordBeginPosition, caretPosition - wordBeginPosition, text);
        this.viewer.getTextWidget().setCaretOffset(wordBeginPosition + text.length());
    }

    public abstract String getAdditionalProposalInfo();

    public abstract String getDisplayString();

    public abstract String getWriteString();

    public void addProposalListener(IProposalListener listener) {
        if (this.lstProposalListener == null) {
            this.lstProposalListener = new ArrayList<IProposalListener>();
        }
        if (listener != null) {
            this.lstProposalListener.add(listener);
        }
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public void setViewer(SourceViewer viewer) {
        this.viewer = viewer;
    }
}

