/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.report2;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReportCategory;
import ca.infodata.ofys.ui.controls.report2.PrintController;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PrintTreeContentProvider
implements ITreeContentProvider {
    private Comparator<IReportCategory> categorySorter = new CategorySorter();
    private Comparator<IReport> reportSorter = new ReportSorter();
    private Object[] elements;
    private List<CategoryItem> elements2;

    public List<CategoryItem> getElements2(Object inputElement) {
        this.getElements(inputElement);
        return this.elements2;
    }

    public ReportItem findReportItemByReportId(String reportId) {
        if (this.elements2 != null) {
            for (CategoryItem c : this.elements2) {
                for (ReportItem r : c.children) {
                    if (!r.id.equals(reportId)) continue;
                    return r;
                }
            }
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.elements != null) {
            return this.elements;
        }
        PrintController controller = (PrintController)inputElement;
        if (controller != null) {
            List<IReportCategory> categories = controller.getCategories();
            Collections.sort(categories, this.categorySorter);
            ArrayList<CategoryItem> items = new ArrayList<CategoryItem>();
            for (IReportCategory category : categories) {
                CategoryItem citem = new CategoryItem(controller.computeKey(category), category);
                List<IReport> reports = controller.getReports(category);
                Collections.sort(reports, this.reportSorter);
                for (IReport report : reports) {
                    ReportItem ritem = new ReportItem(controller.computeKey(report), report, citem);
                    citem.children.add(ritem);
                }
                items.add(citem);
            }
            this.elements2 = items;
            this.elements = items.toArray();
            return this.elements;
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.elements = null;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof CategoryItem) {
            return ((CategoryItem)element).children.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof ReportItem) {
            return ((ReportItem)element).categoryItem;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof CategoryItem;
    }

    static class CategoryItem {
        String id;
        IReportCategory category;
        List<ReportItem> children = new ArrayList<ReportItem>();

        public CategoryItem(String id, IReportCategory category) {
            this.id = id;
            this.category = category;
        }

        public String toString() {
            return String.format("CategoryItem [children=%s]", this.children);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CategoryItem other = (CategoryItem)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }

    private static final class CategorySorter
    implements Comparator<IReportCategory> {
        private CategorySorter() {
        }

        @Override
        public int compare(IReportCategory o1, IReportCategory o2) {
            return StringUtils.compareAscii((String)o1.getName(), (String)o2.getName());
        }
    }

    static class ReportItem {
        String id;
        IReport report;
        CategoryItem categoryItem;

        public ReportItem(String id, IReport report, CategoryItem categoryItem) {
            this.id = id;
            this.report = report;
            this.categoryItem = categoryItem;
        }

        public String toString() {
            return String.valueOf(this.report.getName());
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReportItem other = (ReportItem)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }

    private static final class ReportSorter
    implements Comparator<IReport> {
        private ReportSorter() {
        }

        @Override
        public int compare(IReport o1, IReport o2) {
            return StringUtils.compareAscii((String)o1.getName(), (String)o2.getName());
        }
    }
}

