/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.handlers;

import ca.infodata.ofys.ui.controls.IRefreshablePart;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.controls.handlers.AbstractEditionHandler;
import ca.infodata.ofys.ui.controls.handlers.InternalHandlerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class RefreshHandler
extends AbstractEditionHandler {
    private static final Logger logger = Logger.getLogger(RefreshHandler.class.getName());

    public RefreshHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) {
        final IRefreshablePart refreshablePart = this.getRefreshablePart(event);
        if (refreshablePart == null) {
            return null;
        }
        try {
            IEditorPart editorPart = (IEditorPart)refreshablePart;
            MyProgressMonitorDialog progressMonitorDialog2 = new MyProgressMonitorDialog(editorPart.getSite().getShell());
            progressMonitorDialog2.setOpenOnRun(true);
            progressMonitorDialog2.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Chargement en cours...", -1);
                    refreshablePart.doRefresh(monitor);
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error on doRefresh " + refreshablePart.getClass().getName(), e);
        }
        return null;
    }

    @Override
    protected EvaluationResult evaluate(IEvaluationContext context) {
        IWorkbenchWindow window = InternalHandlerUtil.getActiveWorkbenchWindow(context);
        if (window == null) {
            return EvaluationResult.FALSE;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return EvaluationResult.FALSE;
        }
        IRefreshablePart refreshablePart = this.getRefreshablePart(context);
        if (refreshablePart == null) {
            return EvaluationResult.FALSE;
        }
        if (refreshablePart.isRefreshAllowed()) {
            return EvaluationResult.TRUE;
        }
        return EvaluationResult.FALSE;
    }
}

