/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.grid;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.calendar.grid.MonthCell;
import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.CellRenderer;
import ca.infodata.ofys.ui.controls.grid.CellRendererFactory;
import ca.infodata.ofys.ui.controls.grid.GridData;
import ca.infodata.ofys.ui.controls.grid.GridDataListener;
import ca.infodata.ofys.ui.controls.grid.NormalCellRenderer;
import ca.infodata.ofys.ui.controls.grid.Selection;
import ca.infodata.ofys.ui.controls.grid.SelectionListener;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.Closure;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Grid<T extends Cell, U extends GridData<T>> {
    private static final Logger logger = Logger.getLogger(Grid.class.getName());
    private static final NormalCellRenderer<Cell> normal;
    private CellRendererFactory cellRendererFactory;
    private Color colorBorder;
    private Color colorBackground;
    private Color colorSelection;
    private Color red;
    private Color black;
    private GC gcBuffer;
    private final SelectionListener selectionListener;
    private int dragging;
    private final GridDataListener dataListener;
    private U data;
    private final Canvas myCanvas;
    private final TreeMap<T, Rectangle> cellToGcMapping;
    private TreeSet<T> cellCache;
    private Integer dataWidth;
    private Integer dataHeight;
    private boolean isDisposed = false;
    private final int drawXoffset;
    private final int drawYoffset;
    private int yOffset;
    private int xOffset;
    private boolean fixedCellWidth = true;
    private boolean fixedCellHeight = true;
    private double adjustedCanvasWidth;
    private double adjustedCanvasHeight;
    private Closure offsetListener;

    static {
        Color colorSelection = ResourceGetter.getColor((int)175, (int)175, (int)220);
        Color colorBorder = ResourceGetter.getColor((int)0, (int)0, (int)0);
        Color colorBackground = ResourceGetter.getColor((int)255, (int)255, (int)255);
        normal = new NormalCellRenderer(colorSelection, colorBackground, colorBorder);
    }

    public Grid(Canvas canvas, int drawYoffset, int drawXoffset) {
        this.myCanvas = canvas;
        this.drawYoffset = drawYoffset;
        this.drawXoffset = drawXoffset;
        this.myCanvas.setBackground(this.colorBackground);
        this.myCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Grid.this.draw(e);
            }
        });
        this.myCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Grid.this.mouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                Grid.this.mouseUp(e);
            }
        });
        this.myCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (Grid.this.dragging > 0) {
                    Grid grid = Grid.this;
                    grid.dragging = grid.dragging + 1;
                }
                if (Grid.this.dragging > 5) {
                    Point point = new Point(e.x - Grid.this.xOffset - Grid.this.drawXoffset, e.y - Grid.this.yOffset - Grid.this.drawYoffset);
                    Grid.this.drag(point);
                }
            }
        });
        this.myCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Grid.this.dataHeight = null;
                Grid.this.dataWidth = null;
                Grid.this.computeAdjustedCanvasHeight();
                Grid.this.computeAdjustedCanvasWidth();
                if (!Grid.this.fixedCellHeight || !Grid.this.fixedCellWidth) {
                    Grid.this.cellToGcMapping.clear();
                }
            }
        });
        this.myCanvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if (e.stateMask != 131072) {
                    Grid.this.scrollY(e.count);
                }
            }
        });
        this.colorBorder = ResourceGetter.getColor((int)0, (int)0, (int)0);
        this.colorBackground = ResourceGetter.getColor((int)255, (int)255, (int)255);
        this.colorSelection = ResourceGetter.getColor((int)175, (int)175, (int)220);
        this.cellToGcMapping = new TreeMap();
        this.dataListener = new GridDataListener(){

            @Override
            public void linePushed(boolean startLine, boolean endLine) {
                if (!Grid.this.isDisposed) {
                    Grid.this.linePushed_internal(startLine, endLine);
                }
            }

            @Override
            public void columnPushed(boolean startColumn, boolean endColumn) {
                if (!Grid.this.isDisposed) {
                    Grid.this.columnPushed_internal(startColumn, endColumn);
                }
            }
        };
        this.selectionListener = new SelectionListener(){

            @Override
            public void selectionChanged() {
                Grid.this.redraw();
            }
        };
        this.cellRendererFactory = new CellRendererFactory();
        this.cellRendererFactory.registerCellRenderer("normal", normal);
    }

    protected void linePushed_internal(boolean startLine, boolean endLine) {
        this.dataHeight = null;
        this.computeAdjustedCanvasHeight();
        this.computeAdjustedCanvasWidth();
        this.updateCellCache_internal();
        this.updateOffset_internal();
        this.redraw();
    }

    private void updateOffset_internal() {
        TreeSet<T> cells = this.getCells();
        if (cells.isEmpty() || this.cellToGcMapping.isEmpty()) {
            this.yOffset = 0;
            this.xOffset = 0;
        } else {
            Cell cell = (Cell)this.cellToGcMapping.firstKey();
            Rectangle rect1 = this.cellToGcMapping.firstEntry().getValue();
            if (!this.getData().contains((Cell)cell)) {
                cell = (Cell)this.cellToGcMapping.lastKey();
                rect1 = this.cellToGcMapping.lastEntry().getValue();
            }
            this.updateCellToGcMapping_internal();
            Rectangle rect2 = this.getRectangle(cell);
            int yDelta = rect1.y - rect2.y;
            this.yOffset += yDelta;
            int xDelta = rect1.x - rect2.x;
            if (xDelta >= 0) {
                this.xOffset += xDelta;
            }
        }
    }

    protected void columnPushed_internal(boolean startColumn, boolean endColumn) {
    }

    protected void scrollY(int count) {
        count = count < 0 ? Math.max(count, -30) : Math.min(count, 30);
        int yOffset2 = this.yOffset + count * 10;
        this.setYOffset(yOffset2);
    }

    protected void scrollX(int count) {
        int xOffset2 = this.xOffset + count * 10;
        this.setXOffset(xOffset2);
    }

    private void mouseUp(MouseEvent e) {
        this.dragging = 0;
        this.getSelection().finalizeSelection();
    }

    private void mouseDown(MouseEvent e) {
        this.myCanvas.setFocus();
        if (UI.rightClick((MouseEvent)e)) {
            this.dragging = 0;
        } else {
            if (!UI.CTRL((MouseEvent)e)) {
                this.getSelection().clear();
            }
            Point point = this.offsetPoint(e.x, e.y);
            T cell = this.getCellFromGCPoint(point);
            this.selectCell(cell);
            if (cell != null && MonthCell.TYPE != ((Cell)cell).getType()) {
                this.dragging = 1;
            }
        }
    }

    private void selectCell(T cell) {
        if (cell != null && this.getSelection().add(cell)) {
            this.myCanvas.redraw();
        }
    }

    public Canvas getCanvas() {
        return this.myCanvas;
    }

    public Composite getControl() {
        return this.myCanvas;
    }

    public void redraw() {
        this.myCanvas.redraw();
    }

    private void drag(Point gcPoint) {
        T cell = this.getCellFromGCPoint(gcPoint);
        if (cell != null) {
            this.getSelection().dragTo(cell);
            this.getSelection().fireSelectionChanged();
        }
    }

    private void draw(PaintEvent e) {
        Image buffer = new Image((Device)Display.getDefault(), this.isFixedCellWidth() ? this.getDataWidth() : this.myCanvas.getBounds().width, this.isFixedCellHeight() ? this.getDataHeight() : this.myCanvas.getBounds().height);
        this.gcBuffer = new GC((Drawable)buffer);
        try {
            this.gcBuffer.setAntialias(1);
        }
        catch (Exception exception) {}
        try {
            this.gcBuffer.setTextAntialias(1);
        }
        catch (Exception exception) {}
        Rectangle clipingRect = null;
        Rectangle drawRect = null;
        try {
            try {
                Image image = buffer;
                int srcX = Math.abs(this.getXoffset());
                int srcY = Math.abs(this.getYoffset());
                int srcWidth = this.myCanvas.getBounds().width;
                int srcHeight = this.myCanvas.getBounds().height;
                srcWidth = Math.min(srcWidth, image.getBounds().width - srcX);
                srcHeight = Math.min(srcHeight, image.getBounds().height - srcY);
                clipingRect = new Rectangle(srcX, srcY, srcWidth, srcHeight);
                this.drawCells(clipingRect);
                this.drawSelection(clipingRect);
                int destX = this.drawXoffset;
                int destY = this.drawYoffset;
                int destWidth = this.myCanvas.getBounds().width;
                int destHeight = this.myCanvas.getBounds().height;
                destWidth = srcWidth;
                destHeight = srcHeight;
                drawRect = new Rectangle(destX, destY, destWidth, destHeight);
                e.gc.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to draw grid control clipRect " + clipingRect + " drawRect " + drawRect, ex);
                this.drawError();
                this.gcBuffer.dispose();
                buffer.dispose();
            }
        }
        finally {
            this.gcBuffer.dispose();
            buffer.dispose();
        }
    }

    private void drawError() {
        Color foreground = this.gcBuffer.getForeground();
        Color background = this.gcBuffer.getBackground();
        if (this.red == null) {
            this.red = ResourceGetter.getColor((int)255, (int)0, (int)0);
        }
        if (this.black == null) {
            this.black = ResourceGetter.getColor((int)0, (int)0, (int)0);
        }
        this.gcBuffer.setForeground(this.red);
        this.gcBuffer.setBackground(this.black);
        Rectangle drawingRectangle = this.getCanvas().getBounds();
        int rwidth = drawingRectangle.width / 2;
        int rheight = 50;
        int rx1 = drawingRectangle.width / 2 - rwidth / 2;
        int ry1 = drawingRectangle.height / 2 - rheight / 2;
        this.gcBuffer.drawRectangle(rx1, ry1, rwidth, rheight);
        this.gcBuffer.fillRectangle(rx1, ry1, rwidth + 1, rheight + 1);
        String text = Messages.getString((String)"ERREUR", (String[])new String[0]);
        Point textSize = this.gcBuffer.textExtent(text);
        int tx1 = rx1 + rwidth / 2 - textSize.x / 2;
        int ty1 = ry1 + rheight / 2 - textSize.y / 2;
        this.gcBuffer.drawText(text, tx1, ty1, true);
        this.gcBuffer.setForeground(foreground);
        this.gcBuffer.setBackground(background);
    }

    private void drawCells(Rectangle clipingRect) {
        TreeSet<T> cells = this.getCells();
        if (this.cellToGcMapping.isEmpty() && !cells.isEmpty()) {
            this.updateCellToGcMapping_internal();
        }
        for (Cell cell : cells) {
            this.drawCell(cell, clipingRect);
        }
    }

    private TreeSet<T> getCells() {
        if (this.cellCache == null) {
            this.updateCellCache_internal();
        }
        return this.cellCache;
    }

    private void updateCellCache_internal() {
        if (this.cellCache == null) {
            this.cellCache = new TreeSet();
        }
        int startColumn = this.data.getAbsoluteStartColumn();
        int startLine = this.data.getAbsoluteStartLine();
        int endLine = this.data.getAbsoluteEndLine();
        int endColumn = this.data.getAbsoluteEndColumn();
        U data = this.getData();
        if (this.cellCache.isEmpty()) {
            this.addToCache_internal(startLine, endLine, startColumn, endColumn, data);
        } else {
            HashSet<T> toTrunk;
            if (startLine != ((Cell)this.cellCache.first()).line) {
                if (startLine > ((Cell)this.cellCache.first()).line) {
                    toTrunk = new HashSet<T>(this.cellCache.headSet(data.getCell(endColumn, startLine)));
                    this.cellCache.removeAll(toTrunk);
                } else {
                    this.addToCache_internal(startLine, ((Cell)this.cellCache.first()).line, startColumn, endColumn, data);
                }
            }
            if (this.cellCache.isEmpty()) {
                this.addToCache_internal(startLine, endLine, startColumn, endColumn, data);
            } else if (endLine != ((Cell)this.cellCache.last()).line) {
                if (endLine < ((Cell)this.cellCache.last()).line) {
                    toTrunk = new HashSet<T>(this.cellCache.tailSet(data.getCell(endColumn, endLine)));
                    this.cellCache.removeAll(toTrunk);
                } else {
                    this.addToCache_internal(((Cell)this.cellCache.last()).line, endLine, startColumn, endColumn, data);
                }
            }
        }
    }

    private void addToCache_internal(int startLine, int endLine, int startColumn, int endColumn, U data) {
        int line = startLine;
        while (line <= endLine) {
            int column = startColumn;
            while (column <= endColumn) {
                Object cell = data.getCell(column, line);
                if (cell != null) {
                    this.cellCache.add(cell);
                }
                ++column;
            }
            ++line;
        }
    }

    private void drawSelection(Rectangle clipingRect) {
        for (Cell cell : this.getSelection()) {
            this.drawSelectedCell(cell, clipingRect);
        }
    }

    private void drawSelectedCell(T cell, Rectangle clipingRect) {
        Rectangle cellRect = this.getRectangle(cell);
        if (cellRect != null && clipingRect.intersects(cellRect)) {
            CellRenderer<?, ?> renderer = this.cellRendererFactory.getCellRenderer((Cell)cell);
            if (renderer == null) {
                renderer = normal;
            }
            renderer.render(cell, this, this.getData(), this.getRectangle(cell), this.gcBuffer, true);
        }
    }

    private void drawCell(T cell, Rectangle clipingRect) {
        Rectangle cellRect = this.getRectangle(cell);
        if (cellRect != null && clipingRect.intersects(cellRect)) {
            CellRenderer<?, ?> renderer = this.cellRendererFactory.getCellRenderer((Cell)cell);
            if (renderer == null) {
                renderer = normal;
            }
            renderer.render(cell, this, this.getData(), this.getRectangle(cell), this.gcBuffer, false);
        }
    }

    private void updateCellToGcMapping_internal() {
        this.dataHeight = null;
        this.dataWidth = null;
        this.cellToGcMapping.clear();
        TreeSet<T> cells = this.getCells();
        U data = this.getData();
        boolean fixedWidth = this.isFixedCellWidth();
        boolean fixedHeight = this.isFixedCellHeight();
        float dataWidth = this.getDataWidth();
        float dataHeight = this.getDataHeight();
        int line = Integer.MIN_VALUE;
        int cumulWidth = 0;
        int cumulHeight = 0;
        int height = 0;
        for (Cell cell : cells) {
            if (cell.line != line) {
                line = cell.line;
                cumulWidth = 0;
                cumulHeight += height;
            }
            int x = cumulWidth;
            int column = cell.getColumn();
            int width = data.getSumColumnWidth(column, column + cell.spanx);
            if (!fixedWidth) {
                width = (int)((double)((float)width / dataWidth) * this.adjustedCanvasWidth);
            }
            cumulWidth += width;
            int y = cumulHeight;
            int cellLine = cell.getLine();
            height = data.getSumLineHeigth(cellLine, cellLine + cell.spany);
            if (!fixedHeight) {
                height = (int)((double)((float)height / dataHeight) * this.adjustedCanvasHeight);
            }
            Rectangle rect = new Rectangle(x, y, width, height);
            this.cellToGcMapping.put(cell, rect);
        }
    }

    private Rectangle getRectangle(T cell) {
        if (cell == null) {
            return null;
        }
        Rectangle rectangle = this.cellToGcMapping.get(cell);
        return rectangle;
    }

    private int getDataWidth() {
        if (this.dataWidth == null) {
            this.dataWidth = this.data.getSumColumnWidth(this.data.getAbsoluteStartColumn(), this.data.getAbsoluteEndColumn() + 1);
        }
        return this.dataWidth;
    }

    private int getDataHeight() {
        if (this.dataHeight == null) {
            this.dataHeight = this.data.getSumLineHeigth(this.data.getAbsoluteStartLine(), this.data.getAbsoluteEndLine() + 1);
        }
        return this.dataHeight;
    }

    private double getRelativeColumnWidth(int column) {
        float width = this.getData().getColumnWidth(column);
        float dataWidth = this.getDataWidth();
        return (double)(width / dataWidth) * this.adjustedCanvasWidth;
    }

    private double getRelativeLineHeight(int line) {
        float height = this.getData().getLineHeigth(line);
        float dataHeight = this.getDataHeight();
        return (double)(height / dataHeight) * this.adjustedCanvasHeight;
    }

    public int getColumnWidth(int column) {
        int width = 0;
        width = this.fixedCellWidth ? this.data.getColumnWidth(column) : (int)this.getRelativeColumnWidth(column);
        return width;
    }

    public int getLineHeight(int line) {
        int height = 0;
        height = this.fixedCellHeight ? this.data.getLineHeigth(line) : (int)this.getRelativeLineHeight(line);
        return height;
    }

    private void computeAdjustedCanvasWidth() {
        if (this.fixedCellWidth) {
            this.adjustedCanvasWidth = this.myCanvas.getBounds().width - this.drawXoffset;
        } else {
            int canvasWidth = this.myCanvas.getBounds().width;
            double diff = 0.0;
            Integer lastVisibleColumn = this.lastVisibleColumn(false);
            if (lastVisibleColumn != null) {
                int column = this.getData().getAbsoluteStartColumn();
                while (column <= lastVisibleColumn) {
                    double width = this.getData().getColumnWidth(column);
                    double dataWidth = this.getDataWidth();
                    width = width / dataWidth * (double)canvasWidth;
                    diff += width - Math.floor(width);
                    ++column;
                }
            }
            this.adjustedCanvasWidth = Math.ceil((double)this.myCanvas.getBounds().width - diff - (double)this.drawXoffset);
        }
    }

    private void computeAdjustedCanvasHeight() {
        if (this.fixedCellHeight) {
            this.adjustedCanvasHeight = this.myCanvas.getBounds().height - this.drawYoffset;
        } else {
            double canvasHeight = this.myCanvas.getBounds().height;
            double diff = 0.0;
            Integer lastVisibleLine = this.lastVisibleLine(false);
            if (lastVisibleLine != null) {
                int line = this.getData().getAbsoluteStartLine();
                while (line <= lastVisibleLine) {
                    double height = this.getData().getLineHeigth(line);
                    double dataHeight = this.getDataHeight();
                    height = height / dataHeight * canvasHeight;
                    diff += height - Math.floor(height);
                    ++line;
                }
            }
            this.adjustedCanvasHeight = Math.ceil((double)this.myCanvas.getBounds().height - diff - (double)this.drawYoffset);
        }
    }

    public Point offsetPoint(int x, int y) {
        return new Point(x - this.xOffset - this.drawXoffset, y - this.yOffset - this.drawYoffset);
    }

    public T getCellFromGCPoint(Point gcPoint) {
        Cell cell = null;
        Point point2 = new Point(gcPoint.x, gcPoint.y);
        for (Map.Entry<T, Rectangle> entry : this.cellToGcMapping.entrySet()) {
            if (!entry.getValue().contains(point2)) continue;
            cell = (Cell)entry.getKey();
            break;
        }
        return (T)cell;
    }

    public Rectangle getRectangleFromCell(T cell) {
        Rectangle rect = this.cellToGcMapping.get(cell);
        return new Rectangle(rect.x + this.xOffset, rect.y + this.yOffset, rect.width, rect.height);
    }

    public final boolean isDisposed() {
        return this.isDisposed;
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.cellRendererFactory.dispose();
        this.cellRendererFactory = null;
        ResourceGetter.dispose((Object)this.colorBorder);
        ResourceGetter.dispose((Object)this.colorBackground);
        ResourceGetter.dispose((Object)this.colorSelection);
        if (this.gcBuffer != null && !this.gcBuffer.isDisposed()) {
            this.gcBuffer.dispose();
            this.gcBuffer = null;
        }
        if (this.red != null) {
            ResourceGetter.dispose((Object)this.red);
        }
        if (this.black != null) {
            ResourceGetter.dispose((Object)this.black);
        }
        if (this.getSelection() != null) {
            this.getSelection().removeListener(this.selectionListener);
        }
        if (this.data != null) {
            this.data.removeListener(this.dataListener);
            this.data = null;
        }
        if (this.cellToGcMapping != null) {
            this.cellToGcMapping.clear();
        }
        if (this.cellCache != null) {
            this.cellCache.clear();
        }
        this.myCanvas.dispose();
    }

    public U getData() throws IllegalStateException {
        if (this.data == null) {
            throw new IllegalStateException("data has not been set");
        }
        return this.data;
    }

    public final int nbLine() {
        return this.getData().getAbsoluteEndLine() - this.getData().getAbsoluteStartLine();
    }

    public final int nbColumn() {
        return this.getData().getAbsoluteEndColumn() + 1 - this.getData().getAbsoluteStartColumn();
    }

    public void setData(U data) {
        if (data == null) {
            throw new IllegalArgumentException("data cant be null");
        }
        if (this.data != null) {
            this.data.removeListener(this.dataListener);
            this.data.getSelection().removeListener(this.selectionListener);
        }
        this.data = data;
        this.data.addListener(this.dataListener);
        this.data.getSelection().addListener(this.selectionListener);
        this.redraw();
    }

    public Integer firstVisibleLine(boolean strict) {
        Point gcPoint = new Point(0 + this.getXoffset(), 0 + Math.abs(this.getYoffset()));
        T cell = this.getCellFromGCPoint(gcPoint);
        if (cell == null) {
            return null;
        }
        int line1 = ((Cell)cell).line;
        if (strict) {
            Rectangle rect1 = this.getRectangle(cell);
            if (rect1.y + this.getYoffset() < 0) {
                ++line1;
            }
        }
        return line1;
    }

    public Integer lastVisibleLine(boolean strict) {
        T cell2 = this.getCellFromGCPoint(new Point(0 + this.getXoffset(), this.myCanvas.getBounds().height + Math.abs(this.getYoffset())));
        if (cell2 == null) {
            return null;
        }
        int line2 = ((Cell)cell2).line;
        if (strict) {
            Rectangle rect2 = this.getRectangle(cell2);
            if (rect2.y + this.getYoffset() > this.myCanvas.getBounds().height) {
                --line2;
            }
        }
        return line2;
    }

    public Integer firstVisibleColumn(boolean strict) {
        T cell1 = this.getCellFromGCPoint(new Point(0 + this.getXoffset(), 0 + this.getYoffset()));
        if (cell1 == null) {
            return null;
        }
        int column = ((Cell)cell1).column;
        if (strict) {
            Rectangle rect1 = this.getRectangle(cell1);
            if (rect1.x + this.getXoffset() < 0) {
                ++column;
            }
        }
        return column;
    }

    public Integer lastVisibleColumn(boolean strict) {
        T cell2 = this.getCellFromGCPoint(new Point(this.myCanvas.getBounds().width + this.getXoffset(), 0 + this.getYoffset()));
        if (cell2 == null) {
            return null;
        }
        int column = ((Cell)cell2).column;
        if (strict) {
            Rectangle rect2 = this.getRectangle(cell2);
            if (rect2.x + this.getXoffset() > this.myCanvas.getBounds().width) {
                --column;
            }
        }
        return column;
    }

    public boolean isNotVisibleLine(int line, boolean strict) {
        Integer first = this.firstVisibleLine(strict);
        Integer last = this.lastVisibleLine(strict);
        return this.isNotVisibleLine(line, first, last);
    }

    private boolean isNotVisibleLine(int line, Integer first, Integer last) {
        return first == null || last == null || line < first || line > last;
    }

    public boolean isNotVisibleColumn(int column, boolean strict) {
        return column < this.getData().getAbsoluteStartColumn() || column > this.lastVisibleColumn(strict);
    }

    public Selection<T> getSelection() {
        return this.getData().getSelection();
    }

    public void setSelection(Selection<T> newSelection) {
    }

    public void revealAtTop(int column, int line, boolean force) {
        this.reveal(column, line, false, force);
    }

    public void revealAtBottom(int column, int line, boolean force) {
        this.reveal(column, line, true, force);
    }

    private void reveal(int column, int line, boolean revealAtBottom, boolean force) {
        Rectangle rect2;
        Object cell2 = this.getData().getCell(column, line);
        if (cell2 != null && (rect2 = this.getRectangle(cell2)) != null && (force || this.isNotVisible(rect2))) {
            if (revealAtBottom) {
                this.setYOffset(-rect2.y - rect2.height + this.myCanvas.getBounds().height);
            } else {
                this.setYOffset(-rect2.y);
            }
            this.redraw();
        }
    }

    private boolean isNotVisible(Rectangle rect) {
        Rectangle rect2 = new Rectangle(Math.abs(this.xOffset), Math.abs(this.yOffset), this.myCanvas.getBounds().width, this.myCanvas.getBounds().height);
        boolean visible = rect2.union(rect).equals((Object)rect2);
        visible = rect2.intersects(rect);
        return !visible;
    }

    public int getRelativeLine(T cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell cant be null");
        }
        return ((Cell)cell).getLine() - this.getData().getAbsoluteStartLine();
    }

    public int getRelativeColumn(T cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell cant be null");
        }
        return ((Cell)cell).getColumn() - this.getData().getAbsoluteStartColumn();
    }

    public CellRendererFactory getCellRendererFactory() {
        return this.cellRendererFactory;
    }

    public void setCellRendererFactory(CellRendererFactory cellRendererFactory) {
        this.cellRendererFactory = cellRendererFactory;
    }

    private void setYOffset(int v) {
        if (v > 0) {
            this.yOffset = v;
            this.getData().pushStartLine();
        } else if (Math.abs(v) + this.myCanvas.getBounds().height >= this.getDataHeight()) {
            this.yOffset = v;
            this.getData().pushEndLine();
        } else {
            this.yOffset = v;
            this.redraw();
        }
        this.offsetUpdated();
    }

    private void setXOffset(int v) {
        if (v > 0) {
            this.getData().pushStartColumn();
            this.xOffset = v;
        } else if (Math.abs(v) + this.myCanvas.getBounds().height >= this.getDataHeight()) {
            this.xOffset = v;
            this.getData().pushEndColumn();
        } else {
            this.xOffset = v;
            this.redraw();
        }
    }

    public int getYoffset() {
        return this.yOffset;
    }

    public int getXoffset() {
        return this.xOffset;
    }

    public boolean isFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public boolean isFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellWidth(boolean fixedCellWidth) {
        this.fixedCellWidth = fixedCellWidth;
    }

    public void setFixedCellHeight(boolean fixedCellHeight) {
        System.err.println("unsupported feature for now");
    }

    public Closure getOffsetListener() {
        return this.offsetListener;
    }

    public void setOffsetListener(Closure offsetListener) {
        this.offsetListener = offsetListener;
    }

    private void offsetUpdated() {
        if (this.offsetListener != null) {
            this.offsetListener.execute();
        }
    }
}

