/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form.combo;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCitizenship;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CitizenshipCombo
extends MyCombo<XCitizenship> {
    private static final List<CitizenshipCombo> instances = new CopyOnWriteArrayList<CitizenshipCombo>();
    private static final CompletionComboAccessorClient.CompletionComboListener listener = new CompletionComboAccessorClient.CompletionComboListener(){
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                ArrayList<CitizenshipCombo> toRemoveList = new ArrayList<CitizenshipCombo>();
                for (CitizenshipCombo combo : instances) {
                    if (combo == null || combo.getControl().isDisposed()) {
                        toRemoveList.add(combo);
                        continue;
                    }
                    combo.fill();
                }
                instances.removeAll(toRemoveList);
            }
        };

        public void shouldRefresh(ICompletionComboItem item) {
            Display.getDefault().asyncExec(this.refresh);
        }
    };

    static {
        CompletionComboAccessorClient.addListener((String)"citizenship", (CompletionComboAccessorClient.CompletionComboListener)listener);
    }

    public CitizenshipCombo(Composite parent, FormToolkit toolkit) {
        super(parent, 8, toolkit);
        this.setAutoComplete(true);
        this.setLabelProvider(new ProviderAR<XCitizenship, String>(){

            public String get(XCitizenship citizenship) {
                return citizenship == null ? "" : citizenship.getText();
            }
        });
        this.fill();
        instances.add(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                instances.remove(CitizenshipCombo.this);
            }
        });
    }

    protected void fill() {
        block4: {
            final String text = this.getText();
            final XCitizenship selection = (XCitizenship)this.getSelection();
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!CitizenshipCombo.this.getControl().isDisposed()) {
                                CitizenshipCombo.this.removeAllNoNotify();
                                CitizenshipCombo.this.setItems((List)response.getObj());
                                if (selection != null) {
                                    CitizenshipCombo.this.selectNoNotify(selection);
                                } else {
                                    CitizenshipCombo.this.setTextNoNotify(text);
                                }
                            }
                        }
                    });
                }
            };
            try {
                CompletionComboAccessorClient.getInstance().findAllAsync(Application.get().getGlobalInstances().getSession(), (ICallback)callback, "citizenship");
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                Log.severe((Throwable)e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    @Override
    public void select(XCitizenship item) {
        if (this.contains(item)) {
            super.select(item);
        } else {
            this.add(item);
            super.select(item);
        }
    }
}

