/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.FontAwareDateTime;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.util1.date.LocalDate;
import java.util.Calendar;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;

public class MyDateTime
extends Composite {
    private MyCalendarText date;
    private FontAwareDateTime time;
    private Calendar cal;

    public MyDateTime(Composite parent, int style) {
        super(parent, style);
        this.createControls();
    }

    private void createControls() {
        FormLayout f = new FormLayout();
        f.marginTop = 0;
        f.marginBottom = 0;
        f.marginLeft = 0;
        f.marginRight = 0;
        f.spacing = 0;
        f.marginWidth = 0;
        this.setLayout((Layout)f);
        this.date = new MyCalendarText((Composite)this, 131072);
        this.time = new FontAwareDateTime(this, 32896);
        this.time.setTime(0, 0, 0);
        FormData d = new FormData();
        d.top = new FormAttachment(0);
        d.left = new FormAttachment(0);
        d.height = 26;
        this.date.setLayoutData(d);
        d = new FormData();
        d.top = new FormAttachment(0);
        d.left = new FormAttachment(this.date.getControl(), 0);
        d.height = 26;
        d.right = new FormAttachment(100);
        this.time.setLayoutData(d);
        this.date.addDateListener(new DateText.DateAdapter(){

            @Override
            public void dateChanged(LocalDate date) {
                MyDateTime.this.cal = MyDateTime.this.getDateTime();
                MyDateTime.this.setDateTime(date);
            }
        });
        this.time.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar s = MyDateTime.this.getDateTime();
                if (s == null) {
                    s = Calendar.getInstance();
                }
                DateTime d = (DateTime)e.getSource();
                s.set(11, d.getHours());
                s.set(12, d.getMinutes());
                s.set(13, 0);
                MyDateTime.this.cal = s;
            }
        });
    }

    public void setDateTime(LocalDate l) {
        Calendar s = this.getDateTime();
        if (l != null) {
            if (s == null) {
                s = Calendar.getInstance();
                s.set(11, 0);
                s.set(12, 0);
                s.set(13, 0);
                s.set(14, 0);
            }
            s.set(l.getYear(), l.getMonth() - 1, l.getDay());
        } else {
            s = null;
            this.time.setTime(0, 0, 0);
        }
        this.cal = s;
    }

    public void setDateTime(Calendar s) {
        this.date.setDate2(s);
        if (s != null) {
            s.getTimeInMillis();
            this.time.setTime(s.get(11), s.get(12), 0);
        } else {
            this.time.setTime(0, 0, 0);
        }
        this.cal = s;
    }

    public Calendar getDateTime() {
        return this.cal;
    }

    public void addDateSelectionListener(DateText.IDateListener listener) {
        this.date.addDateListener(listener);
    }

    public void addTimeSelectionListener(SelectionListener selectionListener) {
        this.time.addSelectionListener(selectionListener);
    }

    public void removeDateSelectionListener(DateText.IDateListener listener) {
        this.date.removeCalendarListener(listener);
    }

    public void removeTimeSelectionListener(SelectionListener selectionListener) {
        this.time.removeSelectionListener(selectionListener);
    }

    public void setBackground(Color color) {
        this.date.setBackground(color);
        this.time.setBackground(color);
        super.setBackground(color);
    }

    public void setEnabled(boolean b) {
        this.date.setEnabled(b);
        this.time.setEnabled(b);
        super.setEnabled(b);
    }

    public void setVisible(boolean b) {
        this.date.setVisible(b);
        this.time.setVisible(b);
        super.setVisible(b);
    }
}

