/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.ui.library.log.Log;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormSpinner
extends Composite {
    public Spinner mySpinner;
    public Label myLabel;
    private Color colorForeground;

    public FormSpinner(Composite parent, FormToolkit toolkit) {
        this(parent, toolkit, 0);
    }

    public FormSpinner(Composite parent, FormToolkit toolkit, int style) {
        super(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        this.setLayout((Layout)layout);
        this.myLabel = toolkit.createLabel((Composite)this, "", 0);
        this.mySpinner = new Spinner((Composite)this, style);
        toolkit.adapt((Composite)this);
        this.mySpinner.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    e.doit = true;
                }
            }
        });
    }

    public void setMinMax(int min, int max) {
        this.mySpinner.setMinimum(min);
        this.mySpinner.setMaximum(max);
    }

    public void setMin(int min) {
        this.mySpinner.setMinimum(min);
    }

    public void setMax(int max) {
        this.mySpinner.setMaximum(max);
    }

    public void setDigits(int i) {
        this.mySpinner.setDigits(i);
    }

    public int getDigits() {
        return this.mySpinner.getDigits();
    }

    public void setValue(int i) {
        this.mySpinner.setSelection(i);
    }

    public int getValue() {
        return this.mySpinner.getSelection();
    }

    public String getText() {
        return String.valueOf(this.getValue());
    }

    public void setStringValue(String value) {
        int iValue = Integer.MIN_VALUE;
        try {
            if (value != null && value.length() > 0 && (iValue = Integer.parseInt(value)) != Integer.MIN_VALUE) {
                this.mySpinner.setSelection(iValue);
            }
        }
        catch (Exception e) {
            Log.severe((String)"Erreur", (Exception)e);
        }
    }

    public void setText(String s) {
        this.myLabel.setText(s);
    }

    public boolean setFocus() {
        return this.mySpinner.setFocus();
    }

    public void setBackgroundColor(Color color) {
        this.colorForeground = color;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mySpinner.setVisible(visible);
    }

    public boolean getVisible() {
        return this.mySpinner.getVisible();
    }

    public Object getData() {
        return this.mySpinner.getData();
    }

    public void setData(Object obj) {
        this.mySpinner.setData(obj);
    }

    public Object getData(String key) {
        return this.mySpinner.getData(key);
    }

    public void setData(String key, Object obj) {
        this.mySpinner.setData(key, obj);
    }
}

