/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.form.ComplexNumberText;
import ca.infodata.ofys.ui.controls.form.INumberConverter;
import ca.infodata.ofys.ui.library.UI;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EnglishSystemDialog {
    private static final String SYSTEN_ANGLAIS = Messages.getString((String)"EnglishSystemDialog.SYSTEN_ANGLAIS", (String[])new String[0]);
    private static final String OK = Messages.getString((String)"OK", (String[])new String[0]);
    private static final String ANNULER = Messages.getString((String)"ANNULER", (String[])new String[0]);
    private ComplexNumberText txtValue;
    private INumberConverter converter;
    private Label lblTo;
    private Number value;
    private Shell dialog;

    public EnglishSystemDialog(Shell parent, INumberConverter converter) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (converter == null) {
            throw new NullPointerException("converter");
        }
        this.dialog = new Shell(parent, 67616);
        this.converter = converter;
        this.dialog.setText(SYSTEN_ANGLAIS);
        this.createControls((Composite)this.dialog);
        this.dialog.pack();
        this.dialog.setSize(300, 125);
        UI.centerComposite((Composite)this.dialog, (Composite)parent);
    }

    private void createControls(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.txtValue = new ComplexNumberText(parent, 0);
        this.lblTo = new Label(parent, 0);
        this.lblTo.setText(this.converter.getToUnitText());
        Button btnOk = new Button(parent, 8);
        btnOk.setText(OK);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EnglishSystemDialog.this.ok();
            }
        });
        Button btnCancel = new Button(parent, 8);
        btnCancel.setText(ANNULER);
        this.txtValue.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasDoneCR;
                boolean bl = hasDoneCR = e.keyCode == 0x1000050 || e.keyCode == 13;
                if (hasDoneCR) {
                    e.doit = false;
                    EnglishSystemDialog.this.ok();
                } else if (e.character == '\u001b') {
                    e.doit = false;
                    EnglishSystemDialog.this.cancel();
                }
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EnglishSystemDialog.this.cancel();
            }
        });
        FormData data = new FormData();
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(52);
        data.right = new FormAttachment(95);
        btnCancel.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(5);
        data.right = new FormAttachment(48);
        btnOk.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(5);
        data.right = new FormAttachment(75);
        this.txtValue.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(76);
        data.right = new FormAttachment(95);
        this.lblTo.setLayoutData((Object)data);
    }

    private void ok() {
        this.value = this.txtValue.getNumber();
        this.dialog.close();
    }

    private void cancel() {
        this.value = null;
        this.dialog.close();
    }

    public void setValue(Number value) {
        this.value = value;
        if (!this.dialog.isDisposed()) {
            this.txtValue.setNumber(this.converter.convert(value == null ? null : Double.valueOf(value.doubleValue())));
        }
    }

    public Double getValue() {
        Double d = this.converter.inverse(this.value == null ? null : Double.valueOf(this.value.doubleValue()));
        if (d != null) {
            d = EnglishSystemDialog.roundSmallNumber(d, 2);
        }
        return d;
    }

    private static double roundSmallNumber(double d, int digit) {
        if (digit < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, digit);
        double value = d * (double)factor;
        long tmp = Math.round(value);
        return (double)tmp / (double)factor;
    }

    public Shell getDialog() {
        return this.dialog;
    }

    public void open() {
        this.dialog.open();
        Display display = this.dialog.getDisplay();
        while (!this.dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void close() {
        this.dialog.close();
    }
}

