/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.calendar.grid;

import ca.infodata.ofys.ui.controls.grid.Selection;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.Collection;
import java.util.List;

public class CalendarSelection
extends Selection<LocalDate> {
    private static final long serialVersionUID = 1L;

    protected CalendarSelection() {
        this.setSelectionPredicate(new PredicateA<LocalDate>(){

            public boolean evaluate(LocalDate date) {
                return date != null;
            }
        });
    }

    public void clearAddWeekAndFinalize(LocalDate dateInTheWeek) {
        this.clear();
        this.addWeek(dateInTheWeek);
        this.finalizeSelection();
    }

    public void addWeek(LocalDate dateInTheWeek) {
        super.addAll(LocalDate.generateList((LocalDate)dateInTheWeek.withDayOfWeek(1), (LocalDate)dateInTheWeek.withDayOfWeek(7)));
    }

    @Override
    protected Collection<LocalDate> generateCollection(LocalDate from, boolean incluviseFrom, LocalDate to, boolean inclusiveTo) {
        List list = from.before((IPartialDate)to) ? LocalDate.generateList((LocalDate)from, (LocalDate)to) : LocalDate.generateList((LocalDate)to, (LocalDate)from);
        if (!incluviseFrom) {
            list.remove(from);
        }
        if (!inclusiveTo) {
            list.remove(to);
        }
        return list;
    }

    @Override
    public CalendarSelection clone() {
        return (CalendarSelection)super.clone();
    }
}

