/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.calendar.grid;

import ca.infodata.ofys.ui.controls.calendar.grid.CalendarCell;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarSelection;
import ca.infodata.ofys.ui.controls.calendar.grid.ICalendarGridData;
import ca.infodata.ofys.ui.controls.calendar.grid.MonthCell;
import ca.infodata.ofys.ui.controls.calendar.grid.NullCell;
import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.GridDataListener;
import ca.infodata.ofys.ui.controls.grid.GridSelection;
import ca.infodata.ofys.ui.controls.grid.Selection;
import ca.infodata.ofys.ui.controls.grid.SelectionListener;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class CalendarGridData2
implements ICalendarGridData {
    private int absoluteEndLine;
    private int absoluteStartLine;
    private LocalDate absoluteStartDate;
    private LocalDate absoluteEndDate;
    private List<GridDataListener> listeners = new ArrayList<GridDataListener>();
    private TreeMap<Integer, Cell[]> data;
    private TreeMap<LocalDate, Integer> dateMapLine;
    private TreeMap<Integer, Integer> linesHeight;
    private Cell[] line;
    private int lineIndex;
    private LocalDate runningDate;
    private Selection<Cell> gridSelection;
    private CalendarSelection calendarSelection;
    private boolean ignoreSelectionEvent;
    private int nbMonthToPush;

    public CalendarGridData2(LocalDate absoluteStartDate, LocalDate absoluteEndDate, int nbMonthToPush) {
        this.absoluteStartDate = absoluteStartDate;
        this.absoluteEndDate = absoluteEndDate;
        this.nbMonthToPush = nbMonthToPush;
        this.gridSelection = new GridSelection<Cell>(this);
        this.gridSelection.setSelectionPredicate(new PredicateA<Cell>(){

            public boolean evaluate(Cell cell) {
                return cell != null && cell instanceof CalendarCell && ((CalendarCell)cell).getDate() != null;
            }
        });
        this.calendarSelection = new CalendarSelection();
        this.calendarSelection.addListener(new SelectionListener(){

            @Override
            public void selectionChanged() {
                if (CalendarGridData2.this.ignoreSelectionEvent) {
                    return;
                }
                CalendarGridData2.this.synchronizeCalendarSelectionToGridSelection();
            }
        });
        this.gridSelection.addListener(new SelectionListener(){

            @Override
            public void selectionChanged() {
                if (CalendarGridData2.this.ignoreSelectionEvent) {
                    return;
                }
                CalendarGridData2.this.synchronizeGridSelectionToCalendarSelection();
            }
        });
        this.data = new TreeMap();
        this.dateMapLine = new TreeMap();
        this.linesHeight = new TreeMap();
        this.absoluteStartLine = 0;
        this.absoluteEndLine = 0;
        this.fill(absoluteStartDate, absoluteEndDate);
        this.fillLineHeight();
    }

    private void synchronizeGridSelectionToCalendarSelection() {
        this.calendarSelection.clear();
        for (Cell cell : this.gridSelection) {
            LocalDate date = this.getDate(cell.getColumn(), cell.getLine());
            if (date == null) continue;
            this.calendarSelection.add(date);
        }
        this.ignoreSelectionEvent = true;
        this.calendarSelection.finalizeSelection();
        this.ignoreSelectionEvent = false;
    }

    private void synchronizeCalendarSelectionToGridSelection() {
        this.gridSelection.clear();
        for (LocalDate date : this.calendarSelection.clone()) {
            CalendarCell cell = this.getCell(date);
            if (cell == null) continue;
            this.gridSelection.add(cell);
        }
        this.ignoreSelectionEvent = true;
        this.gridSelection.finalizeSelection();
        this.ignoreSelectionEvent = false;
    }

    private void recomputeCalendarSelection() {
        Iterator iterator = this.calendarSelection.iterator();
        while (iterator.hasNext()) {
            LocalDate date = (LocalDate)iterator.next();
            if (this.contains(date)) continue;
            iterator.remove();
        }
        this.synchronizeCalendarSelectionToGridSelection();
        this.gridSelection.fireSelectionChanged();
        this.calendarSelection.fireSelectionChanged();
    }

    private void reverseFill(LocalDate from, LocalDate to) {
        this.runningDate = to.plusDay(-1);
        this.line = null;
        this.lineIndex = this.absoluteStartLine;
        while (this.runningDate.after((IPartialDate)from) || this.runningDate == from) {
            if (this.dateMapLine.containsKey(this.runningDate)) {
                this.runningDate = this.runningDate.plusDay(-1);
                continue;
            }
            this.newReverseCalendarLine();
        }
        this.absoluteStartLine = this.data.firstKey();
    }

    private void newReverseCalendarLine() {
        if (this.runningDate.day - 7 <= 0) {
            this.newReverseCalendarStartLine();
        } else if (this.runningDate.day == this.runningDate.getMonthEnd()) {
            this.newReverseCalendarEndLine();
        } else {
            this.newReverseEmptyLine();
            int column = 6;
            while (column >= 0) {
                this.line[column] = this.newCalendarCell(column, this.lineIndex, this.runningDate);
                this.runningDate = this.runningDate.plusDay(-1);
                --column;
            }
        }
    }

    private void newReverseCalendarStartLine() {
        this.newReverseEmptyLine();
        byte month = this.runningDate.month;
        int year = this.runningDate.year;
        int column = 6;
        while (column >= 0) {
            if (this.runningDate.day <= 7) {
                this.line[column] = this.newCalendarCell(column, this.lineIndex, this.runningDate);
                this.runningDate = this.runningDate.plusDay(-1);
            } else {
                this.line[column] = new NullCell(column, this.lineIndex);
            }
            --column;
        }
        this.newReverseMonthLine(month, year);
    }

    private void newReverseMonthLine(byte month, int year) {
        this.newReverseEmptyLine();
        this.line[0] = new MonthCell(0, this.lineIndex, 7, (int)month, year);
    }

    private void newReverseEmptyLine() {
        this.line = new Cell[7];
        --this.lineIndex;
        this.data.put(this.lineIndex, this.line);
    }

    private void newReverseCalendarEndLine() {
        this.newReverseEmptyLine();
        int endDayOfWeek = this.runningDate.dayOfWeek;
        int column = 6;
        while (column >= 0) {
            if (column >= endDayOfWeek) {
                this.line[column] = new NullCell(column, this.lineIndex);
            } else {
                this.line[column] = this.newCalendarCell(column, this.lineIndex, this.runningDate);
                this.runningDate = this.runningDate.plusDay(-1);
            }
            --column;
        }
    }

    private void fill(LocalDate from, LocalDate to) {
        this.runningDate = from;
        this.line = null;
        this.lineIndex = this.data.isEmpty() ? -1 : this.absoluteEndLine;
        while (this.runningDate.before((IPartialDate)to) || this.runningDate == to) {
            if (this.dateMapLine.containsKey(this.runningDate)) {
                this.runningDate = this.runningDate.plusDay(1);
                continue;
            }
            this.newCalendarLine();
        }
        this.absoluteEndLine = this.data.lastKey();
    }

    private void newCalendarLine() {
        if (this.runningDate.day == 1) {
            this.newCalendarStartLine();
        } else if (this.runningDate.day + 6 > this.runningDate.getMonthEnd()) {
            this.newCalendarEndLine();
        } else {
            this.newEmptyLine();
            int column = 0;
            while (column < 7) {
                this.line[column] = this.newCalendarCell(column, this.lineIndex, this.runningDate);
                this.runningDate = this.runningDate.plusDay(1);
                ++column;
            }
        }
    }

    private void newCalendarEndLine() {
        this.newEmptyLine();
        int diff = this.runningDate.getMonthEnd() - this.runningDate.day + 1;
        int column = 0;
        while (column < diff) {
            this.line[column] = this.newCalendarCell(column, this.lineIndex, this.runningDate);
            this.runningDate = this.runningDate.plusDay(1);
            ++column;
        }
        column = diff;
        while (column < 7) {
            this.line[column] = new NullCell(column, this.lineIndex);
            ++column;
        }
    }

    private void newCalendarStartLine() {
        this.newMonthLine(this.runningDate);
        this.newEmptyLine();
        int column = 0;
        while (column < 7) {
            if (column < this.runningDate.dayOfWeek - 1) {
                this.line[column] = new NullCell(column, this.lineIndex);
            } else {
                this.line[column] = this.newCalendarCell(column, this.lineIndex, this.runningDate);
                this.runningDate = this.runningDate.plusDay(1);
            }
            ++column;
        }
    }

    protected CalendarCell newCalendarCell(int column, int line, LocalDate date) {
        this.dateMapLine.put(date, line);
        return new CalendarCell(column, line, date);
    }

    private void newMonthLine(LocalDate date) {
        this.newEmptyLine();
        this.line[0] = new MonthCell(0, this.lineIndex, 7, (int)date.month, date.year);
    }

    private void newEmptyLine() {
        this.line = new Cell[7];
        ++this.lineIndex;
        this.data.put(this.lineIndex, this.line);
    }

    private void fillLineHeight() {
        this.linesHeight = new TreeMap();
        for (Integer line : this.data.keySet()) {
            this.linesHeight.put(line, this.internal_getLineHeigth(line));
        }
    }

    private int internal_getLineHeigth(int line) {
        if (this.isMonthCellLine(line)) {
            return MonthCell.height;
        }
        return 50;
    }

    private void pushIfLineNeeded(LocalDate date) {
        if (date.before((IPartialDate)this.absoluteStartDate)) {
            int nbMonth = date.getMonthDiff(this.absoluteStartDate);
            this.pushStartLine(nbMonth - this.nbMonthToPush);
        } else if (date.after((IPartialDate)this.absoluteEndDate)) {
            int nbMonth = date.getMonthDiff(this.absoluteEndDate);
            this.pushEndLine(nbMonth + this.nbMonthToPush);
        }
    }

    @Override
    public void pushStartLine() {
        this.pushStartLine(-this.nbMonthToPush);
    }

    public void pushStartLine(int nbMonth) {
        LocalDate date = this.absoluteStartDate.plusMonth(nbMonth).withDay(1);
        this.reverseFill(date, this.absoluteStartDate);
        Integer line = this.dateMapLine.get(this.absoluteEndDate);
        this.dateMapLine.tailMap(this.absoluteEndDate, false).clear();
        this.data.tailMap(line, false).clear();
        this.absoluteStartDate = date;
        this.absoluteEndDate = this.absoluteEndDate.plusMonth(nbMonth).withDayEndOfMonth();
        this.absoluteStartLine = this.data.firstKey();
        this.absoluteEndLine = this.data.lastKey();
        this.fillLineHeight();
        this.recomputeCalendarSelection();
        for (GridDataListener listener : this.listeners) {
            listener.linePushed(true, true);
        }
    }

    @Override
    public void pushEndLine() {
        this.pushEndLine(this.nbMonthToPush);
    }

    public void pushEndLine(int nbMonth) {
        LocalDate date = this.absoluteEndDate.plusMonth(nbMonth).withDayEndOfMonth();
        this.fill(this.absoluteEndDate, date);
        Integer line = this.dateMapLine.get(this.absoluteStartDate);
        this.dateMapLine.headMap(this.absoluteStartDate, false).clear();
        this.data.headMap(line - 1, false).clear();
        this.absoluteStartDate = this.absoluteStartDate.plusMonth(nbMonth).withDay(1);
        this.absoluteEndDate = date;
        this.absoluteStartLine = this.data.firstKey();
        this.absoluteEndLine = this.data.lastKey();
        this.fillLineHeight();
        this.recomputeCalendarSelection();
        for (GridDataListener listener : this.listeners) {
            listener.linePushed(true, true);
        }
    }

    @Override
    public void pushStartColumn() {
    }

    @Override
    public void pushEndColumn() {
    }

    @Override
    private boolean contains(LocalDate date) {
        return date == this.absoluteStartDate || date == this.absoluteEndDate || date.after((IPartialDate)this.absoluteStartDate) && date.before((IPartialDate)this.absoluteEndDate);
    }

    @Override
    public LocalDate getDate(int column, int line) {
        Cell cell = this.data.get(line)[column];
        if (cell instanceof CalendarCell) {
            return ((CalendarCell)cell).getDate();
        }
        return null;
    }

    @Override
    public Cell getCell(int column, int line) {
        if (column > this.getAbsoluteEndColumn()) {
            throw new IllegalArgumentException("column > absoluteEndColumn");
        }
        if (line > this.absoluteEndLine) {
            throw new IllegalArgumentException("line > absoluteEndLine");
        }
        if (this.isMonthCellLine(line)) {
            Cell[] cells = this.data.get(line);
            return cells == null || cells.length == 0 ? null : cells[0];
        }
        Cell[] cells = this.data.get(line);
        return cells == null || cells.length <= column ? null : cells[column];
    }

    @Override
    public boolean isMonthCellLine(int line) {
        Cell[] cells = this.data.get(line);
        return cells != null && cells.length > 0 && cells[0] != null && MonthCell.TYPE == cells[0].getType();
    }

    @Override
    public CalendarCell getCell(LocalDate date) {
        if (date == null) {
            throw new IllegalArgumentException("date cant be null");
        }
        this.pushIfLineNeeded(date);
        Integer line = this.dateMapLine.get(date);
        if (line != null) {
            Cell[] cells = this.data.get(line);
            int column = 0;
            while (column < cells.length) {
                if (cells[column] instanceof CalendarCell && ((CalendarCell)cells[column]).getDate() == date) {
                    return (CalendarCell)cells[column];
                }
                ++column;
            }
        }
        return null;
    }

    @Override
    public MonthCell getMonthCell(LocalDate date) {
        if (date == null) {
            throw new IllegalArgumentException("date cant be null");
        }
        date = date.withDay(1);
        Cell cell = this.getCell(date);
        int line = cell.line;
        while (line >= this.absoluteStartLine) {
            cell = this.data.get(line)[0];
            if (cell instanceof MonthCell) {
                return (MonthCell)cell;
            }
            --line;
        }
        return null;
    }

    @Override
    public int getColumnWidth(int column) {
        return 75;
    }

    @Override
    public int getSumColumnWidth(int startColumn, int endColumn) {
        return (endColumn - startColumn) * 75;
    }

    @Override
    public int getSumLineHeigth(int startLine, int endLine) {
        int sum = 0;
        int line = startLine;
        while (line < endLine) {
            Integer i = this.linesHeight.get(line);
            if (i == null) {
                System.err.println("height null for line " + line + " " + this.linesHeight.firstKey() + ", " + this.linesHeight.lastKey());
            }
            sum += i.intValue();
            ++line;
        }
        return sum;
    }

    @Override
    public int getLineHeigth(int line) {
        return this.linesHeight.get(line);
    }

    @Override
    public LocalDate getStartDate() {
        return this.absoluteStartDate;
    }

    @Override
    public int getAbsoluteEndColumn() {
        return 6;
    }

    @Override
    public int getAbsoluteEndLine() {
        return this.absoluteEndLine;
    }

    @Override
    public int getAbsoluteStartColumn() {
        return 0;
    }

    @Override
    public int getAbsoluteStartLine() {
        return this.absoluteStartLine;
    }

    @Override
    public void addListener(GridDataListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(GridDataListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Selection<Cell> getSelection() {
        return this.gridSelection;
    }

    @Override
    public CalendarSelection getCalendarSelection() {
        return this.calendarSelection;
    }

    public LocalDate getAbsoluteStartDate() {
        return this.absoluteStartDate;
    }

    public LocalDate getAbsoluteEndDate() {
        return this.absoluteEndDate;
    }

    @Override
    public boolean contains(Cell cell) {
        return this.getCell(cell.column, cell.line) != null;
    }
}

