/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.ProviderAAR;
import ca.infodata.ofys.ui.controls.TableItemComparator;
import ca.infodata.ofys.ui.controls.TableSortListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableDataAdapter<E> {
    private TableSortListener<E> sortListener;
    private Table table;
    private ProviderAAR<E, Table, TableItem> itemProvider;
    private List<E> items;

    public TableDataAdapter(Table table) {
        this.table = table;
        this.items = new ArrayList();
        this.sortListener = new TableSortListener(table, this);
    }

    public TableColumn addColumn(String title) {
        return this.addColumn(title, 16384);
    }

    public TableColumn addColumn(String title, int style) {
        TableColumn tc = new TableColumn(this.table, style);
        tc.setText(title);
        tc.setData("comparator", (Object)new TableItemComparator(this.table.getColumnCount() - 1));
        tc.addListener(13, this.sortListener);
        return tc;
    }

    public TableColumn addColumn(String title, Comparator<E> columnComparator) {
        TableColumn tc = new TableColumn(this.table, 16384);
        tc.setText(title);
        tc.setData("comparator", columnComparator);
        tc.addListener(13, this.sortListener);
        return tc;
    }

    public ProviderAAR<E, Table, TableItem> getItemProvider() {
        return this.itemProvider;
    }

    public void setItemProvider(ProviderAAR<E, Table, TableItem> itemProvider) {
        this.itemProvider = itemProvider;
    }

    public void remove(E e) {
        int indexOf = this.items.indexOf(e);
        if (indexOf != -1) {
            this.items.remove(indexOf);
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData() == e) {
                    item.dispose();
                }
                ++n2;
            }
            this.table.redraw();
        }
    }

    public void removeAll() {
        this.items.clear();
        this.table.deselectAll();
        this.table.removeAll();
        this.table.clearAll();
    }

    public void setItems(E[] items) {
        this.removeAll();
        if (items != null) {
            E[] EArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                E e = EArray[n2];
                this.add(e);
                ++n2;
            }
        }
    }

    public void setItems(Collection<E> items) {
        this.removeAll();
        if (items != null) {
            for (E e : items) {
                this.add(e);
            }
        }
    }

    public void add(E item) {
        this.items.add(item);
        if (this.itemProvider == null) {
            throw new IllegalStateException("no item provider configured");
        }
        TableItem tbItem = this.itemProvider.get(item, this.table);
        tbItem.setData(item);
    }

    public void addAll(Collection<E> c) {
        for (E e : c) {
            this.add(e);
        }
    }

    public E getSelection3() {
        int selectionCount = this.table.getSelectionCount();
        if (selectionCount == 0) {
            return null;
        }
        TableItem[] selection = this.table.getSelection();
        return (E)selection[0].getData();
    }

    public List<E> getSelection() {
        TableItem[] selectionItems = this.table.getSelection();
        ArrayList<Object> selection = new ArrayList<Object>(selectionItems.length);
        int i = 0;
        while (i < selectionItems.length) {
            selection.add(selectionItems[i].getData());
            ++i;
        }
        return selection;
    }

    public void selectNone() {
        this.table.deselectAll();
    }

    public void select(E e) {
        int indexOf = this.items.indexOf(e);
        if (indexOf != -1) {
            this.table.select(indexOf);
        }
    }

    public List<E> getItems() {
        return this.items;
    }
}

