/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.ICallbackControl;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.pdf.Messages;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;

public class CallbackControlDecorator<A> {
    private static final Logger logger = Logger.getLogger(IStatusHandlerImplementation.class.getName());
    private final ICallbackControl<A> control;
    private ControlDecoration errorDecorator;
    private SelectionAdapter errorDecoratorSelectionListener;

    public CallbackControlDecorator(ICallbackControl<A> control) {
        this.control = control;
    }

    public void showAsLoading(A arg) {
        if (this.isDisposed()) {
            return;
        }
        try {
            if (this.errorDecorator != null) {
                this.errorDecorator.hide();
            }
            this.control.showAsLoading(arg);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            this.showErrorInSwtThread(arg, "Erreur", e);
        }
    }

    public void showAsLoadedInSwtThread(final A arg, final ReturnObject response) {
        if (this.isDisposed()) {
            return;
        }
        if (UI.isCurrentThreadIsUIThread()) {
            this.showAsLoaded(arg, response);
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CallbackControlDecorator.this.showAsLoaded(arg, response);
                }
            });
        }
    }

    private Display getDisplay() {
        return this.control.getControl().getDisplay();
    }

    private boolean isDisposed() {
        return this.control.getControl().isDisposed();
    }

    protected final void showAsLoaded(A arg, ReturnObject response) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.control.showAsLoaded(arg, response);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            this.showErrorInSwtThread(arg, "Erreur", e);
        }
    }

    public void showErrorInSwtThread(final A arg, String message, Throwable e) {
        if (this.isDisposed()) {
            return;
        }
        if (UI.isCurrentThreadIsUIThread()) {
            this.control.showAsError(arg);
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CallbackControlDecorator.this.control.showAsError(arg);
                }
            });
        }
    }

    protected void showErrorComposite(A arg, final String message, final Throwable ex) {
        if (this.isDisposed()) {
            return;
        }
        if (this.errorDecorator == null) {
            this.errorDecorator = new ControlDecoration(this.control.getControl(), 16512);
            FieldDecoration errorFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.errorDecorator.setImage(errorFieldIndicator.getImage());
            this.errorDecorator.setDescriptionText(Messages.getString((String)"ERREUR"));
            this.errorDecoratorSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CallbackControlDecorator.this.showErrorDialog(message, ex);
                }
            };
            this.errorDecorator.addSelectionListener((SelectionListener)this.errorDecoratorSelectionListener);
        } else {
            this.errorDecorator.show();
            this.errorDecorator.removeSelectionListener((SelectionListener)this.errorDecoratorSelectionListener);
            this.errorDecoratorSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CallbackControlDecorator.this.showErrorDialog(message, ex);
                }
            };
            this.errorDecorator.addSelectionListener((SelectionListener)this.errorDecoratorSelectionListener);
        }
    }

    protected void showErrorDialog(String message, Throwable ex) {
        String message2 = StringUtils.isNotBlank((String)message) ? message : (ex != null ? (StringUtils.isNotBlank((String)ex.getLocalizedMessage()) ? ex.getLocalizedMessage() : MessageUtil.UNEXPECTED_ERROR_MESSAGE) : MessageUtil.UNEXPECTED_ERROR_MESSAGE);
        MyMessageDialogBuilder builder = new MyMessageDialogBuilder();
        builder.useErrorBundle();
        builder.setMessage(message2);
        builder.buildAndOpen();
    }

    public Callback newCallback(A arg) {
        return new CallbackExtension(arg);
    }

    final class CallbackExtension
    extends Callback {
        public A arg;

        public CallbackExtension(A arg) {
            super((IStatusHandler)new IStatusHandlerImplementation(arg));
            this.arg = arg;
            this.showMessage = false;
        }

        public CallbackExtension() {
            this(null);
        }

        public void responseReceived(ReturnObject response) {
            IStatusHandlerImplementation h = (IStatusHandlerImplementation)this.getStatusHandler();
            if (!h.skipResponseReceived) {
                super.responseReceived(response);
                CallbackControlDecorator.this.showAsLoadedInSwtThread(this.arg, response);
            }
        }

        public void exception(Exception e) {
            super.exception(e);
            CallbackControlDecorator.this.showErrorInSwtThread(this.arg, e.getMessage(), e);
        }
    }

    final class IStatusHandlerImplementation
    implements IStatusHandler {
        String message;
        boolean skipResponseReceived;
        A arg;

        public IStatusHandlerImplementation(A arg) {
            this.arg = arg;
        }

        public IStatusHandler.State handle(IStatus status) {
            this.message = null;
            this.skipResponseReceived = false;
            if (status == null) {
                return IStatusHandler.State.NOT_HANDLED;
            }
            switch (status.getSeverity()) {
                case OK: 
                case INFO: 
                case WARNING: 
                case NEED_MORE_INFO: {
                    break;
                }
                case ERROR: {
                    this.message = status.getMessage();
                    this.skipResponseReceived = true;
                    CallbackControlDecorator.this.showErrorInSwtThread(this.arg, this.message, null);
                    break;
                }
                case BUG: {
                    this.message = status.getMessage();
                    this.skipResponseReceived = true;
                    logger.log(Level.SEVERE, status.getMessage(), status.getException());
                    CallbackControlDecorator.this.showErrorInSwtThread(this.arg, this.message, status.getException());
                }
            }
            return IStatusHandler.State.HANDLED;
        }
    }
}

