/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class CallbackComposite
extends FontAwareComposite {
    private static final Logger logger = Logger.getLogger(IStatusHandlerImplementation.class.getName());
    public static final int SIMPLE_LOADING_COMPOSITE = 4096;
    public static final int FIX_LOADING_POSITION = 8192;
    private FontAwareComposite loadingComposite;
    private FontAwareComposite loadedComposite;
    private FontAwareComposite errorComposite;
    private StackLayout stackLayout;
    private final Callback callback;
    private final FormToolkit toolkit;
    private final boolean fixLoadingPosition;
    private final boolean simpleLoadingComposite;

    public CallbackComposite(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.toolkit = toolkit;
        this.fixLoadingPosition = (style | 0x2000) == style;
        this.simpleLoadingComposite = (style | 0x1000) == style;
        this.loadingComposite = this.createLoadingComposite(this, this.toolkit);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 10;
        this.stackLayout.marginWidth = 10;
        this.stackLayout.topControl = this.loadingComposite;
        this.setLayout((Layout)this.stackLayout);
        this.callback = new CallbackExtension();
    }

    public StackLayout getStackLayout() {
        return this.stackLayout;
    }

    public void showLoadedCompositeInSwtThread(final ReturnObject response) {
        if (this.isDisposed()) {
            return;
        }
        if (UI.isCurrentThreadIsUIThread()) {
            this.showLoadedComposite(response);
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CallbackComposite.this.showLoadedComposite(response);
                }
            });
        }
    }

    protected final void showLoadedComposite(ReturnObject response) {
        if (this.isDisposed()) {
            return;
        }
        try {
            if (this.loadedComposite == null) {
                this.loadedComposite = this.createLoadedComposite(this, this.toolkit, response);
            } else {
                this.updateLoadedComposite(response);
            }
            this.stackLayout.topControl = this.loadedComposite;
            this.layout();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            this.showErrorComposite("Erreur", e);
        }
    }

    protected void updateLoadedComposite(ReturnObject response) {
    }

    protected abstract FontAwareComposite createLoadedComposite(Composite var1, FormToolkit var2, ReturnObject var3);

    protected void showErrorCompositeInSwtThread(final String message, final Throwable e) {
        if (this.isDisposed()) {
            return;
        }
        if (UI.isCurrentThreadIsUIThread()) {
            this.showErrorComposite(message, e);
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CallbackComposite.this.showErrorComposite(message, e);
                }
            });
        }
    }

    public void showErrorComposite(String message) {
        this.showErrorComposite(message, null);
    }

    public void showErrorComposite(String message, Throwable e) {
        if (this.isDisposed()) {
            return;
        }
        String message2 = StringUtils.isNotBlank((String)message) ? message : (e != null ? (StringUtils.isNotBlank((String)e.getLocalizedMessage()) ? e.getLocalizedMessage() : MessageUtil.UNEXPECTED_ERROR_MESSAGE) : MessageUtil.UNEXPECTED_ERROR_MESSAGE);
        this.errorComposite = this.createErrorComposite(this, this.toolkit, message2);
        this.stackLayout.topControl = this.errorComposite;
        this.layout();
    }

    private FontAwareComposite createErrorComposite(Composite parent, FormToolkit toolkit, String message) {
        FontAwareComposite main = new FontAwareComposite(parent, 0);
        if (toolkit != null) {
            toolkit.adapt((Composite)main);
        }
        MyLabel lblMessage = new MyLabel(main, message, 0x1000040, toolkit);
        lblMessage.setFont(0, 1);
        lblMessage.setForeground(ResourceGetter.getRedWarningColor());
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        lblMessage.setLayoutData(data);
        main.setLayout((Layout)layout);
        return main;
    }

    public void showLoadingComposite() {
        this.stackLayout.topControl = this.loadingComposite;
        this.layout();
    }

    private FontAwareComposite createLoadingComposite(Composite parent, FormToolkit toolkit) {
        FontAwareComposite main = new FontAwareComposite(parent, toolkit.getBorderStyle());
        if (toolkit != null) {
            toolkit.adapt((Composite)main);
        }
        if (this.simpleLoadingComposite) {
            ProgressBar progressBar = new ProgressBar((Composite)main, 65538);
            FormLayout layout = new FormLayout();
            layout.spacing = 5;
            FormData data = new FormData();
            data.top = new FormAttachment(50);
            data.left = new FormAttachment(50, -50);
            data.width = 100;
            progressBar.setLayoutData((Object)data);
            main.setLayout((Layout)layout);
        } else {
            MyLabel lblLoading = new MyLabel(main, Messages.getString((String)"CHARGEMENT", (String[])new String[0]), 0x1000000, toolkit);
            lblLoading.setFont(2, 1);
            ProgressBar progressBar = new ProgressBar((Composite)main, 65538);
            FormLayout layout = new FormLayout();
            layout.spacing = 5;
            FormData data = new FormData();
            data.top = new FormAttachment(50, this.fixLoadingPosition ? -30 : -60);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            lblLoading.setLayoutData(data);
            data = new FormData();
            data.top = new FormAttachment(lblLoading.getControl());
            data.left = new FormAttachment(50, -50);
            data.width = 100;
            progressBar.setLayoutData((Object)data);
            main.setLayout((Layout)layout);
        }
        return main;
    }

    public Callback getCallback() {
        return this.callback;
    }

    final class CallbackExtension
    extends Callback {
        public CallbackExtension() {
            super((IStatusHandler)new IStatusHandlerImplementation());
            this.showMessage = false;
        }

        public void responseReceived(ReturnObject response) {
            IStatusHandlerImplementation h = (IStatusHandlerImplementation)this.getStatusHandler();
            if (!h.skipResponseReceived) {
                super.responseReceived(response);
                CallbackComposite.this.showLoadedCompositeInSwtThread(response);
            }
        }

        public void exception(Exception e) {
            super.exception(e);
            CallbackComposite.this.showErrorCompositeInSwtThread(e.getMessage(), e);
        }
    }

    final class IStatusHandlerImplementation
    implements IStatusHandler {
        String message;
        boolean skipResponseReceived;

        IStatusHandlerImplementation() {
        }

        public IStatusHandler.State handle(IStatus status) {
            this.message = null;
            this.skipResponseReceived = false;
            if (status == null) {
                return IStatusHandler.State.NOT_HANDLED;
            }
            switch (status.getSeverity()) {
                case OK: 
                case INFO: 
                case WARNING: 
                case NEED_MORE_INFO: {
                    break;
                }
                case ERROR: {
                    this.message = status.getMessage();
                    this.skipResponseReceived = true;
                    CallbackComposite.this.showErrorCompositeInSwtThread(this.message, null);
                    break;
                }
                case BUG: {
                    this.message = status.getMessage();
                    this.skipResponseReceived = true;
                    logger.log(Level.SEVERE, status.getMessage(), status.getException());
                    CallbackComposite.this.showErrorCompositeInSwtThread(this.message, status.getException());
                }
            }
            return IStatusHandler.State.HANDLED;
        }
    }
}

