/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.gson.GsonDelegate;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.IWebSocketFilter;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.WebSocketResponse;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.browser.sonar.IComponent;
import ca.infodata.ofys.ui.browser.sonar.JettySonar;
import ca.infodata.ofys.ui.browser.sonar.SonarDispatcher;
import ca.infodata.ofys.ui.browser.sonar.SonarResult;
import ca.infodata.ofys.ui.browser.sonar.SonarResultCode;
import ca.infodata.ofys.ui.browser.sonar.SonarWSRequest;
import ca.infodata.ofys.ui.browser.sonar.WebSocketChannelForwarder;
import ca.infodata.util1.ProviderR;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class SonarWS
extends WebSocketAdapter
implements IWebSocketChannel {
    private static final Logger logger = Logger.getLogger(SonarWS.class.getName());
    private static Map<String, SonarWS> instances = new ConcurrentHashMap<String, SonarWS>();
    private Session session;
    private RemoteEndpoint remote;
    private String clientUid;

    public static Map<String, SonarWS> getInstances() {
        return instances;
    }

    public static void send(IWebSocketFilter filter, String message) {
        filter.apply(instances.values().stream().filter(c -> c.isOpen())).forEach(c -> c.send(message));
    }

    public static void send(IWebSocketFilter filter, ProviderR<String> msgDelegate) {
        filter.apply(instances.values().stream().filter(c -> c.isOpen())).forEach(c -> c.send(msgDelegate));
    }

    public static IWebSocketChannel get(IWebSocketFilter filter) {
        if (instances.size() == 1) {
            SonarWS c = instances.entrySet().iterator().next().getValue();
            if (c.isOpen()) {
                return c;
            }
            return null;
        }
        return new WebSocketChannelForwarder(instances.values());
    }

    public boolean sendMessage(String message) {
        if (this.session != null && this.session.isOpen() && this.remote != null) {
            this.remote.sendStringByFuture(message);
            return true;
        }
        return false;
    }

    public boolean sendMessage(ProviderR<String> messageDelegate) {
        if (this.session != null && this.session.isOpen() && this.remote != null) {
            this.remote.sendStringByFuture((String)messageDelegate.get());
            return true;
        }
        return false;
    }

    public final String getClientUid() {
        return this.clientUid;
    }

    public final void setClientUid(String clientUid) {
        this.clientUid = clientUid;
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.session = null;
        this.remote = null;
        instances.remove(this.getClientUid());
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        this.session.setIdleTimeout(TimeUnit.HOURS.toMillis(2L));
        this.remote = this.session.getRemote();
        Map parameterMap = this.session.getUpgradeRequest().getParameterMap();
        List list = (List)parameterMap.get("u");
        if (list != null && !list.isEmpty()) {
            String uid = (String)list.get(0);
            this.setClientUid(uid);
            instances.put(uid, this);
        } else {
            System.out.println("u est nul??? ");
        }
        logger.info("on WebSocketConnect " + this.getClientUid());
    }

    public void onWebSocketError(Throwable cause) {
        logger.log(Level.SEVERE, "WebSocket Error", cause);
    }

    public void onWebSocketText(String message) {
        if (this.session != null && this.session.isOpen() && this.remote != null) {
            try {
                SonarWSRequest req = (SonarWSRequest)Application.get().getGsonProcessor().fromJson((CharSequence)message, SonarWSRequest.class);
                req.channel = this;
                SonarDispatcher.ViewConfig config = this.initView(req.url, req);
                if (config == null) {
                    this.sendMessage((ProviderR<String>)new GsonDelegate((Object)this.notFound(req.url)));
                    return;
                }
                this.dispatch(config);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Dashboard message Websocket error :", e);
                ReturnObject ro = ServerResponses.ErrorReturnObject((String)("Une erreur est survenue lors du traitement de la requ\u00eate: \n" + e.getMessage()));
                this.send((ProviderR<String>)new GsonDelegate((Object)new WebSocketResponse("error", (Object)ro)));
                return;
            }
        }
    }

    public boolean ping() {
        String data = "You There?";
        ByteBuffer payload = ByteBuffer.wrap(data.getBytes());
        try {
            this.remote.sendPing(payload);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            this.session = null;
            this.remote = null;
            instances.remove(this.getClientUid());
            return false;
        }
        return true;
    }

    private SonarDispatcher.ViewConfig initView(String target, SonarWSRequest req) {
        SonarDispatcher.ViewConfig config = JettySonar.sonar.getMatch(target);
        if (config == null || target == null) {
            return null;
        }
        config.req.path = target;
        config.req.params = new HashMap<String, String>();
        config.req.wsrequest = req;
        config.req.remote = this.remote;
        config.req.resolved = false;
        config.partial = true;
        config.async = true;
        return config;
    }

    public void dispatch(SonarDispatcher.ViewConfig config) {
        if (config != null) {
            IComponent view = JettySonar.sonar.getComponent(config);
            if (!config.req.resolved.booleanValue()) {
                String res = JettySonar.resolveComponentToString(config, view);
                config.req.resolved = this.sendMessage(res);
            }
        }
    }

    public SonarResult notFound(String url) {
        SonarResult res = new SonarResult();
        res.setCode(new SonarResultCode("404", SonarResultCode.Type.E, "Could not find requested url \"" + url + "\"", null));
        return res;
    }

    public SonarResult serverError(String message) {
        SonarResult res = new SonarResult();
        res.setCode(new SonarResultCode("500", SonarResultCode.Type.E, "Error processing the request \"" + message + "\"", null));
        return res;
    }

    public static void main(String[] args) {
        SonarResult res = new SonarResult();
        res.setCode(new SonarResultCode("404", SonarResultCode.Type.E, "Could not find requested url testurl", null));
        System.out.println(new GsonBuilder().disableHtmlEscaping().create().toJson((Object)res));
    }

    public String getId() {
        return this.clientUid;
    }

    public String getHttpSessionId() {
        return null;
    }

    public void send(WebSocketResponse wsResponse) {
        if (this.session != null && this.session.isOpen() && this.remote != null) {
            this.sendMessage((ProviderR<String>)new GsonDelegate((Object)wsResponse));
        }
    }

    public void send(String msg) {
        this.sendMessage(msg);
    }

    public void send(ProviderR<String> msgDelegate) {
        if (this.session != null && this.session.isOpen() && this.remote != null) {
            this.sendMessage(msgDelegate);
        }
    }

    public boolean isOpen() {
        return this.session != null && this.session.isOpen() && this.remote != null;
    }

    public int hashCode() {
        return this.clientUid.hashCode();
    }

    public Integer getXClientId() {
        return Application.get().getGlobalInstances().getSession().getClient().getId();
    }

    public Integer getXSessionId() {
        return Application.get().getGlobalInstances().getSession() == null ? null : Application.get().getGlobalInstances().getSession().getId();
    }
}

