/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.b2b;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.FacilityAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PreferencesAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.DefaultCallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XSiteB2b;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XSiteB2bLog;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XSiteB2bLogHeader;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.controls.BaseSubEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyTable;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.file.FileUtil;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.user.UserComboForSelection;
import ca.infodata.ofys.ui.site2.SiteMultiEditor;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.MutablePair;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class B2BSiteSubEditor
extends BaseSubEditor {
    private static final Logger logger = Logger.getLogger(B2BSiteSubEditor.class.getName());
    private static final String IDENTIFIANT_UTILISATEUR = Messages.getString((String)"B2BSiteSubEditor.IDENTIFIANT_UTILISATEUR", (String[])new String[0]);
    private static final String IDENTIFIANT_MACHINE = Messages.getString((String)"B2BSiteSubEditor.IDENTIFIANT_MACHINE", (String[])new String[0]);
    private static final String MOT_DE_PASSE_MACHINE = Messages.getString((String)"B2BSiteSubEditor.MOT_DE_PASSE_MACHINE", (String[])new String[0]);
    private static final String NUMERO_DE_GMF = Messages.getString((String)"B2BSiteSubEditor.NUMERO_DE_GMF", (String[])new String[0]);
    private static final String NUMERO_DETABLISSEMENT = Messages.getString((String)"B2BSiteSubEditor.NUMERO_DETABLISSEMENT", (String[])new String[0]);
    private static final String OBTENIR_CLIENTELE = Messages.getString((String)"BaseGmfPreferencesEditor.OBTENIR_CLIENTELE", (String[])new String[0]);
    private static final String AUTO_OBTENIR_CLIENTELE = Messages.getString((String)"BaseGmfPreferencesEditor.AUTO_OBTENIR_CLIENTELE", (String[])new String[0]);
    private static final String UTILISATEUR_RESPONSABLE = Messages.getString((String)"BaseGmfPreferencesEditor.UTILISATEUR_RESPONSABLE", (String[])new String[0]);
    private static final String INSCRIPTION_DE_LA_CLIENTELE = Messages.getString((String)"B2BSiteSubEditor.INSCRIPTION_DE_LA_CLIENTELE", (String[])new String[0]);
    private static final String OUVRIR_AVEC_EDITEUR_SYSTEME = Messages.getString((String)"B2BSiteSubEditor.OUVRIR_AVEC_EDITEUR_SYSTEME", (String[])new String[0]);
    private MyLabel lblUserId;
    private MyMaskedText txtUserId;
    private MyLabel lblMachineId;
    private MyMaskedText txtMachineId;
    private MyLabel lblMachinePassword;
    private MyMaskedText txtMachinePassword;
    private MyLabel lblNoGMF;
    private MyMaskedText txtNoGMF;
    private MyLabel lblNoEtablGMF;
    private MyMaskedText txtNoEtablGMF;
    private MyButton btnAutoObtenirClientele;
    private MyButton btnObtenirClientele;
    private MyButton btnExportLogToFile;
    private MyLabel lblNotifiedUser;
    private UserComboForSelection cmbNotifiedUser;
    private MyTable<MutablePair<XSiteB2bLogHeader, XSiteB2bLog>> tableLog;
    private StyledText txtLog;
    private JobInterne job = null;

    public B2BSiteSubEditor() {
    }

    public B2BSiteSubEditor(SiteMultiEditor parent) {
        super((BaseMultiEditor)parent);
    }

    public void createMyControl(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FontAwareSection sectionInscription = new FontAwareSection(parent, 64, this.toolkit);
        sectionInscription.setText(INSCRIPTION_DE_LA_CLIENTELE);
        this.toolkit.createCompositeSeparator((Composite)sectionInscription);
        Composite clientInscription = this.toolkit.createComposite((Composite)sectionInscription);
        sectionInscription.setClient((Control)clientInscription);
        this.lblUserId = new MyLabel(clientInscription, IDENTIFIANT_UTILISATEUR, 0, this.toolkit);
        this.txtUserId = new MyMaskedText(clientInscription, this.toolkit);
        this.txtUserId.setMask(new MyMask('!', 10));
        this.lblMachineId = new MyLabel(clientInscription, IDENTIFIANT_MACHINE, 0, this.toolkit);
        this.txtMachineId = new MyMaskedText(clientInscription, this.toolkit);
        this.txtMachineId.setMask(new MyMask('!', 10));
        this.lblMachinePassword = new MyLabel(clientInscription, MOT_DE_PASSE_MACHINE, 0, this.toolkit);
        this.txtMachinePassword = new MyMaskedText(clientInscription, 0x400000, this.toolkit);
        this.txtMachinePassword.setMask(new MyMask('!', 50));
        this.lblNoGMF = new MyLabel(clientInscription, NUMERO_DE_GMF, 0, this.toolkit);
        this.txtNoGMF = new MyMaskedText(clientInscription, this.toolkit);
        this.txtNoGMF.setMask(new MyMask('#', 5));
        this.lblNoEtablGMF = new MyLabel(clientInscription, NUMERO_DETABLISSEMENT, 0, this.toolkit);
        this.txtNoEtablGMF = new MyMaskedText(clientInscription, this.toolkit);
        this.txtNoEtablGMF.setMask(new MyMask('#', 5));
        FontAwareSection sectionB2bSync = new FontAwareSection(parent, 64, this.toolkit);
        sectionB2bSync.setText("Synchronisation automatique de la client\u00e8le");
        this.toolkit.createCompositeSeparator((Composite)sectionB2bSync);
        Composite clientB2bSync = this.toolkit.createComposite((Composite)sectionB2bSync);
        sectionB2bSync.setClient((Control)clientB2bSync);
        this.btnAutoObtenirClientele = new MyButton(clientB2bSync, AUTO_OBTENIR_CLIENTELE, 96, this.toolkit);
        this.btnObtenirClientele = new MyButton(clientB2bSync, String.valueOf(OBTENIR_CLIENTELE) + " (debug ou infodata)", 8, this.toolkit);
        this.btnObtenirClientele.setVisible(Application.get().getGlobalInstances().inDebugMode());
        this.btnExportLogToFile = new MyButton(clientB2bSync, OUVRIR_AVEC_EDITEUR_SYSTEME, 8, this.toolkit);
        this.btnExportLogToFile.setEnabled(false);
        this.lblNotifiedUser = new MyLabel(clientB2bSync, UTILISATEUR_RESPONSABLE, 0, this.toolkit);
        this.cmbNotifiedUser = new UserComboForSelection(clientB2bSync, 8);
        this.cmbNotifiedUser.fill(false);
        MyLabel lblLog = new MyLabel(clientB2bSync, "Journaux de synchronisation pour ce site", 16384, this.toolkit);
        this.txtLog = new StyledText(clientB2bSync, 2816);
        this.txtLog.setFont(ResourceGetter.getFontNormal((int)3));
        this.txtLog.setEditable(false);
        this.txtLog.setMargins(3, 3, 0, 0);
        this.tableLog = new MyTable(clientB2bSync, 68100);
        this.tableLog.setColumns(new String[]{"Date de la synchronisation", "Date de la lecture du journal", "Journal lu par", "Statut"});
        this.tableLog.setHeaderVisible(true);
        this.tableLog.setLinesVisible(true);
        this.tableLog.setLabelProvider((ProviderAR)new ProviderAR<MutablePair<XSiteB2bLogHeader, XSiteB2bLog>, String[]>(){

            public String[] get(MutablePair<XSiteB2bLogHeader, XSiteB2bLog> e) {
                XSiteB2bLogHeader header = (XSiteB2bLogHeader)e.getFirst();
                String date = DateUtil.nonThreadSafeFormat((Long)header.getCreateDatetime(), (String)"yyyy-MM-dd hh:mm");
                String readDate = DateUtil.nonThreadSafeFormat((Long)header.getReadDatetime(), (String)"yyyy-MM-dd hh:mm");
                XBaseUser user = PersonUiPlugin.getDefault().getUser(header.getReadIdUser());
                String name = user == null ? "" : user.getPersonNameOrTextOrEmpty();
                String status = header.getStatus() == null ? "" : new JoinList(", ", (Collection)header.getStatus()).toString();
                return new String[]{date, readDate, name, status};
            }
        });
        UI.autoAdjustColumnWidthToContent((Table)this.tableLog.getControl());
        this.txtUserId.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                B2BSiteSubEditor.this.getSite2().getB2bInformations().setUserId(B2BSiteSubEditor.this.txtUserId.getText());
            }
        });
        this.txtMachineId.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                B2BSiteSubEditor.this.getSite2().getB2bInformations().setMachineId(B2BSiteSubEditor.this.txtMachineId.getText());
            }
        });
        this.txtMachinePassword.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                B2BSiteSubEditor.this.getSite2().getB2bInformations().setMachinePassword(B2BSiteSubEditor.this.txtMachinePassword.getText());
            }
        });
        this.txtNoGMF.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                B2BSiteSubEditor.this.getSite2().getB2bInformations().setNoGmf(B2BSiteSubEditor.this.txtNoGMF.getText());
            }
        });
        this.txtNoEtablGMF.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                B2BSiteSubEditor.this.getSite2().getB2bInformations().setNoEtabGmf(B2BSiteSubEditor.this.txtNoEtablGMF.getText());
            }
        });
        this.btnObtenirClientele.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                B2BSiteSubEditor.this.obtenirClientele();
            }
        });
        this.btnAutoObtenirClientele.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor(), 13){

            public void edited(Event e) {
                B2BSiteSubEditor.this.getSite2().getB2bInformations().setAutoSync(Boolean.valueOf(B2BSiteSubEditor.this.btnAutoObtenirClientele.getSelection()));
            }
        });
        this.btnExportLogToFile.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor(), 13){

            public void edited(Event e) {
                if (B2BSiteSubEditor.this.tableLog.getSelectionCount() == 1) {
                    try {
                        List selection = B2BSiteSubEditor.this.tableLog.getSelection();
                        MutablePair log = (MutablePair)selection.get(0);
                        String filename = "b2bsync_" + LocalDate.fromTimeInMillisUTC((Long)((XSiteB2bLogHeader)log.first).getCreateDatetime()).formatHyphen() + "_log.txt";
                        if (LibPlugin.ON_WIN) {
                            String text = ((XSiteB2bLog)log.second).getData().replaceAll("\n", "\r\n");
                            File file = FileUtil.saveToTemp((String)filename, (String)text);
                            Runtime.getRuntime().exec("explorer " + file.getName(), null, file.getParentFile());
                        } else {
                            String text = ((XSiteB2bLog)log.second).getData();
                            File file = FileUtil.saveToTemp((String)filename, (String)text);
                            Runtime.getRuntime().exec("open " + file.getName(), null, file.getParentFile());
                        }
                    }
                    catch (Exception e1) {
                        MessageUtil.show((Shell)B2BSiteSubEditor.this.getSite().getShell(), (Exception)e1);
                    }
                }
            }
        });
        this.cmbNotifiedUser.getControl().addListener(13, (Listener)new EditorModifyListener((IBaseEditor2)this.getParentEditor(), 13){

            public void edited(Event e) {
                XBaseUser u = B2BSiteSubEditor.this.cmbNotifiedUser.getSelection();
                B2BSiteSubEditor.this.getSite2().getB2bInformations().setNotifiedUserId(u == null ? null : u.getId());
            }
        });
        this.tableLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                B2BSiteSubEditor.this.btnExportLogToFile.setEnabled(B2BSiteSubEditor.this.tableLog.getSelectionCount() == 1);
                B2BSiteSubEditor.this.readSiteB2bLog((MutablePair<XSiteB2bLogHeader, XSiteB2bLog>)((MutablePair)B2BSiteSubEditor.this.tableLog.getFirstSelectedItem()));
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        sectionInscription.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)sectionInscription, 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        sectionB2bSync.setLayoutData((Object)data);
        FormLayout layout2 = new FormLayout();
        layout2.spacing = 5;
        clientInscription.setLayout((Layout)layout2);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblUserId.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblUserId.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(18);
        this.txtUserId.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(20);
        this.lblMachineId.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblMachineId.getControl());
        data.left = new FormAttachment(20);
        data.right = new FormAttachment(38);
        this.txtMachineId.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(40);
        this.lblMachinePassword.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblMachinePassword.getControl());
        data.left = new FormAttachment(40);
        data.right = new FormAttachment(58);
        this.txtMachinePassword.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtMachinePassword.getControl());
        data.left = new FormAttachment(0);
        this.lblNoGMF.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNoGMF.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(18);
        this.txtNoGMF.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtMachinePassword.getControl());
        data.left = new FormAttachment(20);
        data.right = new FormAttachment(38);
        this.lblNoEtablGMF.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNoEtablGMF.getControl());
        data.left = new FormAttachment(20);
        data.right = new FormAttachment(38);
        this.txtNoEtablGMF.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtNoEtablGMF.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        clientB2bSync.setLayoutData((Object)data);
        FormLayout layout3 = new FormLayout();
        layout3.spacing = 5;
        clientB2bSync.setLayout((Layout)layout3);
        data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100);
        this.btnAutoObtenirClientele.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnAutoObtenirClientele.getControl(), 10);
        data.left = new FormAttachment(0);
        this.lblNotifiedUser.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNotifiedUser.getControl(), 0);
        data.left = new FormAttachment(0);
        this.cmbNotifiedUser.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblLog.getControl());
        data.left = new FormAttachment((Control)this.tableLog.getControl());
        this.btnExportLogToFile.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnExportLogToFile.getControl());
        data.left = new FormAttachment((Control)this.tableLog.getControl());
        this.btnObtenirClientele.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbNotifiedUser.getControl(), 10);
        data.left = new FormAttachment(0);
        lblLog.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblLog.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(75);
        data.height = 100;
        this.tableLog.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.tableLog.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.txtLog.setLayoutData((Object)data);
        this.toolkit.adapt(parent);
    }

    protected void obtenirClientele() {
        if (this.canCall()) {
            try {
                PreferencesAccessorClient.getInstance().executeTask("synchronizeB2B", null, Application.get().getGlobalInstances().getSession(), (ICallback)new DefaultCallback());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to call ?", e);
                MessageUtil.unexpectedExceptionMsg((Shell)this.getSite().getShell(), (Exception)e);
            }
            if (this.job != null) {
                this.job.cancel();
                this.job.setActive(false);
                this.job.done(Status.OK_STATUS);
            }
        }
    }

    private boolean canCall() {
        if (this.getSite2() == null) {
            MessageUtil.warningMsg((Shell)this.getSite().getShell(), (String)"aucun site pour cette operation");
            return false;
        }
        if (this.getSite2().getId() == null) {
            MessageUtil.warningMsg((Shell)this.getSite().getShell(), (String)"Veuillez sauvegarder le site avant deffectuer cette operation");
            return false;
        }
        if (this.getParentEditor().isDirty()) {
            MessageUtil.warningMsg((Shell)this.getSite().getShell(), (String)"Veuillez sauvegarder lediteur avant deffectuer cette operation");
            return false;
        }
        if (this.job != null && this.job.isActive()) {
            MessageUtil.warningMsg((Shell)this.getSite().getShell(), (String)"Une appel a la ramq est deja en cours");
            return false;
        }
        this.job = new JobInterne(this, "B2B RAMQ..."){

            @Override
            protected IStatus run(IProgressMonitor monitor) {
                while (this.active && !this.cancel) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return Job.ASYNC_FINISH;
            }

            @Override
            protected int jobToDo() {
                return 0;
            }
        };
        this.job.schedule();
        return true;
    }

    protected void showDataObjectOverride() {
        XSite site2 = this.getSite2();
        if (site2 == null || site2.getB2bInformations() == null) {
            this.txtUserId.setText(null);
            this.txtMachineId.setText(null);
            this.txtMachinePassword.setText(null);
            this.txtNoGMF.setText(null);
            this.txtNoEtablGMF.setText(null);
            this.btnAutoObtenirClientele.setSelection(false);
            this.cmbNotifiedUser.getControl().clearSelection();
            this.tableLog.setItems(null);
            this.txtLog.setText("");
        } else {
            XSiteB2b info = site2.getB2bInformations();
            this.txtUserId.setText(info.getUserId());
            this.txtMachineId.setText(info.getMachineId());
            this.txtMachinePassword.setText(info.getMachinePassword());
            this.txtNoGMF.setText(info.getNoGmf());
            this.txtNoEtablGMF.setText(info.getNoEtabGmf());
            this.btnAutoObtenirClientele.setSelection(Boolean.TRUE.equals(info.getAutoSync()));
            this.cmbNotifiedUser.select(this.cmbNotifiedUser.getUserById(info.getNotifiedUserId()));
            this.tableLog.setItems(null);
            this.txtLog.setText("");
        }
    }

    public void load() {
        XSite site2 = this.getSite2();
        if (site2 == null || site2.getId() == null) {
            this.tableLog.setItems(null);
            return;
        }
        Callback callback = new Callback((IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(final ReturnObject response) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!B2BSiteSubEditor.this.tableLog.isDisposed()) {
                            if (response != null && response.getObj() instanceof List) {
                                List list = (List)response.getObj();
                                B2BSiteSubEditor.this.tableLog.removeAll();
                                for (XSiteB2bLogHeader log : list) {
                                    B2BSiteSubEditor.this.tableLog.add((Object)MutablePair.newPair((Object)log, null));
                                }
                            } else {
                                B2BSiteSubEditor.this.tableLog.setItems(null);
                            }
                            UI.autoAdjustColumnWidthToContent((Table)B2BSiteSubEditor.this.tableLog.getControl());
                        }
                    }
                });
            }
        };
        try {
            FacilityAccessorClient.getInstance().findSiteB2BLogHeaders((ICallback)callback, site2.getId().intValue(), Integer.valueOf(20), Application.get().getGlobalInstances().getSession());
        }
        catch (CannotConnectToServerException e) {
            logger.log(Level.INFO, "Failed to get log headers for site " + site2.getId(), e);
        }
    }

    protected void setLogText(String text) {
        text = text == null ? "" : text;
        this.txtLog.setText(text);
    }

    protected void readSiteB2bLog(final MutablePair<XSiteB2bLogHeader, XSiteB2bLog> item) {
        if (item == null) {
            this.setLogText(null);
            return;
        }
        if (item.getSecond() != null) {
            this.setLogText(((XSiteB2bLog)item.getSecond()).getData());
            return;
        }
        Callback callback = new Callback((IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(final ReturnObject response) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!B2BSiteSubEditor.this.txtLog.isDisposed()) {
                            if (response != null && response.getObj() instanceof XSiteB2bLog) {
                                XSiteB2bLog log = (XSiteB2bLog)response.getObj();
                                item.second = log;
                                B2BSiteSubEditor.this.setLogText(log.getData());
                            } else {
                                B2BSiteSubEditor.this.setLogText(null);
                            }
                        }
                    }
                });
            }
        };
        Integer idLog = ((XSiteB2bLogHeader)item.getFirst()).getId();
        try {
            FacilityAccessorClient.getInstance().readB2BSyncLog((ICallback)callback, idLog.intValue(), Application.get().getGlobalInstances().getSession());
        }
        catch (CannotConnectToServerException e) {
            logger.log(Level.INFO, "Failed to read id log " + idLog, e);
        }
    }

    private XSite getSite2() {
        return (XSite)((EditorInput)this.getEditorInput()).getCompleteDataObject();
    }

    protected abstract class JobInterne
    extends Job {
        protected boolean cancel;
        protected boolean active;

        protected JobInterne(String jobTitle) {
            super(jobTitle);
            this.cancel = false;
            this.active = true;
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                this.cancelJob();
                return Status.CANCEL_STATUS;
            }
            this.jobToDo();
            monitor.done();
            return Status.OK_STATUS;
        }

        protected abstract int jobToDo();

        public void cancelJob() {
            this.setCancel(true);
        }

        public final boolean isCancel() {
            return this.cancel;
        }

        public final void setCancel(boolean cancel) {
            this.cancel = cancel;
        }

        public final boolean isActive() {
            return this.active;
        }

        public final void setActive(boolean active) {
            this.active = active;
        }
    }
}

