/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.test;

import apple.finder.search.ui.UI;
import ca.infodata.ofys.ui.appointment.test.AppointmentRobotController;
import ca.infodata.ofys.ui.controls.SimpleNumberText;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AppointmentRobotDialog {
    private AppointmentRobotController controller;
    private Shell shell;
    private Text txtLog;
    private volatile boolean doit;
    private SimpleNumberText txtPeriod;

    public AppointmentRobotDialog(Shell parent, AppointmentRobotController controller) {
        this.controller = controller;
        this.shell = new Shell(parent, 67680);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        this.shell.setLayout((Layout)layout);
        Button btnRun = new Button((Composite)this.shell, 8);
        btnRun.setText("Run");
        btnRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentRobotDialog.this.doit();
            }
        });
        Button btnStop = new Button((Composite)this.shell, 8);
        btnStop.setText("Stop");
        btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentRobotDialog.this.doit = false;
            }
        });
        this.txtPeriod = new SimpleNumberText((Composite)this.shell, 2048);
        this.txtPeriod.setMessage("milliseconds");
        this.txtPeriod.setNumber(Integer.valueOf(250));
        this.txtLog = new Text((Composite)this.shell, 2818);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AppointmentRobotDialog.this.doit = false;
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        btnRun.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)btnRun);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        btnStop.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)btnStop);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtPeriod.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtPeriod.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.txtLog.setLayoutData((Object)data);
        this.shell.setSize(400, 400);
        UI.centerComposite((Composite)this.shell, (Composite)parent);
        this.shell.open();
    }

    protected void doit() {
        this.doit = true;
        final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        long initialDelay = 500L;
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (AppointmentRobotDialog.this.doit) {
                    final String log = AppointmentRobotDialog.this.controller.run();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AppointmentRobotDialog.this.txtLog.append("\r\n" + log);
                        }
                    });
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AppointmentRobotDialog.this.txtLog.append("\r\nShutting robot down...");
                        }
                    });
                    executorService.shutdown();
                }
            }
        }, initialDelay, this.txtPeriod.getNumber().intValue(), TimeUnit.MILLISECONDS);
    }
}

