/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.search;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.appointment.search.AbstractCriteriaControl;
import ca.infodata.ofys.ui.controls.TimeText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.util1.date.DateUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HourCriteriaControl
extends AbstractCriteriaControl {
    private MyButton btnAm;
    private MyButton btnPm;
    private MyButton btnEvening;
    private TimeText txtBefore;
    private TimeText txtAfter;
    private boolean doit = true;

    public HourCriteriaControl(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, Messages.getString((String)"HEURES", (String[])new String[0]), toolkit);
    }

    public void propertyChanged(int propertyId) {
        if (propertyId == 3 || propertyId == 11) {
            this.refreshPopup();
        }
    }

    @Override
    protected void refreshPopup() {
        if (this.txtAfter == null || this.txtAfter.isDisposed()) {
            return;
        }
        if (this.getController() != null) {
            this.doit = false;
            this.txtAfter.setTimeKeepSelection(this.getController().getAfterHour());
            this.txtBefore.setTimeKeepSelection(this.getController().getBeforeHour());
            this.doit = true;
        }
    }

    @Override
    protected Shell createPopupControlOverride(Shell parent, FormToolkit toolkit) {
        Shell shell = new Shell(parent, 2048);
        toolkit.adapt((Composite)shell);
        this.btnAm = new MyButton((Composite)shell, "am", 8, toolkit);
        this.btnPm = new MyButton((Composite)shell, "pm", 8, toolkit);
        this.btnEvening = new MyButton((Composite)shell, "soir", 8, toolkit);
        MyLabel lblBefore = new MyLabel((Composite)shell, Messages.getString((String)"AVANT", (String[])new String[0]), 0, toolkit);
        this.txtBefore = new TimeText((Composite)shell, 0, toolkit);
        MyLabel lblAfter = new MyLabel((Composite)shell, Messages.getString((String)"APRES", (String[])new String[0]), 0, toolkit);
        this.txtAfter = new TimeText((Composite)shell, 0, toolkit);
        this.btnAm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HourCriteriaControl.this.getController() != null) {
                    HourCriteriaControl.this.getController().setAfterHour(null);
                    HourCriteriaControl.this.getController().setBeforeHour(720);
                }
            }
        });
        this.btnPm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HourCriteriaControl.this.getController() != null) {
                    HourCriteriaControl.this.getController().setAfterHour(720);
                    HourCriteriaControl.this.getController().setBeforeHour(1020);
                }
            }
        });
        this.btnEvening.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HourCriteriaControl.this.getController() != null) {
                    HourCriteriaControl.this.getController().setAfterHour(1020);
                    HourCriteriaControl.this.getController().setBeforeHour(null);
                }
            }
        });
        this.txtBefore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!HourCriteriaControl.this.doit) {
                    return;
                }
                Integer number = HourCriteriaControl.this.txtBefore.getTime();
                if (HourCriteriaControl.this.getController() != null) {
                    HourCriteriaControl.this.getController().setBeforeHour(number);
                }
            }
        });
        this.txtAfter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!HourCriteriaControl.this.doit) {
                    return;
                }
                Integer number = HourCriteriaControl.this.txtAfter.getTime();
                if (HourCriteriaControl.this.getController() != null) {
                    HourCriteriaControl.this.getController().setAfterHour(number);
                }
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        shell.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(33);
        this.btnAm.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnAm.getControl());
        data.right = new FormAttachment(66);
        this.btnPm.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnPm.getControl());
        data.right = new FormAttachment(99);
        this.btnEvening.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnAm.getControl(), 10);
        data.left = new FormAttachment(0);
        lblBefore.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnAm.getControl(), 10);
        data.left = new FormAttachment(lblBefore.getControl());
        this.txtBefore.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtBefore.getControl());
        data.left = new FormAttachment(0);
        lblAfter.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtBefore.getControl());
        data.left = new FormAttachment(lblAfter.getControl());
        this.txtAfter.setLayoutData((Object)data);
        shell.pack();
        return shell;
    }

    @Override
    protected void reset() {
        this.getController().setAfterHour(null);
        this.getController().setBeforeHour(null);
        this.refreshPopup();
    }

    @Override
    protected String computeLabel() {
        Integer beforeHour;
        if (this.getController() == null) {
            return null;
        }
        String text = "";
        Integer afterHour = this.getController().getAfterHour();
        if (afterHour != null) {
            text = String.valueOf(Messages.getString((String)"APRES", (String[])new String[0]).toLowerCase()) + " " + DateUtil.convertTimeToString((Integer)afterHour, (Character)Character.valueOf('h'));
        }
        if ((beforeHour = this.getController().getBeforeHour()) != null) {
            text = String.valueOf(text) + " " + Messages.getString((String)"AVANT", (String[])new String[0]).toLowerCase() + " " + DateUtil.convertTimeToString((Integer)beforeHour, (Character)Character.valueOf('h'));
        }
        return text;
    }
}

