/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.recall;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPreferredTime;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPriority;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;

public class XPatientRecallFormatter {
    public static String formatContextMenu(XPatientRecall recall) {
        String reason;
        XPreferredTime preferredTime;
        LocalDate dateRecall;
        StringBuilder b = new StringBuilder(100);
        String patient = recall.getPatient().getNameBirthdateSex();
        b.append(patient);
        XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(recall.getProfessionnal());
        if (prof != null) {
            b.append(" ");
            b.append(Messages.getString((String)"AVEC", (String[])new String[0]));
            b.append(" ").append(prof.getName());
        }
        if ((dateRecall = recall.getDateRecall()) != null) {
            b.append(" ");
            b.append(Messages.getString((String)"POUR", (String[])new String[0]));
            b.append(Messages.getString((String)"_LE_", (String[])new String[0]));
            b.append(" ");
            b.append(LocalDateFormat.format((LocalDate)dateRecall, (String)FormatDateProvider.getFormatDate().toString()));
        }
        if ((preferredTime = recall.getPreferredTime()) != null && preferredTime != XPreferredTime.NONE) {
            b.append(" ");
            b.append(Messages.getString((String)"_EN_", (String[])new String[0]));
            b.append(preferredTime.toString());
        }
        if (StringUtils.isNotBlank((String)(reason = recall.getReason()))) {
            b.append(" : ");
            b.append(reason.trim());
        }
        return b.toString();
    }

    public static String format(XPatientRecall recall) {
        String text = XPatientRecallFormatter.formatWithoutPatientName(recall);
        IPatient patient = recall.getPatient();
        text = patient == null ? " ? " + text : String.valueOf(patient.getName()) + " " + text;
        return text;
    }

    public static String formatWithoutPatientName(XPatientRecall recall) {
        XStatus status;
        XPriority priority;
        XBaseProfessionnal professionnal = PersonUiPlugin.getDefault().getBaseProfessionnal(recall.getProfessionnal());
        LocalDate dateRecall = recall.getDateRecall();
        String reason = recall.getReason();
        StringBuilder b = new StringBuilder(100);
        b.append(Messages.getString((String)"AVEC", (String[])new String[0]));
        if (professionnal == null) {
            b.append(" ?");
        } else {
            b.append(" ");
            b.append(professionnal.getName());
        }
        LocalDate dateCreated = recall.getDateCreated();
        b.append(" ");
        b.append(Messages.getString((String)"DEMANDE_LE", (String[])new String[0]));
        b.append(" ");
        b.append(LocalDateFormat.format((LocalDate)dateCreated, (String)FormatDateProvider.getFormatDate().toString()));
        b.append(", ");
        b.append(Messages.getString((String)"POUR", (String[])new String[0]));
        b.append(Messages.getString((String)"_LE_", (String[])new String[0]));
        b.append(" ");
        if (dateRecall == null) {
            b.append("?");
        } else {
            b.append(LocalDateFormat.format((LocalDate)dateRecall, (String)FormatDateProvider.getFormatDate().toString()));
        }
        XPreferredTime preferredTime = recall.getPreferredTime();
        if (preferredTime != null && preferredTime != XPreferredTime.NONE) {
            b.append(Messages.getString((String)"_EN_", (String[])new String[0]));
            b.append(preferredTime.toString());
        }
        if (reason != null) {
            b.append(" : ");
            b.append(reason);
        }
        if ((priority = recall.getPriority()) != null && priority != XPriority.NORMAL) {
            b.append(", ");
            b.append(priority.toString());
        }
        if ((status = recall.getStatus()) != null && status != XStatus.NORMAL) {
            b.append(", ");
            b.append(status.toString());
        }
        return b.toString();
    }
}

