/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.multiprof;

import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.ui.appointment.control.AppointmentFormatterSettingsBased;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditor;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditorInput;
import ca.infodata.ofys.ui.appointment.editor.AppointmentWindow;
import ca.infodata.ofys.ui.appointment.editor.appointment.AppointmentController;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerAdapter;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.appointment.editor.multiprof.AppointmentDateControl2;
import ca.infodata.ofys.ui.appointment.editor.multiprof.AppointmentVisualStructureContentProvider;
import ca.infodata.ofys.ui.appointment.editor.multiprof.AppointmentVisualStructureScaleManagerMultiProf;
import ca.infodata.ofys.ui.appointment.editor.multiprof.AppointmentVisualStructureTimeManagerMultiProf;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.FontAwareHyperlink;
import ca.infodata.ofys.ui.controls.IUserInteractionHelper;
import ca.infodata.ofys.ui.controls.UserInteractionHelper;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.date.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ProfControl
extends Composite {
    private static final Logger logger = Logger.getLogger(ProfControl.class.getName());
    private Hyperlink lblProfName;
    private AppointmentDateControl2 dateControl;
    private AppointmentMainController controller;
    private AppointmentControllerListenerImplementation controllerListener;
    private FormToolkit toolkit;
    private AppointmentWindow appointmentWindow;
    private AppointmentController appointmentController;
    private AppointmentVisualStructureContentProvider contentProvider;
    private AppointmentVisualStructure visualStructure;
    private XBaseProfessionnal professionnal;
    private LocalDate date;

    public ProfControl(Composite parent, int style, FormToolkit toolkit, LocalDate date, XBaseProfessionnal prof, final AppointmentVisualStructureScaleManagerMultiProf scaleManager, final AppointmentVisualStructureTimeManagerMultiProf timeManager) {
        super(parent, style);
        this.toolkit = toolkit;
        this.date = date;
        this.professionnal = prof;
        this.lblProfName = new FontAwareHyperlink((Composite)this, "", 16384, this.toolkit);
        this.lblProfName.setUnderlined(false);
        this.lblProfName.setFont(ResourceGetter.getFontBold());
        this.lblProfName.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AppointmentMainEditorInput input = null;
                try {
                    Log.logOperation((String)"OpenAppointmentAction.openAppointmentEditor", (Object[])new Object[]{ProfControl.this.professionnal});
                    input = new AppointmentMainEditorInput("AppointmentMultiEditor");
                    input.setProfessional(ProfControl.this.professionnal);
                    input.setMode(IAppointmentMode.Mode.APPOINTMENT);
                    input.setDate(ProfControl.this.date);
                    BaseEditor.openEditor((IEditorInput)input, (String)AppointmentMainEditor.class.getName());
                }
                catch (Exception e1) {
                    logger.log(Level.SEVERE, "Failed to open appointment editor with input " + input, e1);
                }
            }
        });
        this.dateControl = new AppointmentDateControl2(this, 0, toolkit){

            @Override
            protected void openAppointmentWindow() {
                ProfControl.this.openAppointmentWindow();
            }

            @Override
            public void zoomOverride(int count) {
                ProfControl.this.zoomOverride(count);
            }
        };
        this.dateControl.getScroll().setVisible(false);
        this.dateControl.getDrawer().setAppointmentLabelProvider(new AppointmentFormatterSettingsBased("appointment/multi_prof_appointment_format_pref"){

            @Override
            public void changed(String preferenceId, String oldValue, String newValue) {
                super.changed(preferenceId, oldValue, newValue);
                Canvas c = ProfControl.this.dateControl.getCanvas();
                if (c != null && !c.isDisposed() && !c.getDisplay().isDisposed()) {
                    c.getDisplay().asyncExec(() -> ProfControl.this.redraw());
                }
            }

            @Override
            public boolean canSeeAndModifyAppointment(IAppointment appointment) {
                return ProfControl.this.visualStructure.canSeeAndModifyAppointment((IVisualAppointment)appointment);
            }
        });
        this.dateControl.getDrawer().setDrawTimeText(false);
        this.dateControl.getDrawer().setDrawIcons(false);
        this.dateControl.getDrawer().setMargin(14);
        this.controllerListener = new AppointmentControllerListenerImplementation();
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 4;
        layout.marginWidth = 2;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblProfName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.lblProfName);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.dateControl.setLayoutData(data);
        toolkit.adapt((Composite)this);
        this.controller = new AppointmentMainController("prof" + prof.getId(), date, prof.getId(), (IUserInteractionHelper)new UserInteractionHelper(this.getShell()));
        this.controller.setMoveAppointmentDateWeek(false);
        this.controller.addListener(this.controllerListener);
        this.lblProfName.setText(prof.getName());
        this.contentProvider = new AppointmentVisualStructureContentProvider(this.controller, date);
        this.visualStructure = new AppointmentVisualStructure(this.contentProvider, prof.getId());
        this.visualStructure.setMode(IAppointmentMode.Mode.APPOINTMENT);
        this.visualStructure.setScaleManager(scaleManager);
        this.visualStructure.setTimeManager(timeManager);
        scaleManager.add(this.visualStructure);
        timeManager.add(this.visualStructure);
        scaleManager.clearCache();
        timeManager.clearCache();
        scaleManager.resetAllVs();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                scaleManager.remove(ProfControl.this.visualStructure);
                timeManager.remove(ProfControl.this.visualStructure);
                ProfControl.this.controller.dispose();
            }
        });
        this.dateControl.setController(this.controller);
        this.dateControl.setVisualStructure(this.visualStructure);
        this.dateControl.refresh();
        this.dateControl.redraw();
    }

    protected void zoomOverride(int count) {
    }

    protected final void zoom(int count) {
        this.dateControl.zoom(count);
    }

    public void setDate(LocalDate date) {
        this.date = date;
        this.controller.setCurrentCalendarDates(date);
        this.contentProvider.setDate(date);
        this.dateControl.refresh();
    }

    protected AppointmentMainController getController() {
        return this.controller;
    }

    void openAppointmentWindow() {
        AppointmentWindow window = this.getAppointmentWindow();
        window.setLocation(this.getAppointmentWindowLocation());
        if (this.appointmentController != null) {
            this.appointmentController.dispose();
        }
        this.appointmentController = new AppointmentController(this.controller);
        window.setAppointmentEditorInput(this.appointmentController);
        window.mainLayout();
        window.getWindow().layout(true, true);
        window.setLocation(window.getAppointmentWindowLocation());
        window.open();
        UI.waitForWindowToClose((Shell)window.getWindow());
        this.appointmentController.dispose();
        this.appointmentController = null;
    }

    private Point getAppointmentWindowLocation() {
        Point location = this.getShell().getLocation();
        Point size = this.getShell().getSize();
        Point mySize = this.appointmentWindow.getWindow().getSize();
        int x = location.x + size.x / 2 - mySize.x / 2;
        int y = location.y + size.y / 2 - mySize.y / 2;
        return new Point(x, y);
    }

    private AppointmentWindow getAppointmentWindow() {
        if (this.appointmentWindow == null) {
            this.appointmentWindow = new AppointmentWindow(this.getShell(), this.toolkit);
        }
        return this.appointmentWindow;
    }

    public AppointmentDateControl2 getDateControl() {
        return this.dateControl;
    }

    private final class AppointmentControllerListenerImplementation
    extends AppointmentControllerAdapter {
        private AppointmentControllerListenerImplementation() {
        }

        @Override
        public void appointmentDatesChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".appointmentDatesChanged()");
                    if (!ProfControl.this.isDisposed()) {
                        ProfControl.this.dateControl.refresh();
                    }
                }
            });
        }

        @Override
        public void appointmentsChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".appointmentsChanged()");
                    if (!ProfControl.this.isDisposed()) {
                        ProfControl.this.dateControl.refresh();
                    }
                }
            });
        }
    }
}

