/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.model2;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.callback.JustLogStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentCompleteDataContainer;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.appointment.editor.model2.Data;
import ca.infodata.ofys.ui.appointment.editor.model2.IServer;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.IdentityArrayList;
import ca.infodata.util1.Pair;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;

class Cache {
    private static final Logger logger = Logger.getLogger(Cache.class.getName());
    private final Map<Integer, ConcurrentSkipListSet<CacheItem>> baseAppointmentDateReferenceCache;
    private final Map<Integer, ConcurrentSkipListSet<CacheItem>> appointmentDateReferenceCache;
    private final Object lock = new Object();
    private Data data;
    private IServer server;

    static List<CacheItem> generateList(LocalDate start, LocalDate end) {
        ArrayList<CacheItem> items = new ArrayList<CacheItem>();
        int i = start.dayFrom1970;
        while (i <= end.dayFrom1970) {
            items.add(new CacheItem(LocalDate.fromDayFrom1970((int)i)));
            ++i;
        }
        return items;
    }

    public Cache(IServer server, Data data) {
        this.server = server;
        this.data = data;
        this.baseAppointmentDateReferenceCache = new ConcurrentHashMap<Integer, ConcurrentSkipListSet<CacheItem>>();
        this.appointmentDateReferenceCache = new ConcurrentHashMap<Integer, ConcurrentSkipListSet<CacheItem>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentSkipListSet<CacheItem> get(Map<Integer, ConcurrentSkipListSet<CacheItem>> map, Integer prof) {
        Object object = this.lock;
        synchronized (object) {
            ConcurrentSkipListSet<CacheItem> value = map.get(prof);
            if (value == null) {
                value = new ConcurrentSkipListSet();
                map.put(prof, value);
            }
            return value;
        }
    }

    void initBlock(LocalDate start, LocalDate end, Collection<Integer> professionals) {
        List<CacheItem> items = Cache.generateList(start, end);
        for (Integer prof : professionals) {
            this.get(this.appointmentDateReferenceCache, prof).addAll(items);
            this.get(this.baseAppointmentDateReferenceCache, prof).addAll(items);
        }
    }

    private boolean isDateInCache(LocalDate date, Integer professional, Map<Integer, ConcurrentSkipListSet<CacheItem>> targetCache) {
        return Cache.contains(this.get(targetCache, professional), date);
    }

    boolean isBaseAppointmentDateInCache(LocalDate date, Integer professional) {
        return Cache.contains(this.get(this.baseAppointmentDateReferenceCache, professional), date);
    }

    boolean isAppointmentDateInCache(LocalDate date, Integer professional) {
        return Cache.contains(this.get(this.appointmentDateReferenceCache, professional), date);
    }

    private static boolean contains(ConcurrentSkipListSet<CacheItem> cache, LocalDate date) {
        long time = System.currentTimeMillis();
        for (CacheItem i : cache) {
            if (i.date != date) continue;
            i.lastUsedTime = time;
            return true;
        }
        return false;
    }

    private static boolean containsAll(ConcurrentSkipListSet<CacheItem> cache, Collection<LocalDate> dates) {
        if (dates.isEmpty()) {
            return false;
        }
        for (LocalDate date : dates) {
            if (Cache.contains(cache, date)) continue;
            return false;
        }
        return true;
    }

    void checkForObject(Object object) {
        if (object instanceof XAppointmentDate) {
            XAppointmentDate date = (XAppointmentDate)object;
            this.checkCacheForAppointmentDate(date.getDate(), date.getProfessional());
        } else if (object instanceof XBaseAppointmentDate) {
            XBaseAppointmentDate date = (XBaseAppointmentDate)object;
            this.checkCacheForAppointmentDate(date.getDate(), date.getProfessional());
        }
    }

    void checkCacheForBaseAppointmentDates(Collection<LocalDate> dates, List<Integer> professionals) {
        ArrayList<Integer> profs = new ArrayList<Integer>(professionals.size());
        ArrayList<LocalDate> datesToGet = new ArrayList<LocalDate>();
        for (Integer prof : professionals) {
            ConcurrentSkipListSet<CacheItem> set = this.get(this.baseAppointmentDateReferenceCache, prof);
            if (set.isEmpty()) {
                profs.add(prof);
                continue;
            }
            if (Cache.containsAll(set, dates)) continue;
            ArrayList<LocalDate> list = new ArrayList<LocalDate>(dates);
            for (CacheItem i : set) {
                list.remove(i.date);
            }
            datesToGet.addAll(list);
            profs.add(prof);
        }
        if (profs.size() != 0) {
            if (datesToGet.isEmpty()) {
                datesToGet.addAll(dates);
            }
            Collections.sort(datesToGet);
            this.getBaseDatesFromServer((LocalDate)datesToGet.get(0), (LocalDate)datesToGet.get(datesToGet.size() - 1), profs);
        }
    }

    void checkCacheForAppointmentDates(Collection<LocalDate> dates, List<Integer> professionals) {
        ArrayList<Integer> profs = new ArrayList<Integer>(professionals.size());
        ArrayList<LocalDate> datesToGet = new ArrayList<LocalDate>();
        for (Integer prof : professionals) {
            ConcurrentSkipListSet<CacheItem> set = this.get(this.appointmentDateReferenceCache, prof);
            if (set.isEmpty()) {
                profs.add(prof);
                continue;
            }
            if (Cache.containsAll(set, dates)) continue;
            ArrayList<LocalDate> list = new ArrayList<LocalDate>(dates);
            for (CacheItem i : set) {
                list.remove(i.date);
            }
            datesToGet.addAll(list);
            profs.add(prof);
        }
        if (profs.size() != 0) {
            if (datesToGet.isEmpty()) {
                datesToGet.addAll(dates);
            }
            if (!datesToGet.isEmpty()) {
                Collections.sort(datesToGet);
                this.getDatesFromServer((LocalDate)datesToGet.get(0), (LocalDate)datesToGet.get(datesToGet.size() - 1), profs);
            }
        }
    }

    void checkCacheForBaseAppointmentDates(LocalDate date, Integer professional) {
        if (!this.isDateInCache(date, professional, this.baseAppointmentDateReferenceCache)) {
            Pair<LocalDate, LocalDate> dateRange = this.getDateRangeForBaseAppointmentDates(date);
            this.getBaseDatesFromServer((LocalDate)dateRange.first, (LocalDate)dateRange.second, Arrays.asList(professional));
        }
    }

    private Pair<LocalDate, LocalDate> getDateRangeForBaseAppointmentDates(LocalDate date) {
        LocalDate start = date.plusMonth(-1).withDay(1).withDayOfWeek(1);
        LocalDate end = date.plusMonth(2).withDayEndOfMonth().withDayOfWeek(7);
        return Pair.newPair((Object)start, (Object)end);
    }

    void checkCacheForAppointmentDate(LocalDate date, Integer professional) {
        if (!this.isDateInCache(date, professional, this.appointmentDateReferenceCache)) {
            Pair<LocalDate, LocalDate> dateRange = this.getDateRangeForAppointmentDates(date);
            this.getDatesFromServer((LocalDate)dateRange.first, (LocalDate)dateRange.second, Arrays.asList(professional));
        }
    }

    private Pair<LocalDate, LocalDate> getDateRangeForAppointmentDates(LocalDate date) {
        LocalDate start = date.withDayOfWeek(1);
        LocalDate end = date.withDayOfWeek(7);
        return Pair.newPair((Object)start, (Object)end);
    }

    private void addToCache(List<CacheItem> items, List<Integer> professionals, Map<Integer, ConcurrentSkipListSet<CacheItem>> targetCache) {
        for (Integer prof : professionals) {
            this.get(targetCache, prof).addAll(items);
        }
    }

    private void getBaseDatesFromServer(final LocalDate start, final LocalDate end, final List<Integer> professionals) {
        block4: {
            Log.log((Logger)logger, (String)"AppointmentMainModel.getBaseDatesFromServer", (String[])new String[]{"start", "end", "professionals"}, (Object[])new Object[]{start, end, professionals});
            JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)new JustLogStatusHandler()){

                public void responseReceived(ReturnObject response) {
                    Cache.this.addToCache(Cache.generateList(start, end), professionals, Cache.this.baseAppointmentDateReferenceCache);
                    Cache.this.outProcessReceivedObjects((XAppointmentCompleteDataContainer)response.getObj());
                }
            };
            try {
                this.synchronizedGetBaseAppointmentDatesFromServer(start, end, professionals, callback);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed getBaseDatesFromServer " + start + ", " + end + ", " + professionals, e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    protected void synchronizedGetBaseAppointmentDatesFromServer(LocalDate start, LocalDate end, List<Integer> professionals, JobCallback callback) throws CannotConnectToServerException, Exception {
        this.server.findXBaseDate_async(this.hashCode(), Application.get().getGlobalInstances().getSession(), callback, start, end, new ArrayList<Integer>(new HashSet<Integer>(professionals)));
    }

    private void getDatesFromServer(final LocalDate start, final LocalDate end, final List<Integer> professionals) {
        block4: {
            Log.log((Logger)logger, (String)"AppointmentMainModel.getDatesFromServer", (String[])new String[]{"start", "end", "professionals"}, (Object[])new Object[]{start, end, professionals});
            JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)new JustLogStatusHandler()){

                public void responseReceived(ReturnObject response) {
                    if (response != null && response.getObj() != null && response.getStatus().isOkToProceed()) {
                        Cache.this.addToCache(Cache.generateList(start, end), professionals, Cache.this.appointmentDateReferenceCache);
                        Cache.this.outProcessReceivedObjects((XAppointmentCompleteDataContainer)response.getObj());
                    }
                }
            };
            try {
                this.synchronizedGetAppointmentDatesFromServer(start, end, professionals, callback);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed getDatesFromServer " + start + ", " + end + ", " + professionals, e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    protected void synchronizedGetAppointmentDatesFromServer(LocalDate start, LocalDate end, List<Integer> professionals, JobCallback callback) throws CannotConnectToServerException, Exception {
        this.server.findXDate_async(this.hashCode(), Application.get().getGlobalInstances().getSession(), callback, start, end, new ArrayList<Integer>(new HashSet<Integer>(professionals)));
    }

    void outProcessReceivedObjects(XAppointmentCompleteDataContainer container) {
    }

    void checkAgainst(XAppointmentDate date) {
        if (!this.isDateInCache(date.getDate(), date.getProfessional(), this.appointmentDateReferenceCache)) {
            throw new IllegalStateException(Pair.newPair((Object)date.getDate(), (Object)date.getProfessional()) + " is not in cache");
        }
    }

    void checkAgainst(List<XAppointmentDate> lstDate) {
        assert (lstDate != null);
        for (XAppointmentDate date : lstDate) {
            ConcurrentSkipListSet<CacheItem> set = this.get(this.appointmentDateReferenceCache, date.getProfessional());
            if (!set.isEmpty() && Cache.contains(set, date.getDate())) continue;
            throw new IllegalStateException(Pair.newPair((Object)date.getDate(), (Object)date.getProfessional()) + " is not in cache");
        }
    }

    void dispose() {
        Log.log((Logger)logger, (String)"Cache.dispose", (String[])new String[0], (Object[])new Object[0]);
        this.baseAppointmentDateReferenceCache.clear();
        this.appointmentDateReferenceCache.clear();
        this.data = null;
    }

    void reset() {
        Log.log((Logger)logger, (String)"Cache.reset", (String[])new String[0], (Object[])new Object[0]);
        this.baseAppointmentDateReferenceCache.clear();
        this.appointmentDateReferenceCache.clear();
    }

    public <A, B extends A> void addOrReplaceObject(A old, B newObject) {
        if (newObject instanceof XAppointmentDate) {
            XAppointmentDate date = (XAppointmentDate)newObject;
            this.get(this.appointmentDateReferenceCache, date.getProfessional()).add(new CacheItem(date.getDate()));
        } else if (newObject instanceof XBaseAppointmentDate) {
            XBaseAppointmentDate date = (XBaseAppointmentDate)newObject;
            this.get(this.baseAppointmentDateReferenceCache, date.getProfessional()).add(new CacheItem(date.getDate()));
        }
    }

    public Map<Integer, Collection<LocalDate>> getAllNonUsedSince(long time) {
        HashMap<Integer, Collection<LocalDate>> map = new HashMap<Integer, Collection<LocalDate>>();
        for (Map.Entry<Integer, ConcurrentSkipListSet<CacheItem>> entry : this.appointmentDateReferenceCache.entrySet()) {
            IdentityArrayList list = new IdentityArrayList();
            map.put(entry.getKey(), (Collection<LocalDate>)list);
            for (CacheItem i : entry.getValue()) {
                if (i.lastUsedTime > time) continue;
                list.add((Object)i.date);
            }
        }
        return map;
    }

    public void removeBase(Integer professionnal, LocalDate date) {
        Iterator<CacheItem> iterator = this.get(this.baseAppointmentDateReferenceCache, professionnal).iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().date.equals((Object)date)) continue;
            iterator.remove();
            break;
        }
    }

    public void remove(Integer professionnal, Collection<LocalDate> dates) {
        Iterator<CacheItem> iterator = this.get(this.appointmentDateReferenceCache, professionnal).iterator();
        while (iterator.hasNext()) {
            if (!dates.contains(iterator.next().date)) continue;
            iterator.remove();
        }
    }

    static class CacheItem
    implements Comparable<CacheItem> {
        final LocalDate date;
        long lastUsedTime;

        private CacheItem(LocalDate date) {
            this.date = date;
            this.lastUsedTime = System.currentTimeMillis();
        }

        public int hashCode() {
            return this.date.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CacheItem)) {
                return false;
            }
            return this.hashCode() == obj.hashCode();
        }

        @Override
        public int compareTo(CacheItem o) {
            return this.date.compareTo((IPartialDate)o.date);
        }

        public String toString() {
            return "CI[" + this.date + "]";
        }
    }
}

