/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.appointment;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.form.combo.proposal.IAddress;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.person.address2.SimplePatientAddressAdapter;
import ca.infodata.ofys.ui.person.search.ProfessionnalSearchComposite;
import ca.infodata.ofys.ui.person.search.ProfessionnalSearchView;
import ca.infodata.ofys.ui.person.simple.BaseSimplePatientControl;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AppointmentSimplePatientControl
extends BaseSimplePatientControl {
    public AppointmentSimplePatientControl(Composite parent, FormToolkit toolkit, IBaseEditor parentEditor) {
        super(parent, toolkit, parentEditor);
    }

    public void showDataObject() {
        IPatient patient = this.getPatient();
        this.txtNoteVariableReplacer.setToday(LocalDate.today());
        this.txtNoteVariableReplacer.setDataObject((Object)patient);
        this.lblPatientNotFoundText.setVisible(false);
        if (patient == null) {
            this.setEnabled(false);
            this.lblPatientRecordNumberMoreVisible.setText(null);
            this.txtLastName.setRawText(null);
            this.txtFirstName.setRawText(null);
            this.txtNote.setText(null);
            this.txtBirthDate.setDate(null);
            this.cmbGender.selectNone();
            this.addressControlCompact.setAddress(null);
            this.addressControlCompact.showCurrentAddress();
            this.cmbTypeContact1.selectNone();
            this.setMaskType(XContactInformation.CONTACT_TYPE_PHONE);
            this.cmbTypeContact1.selectNone();
            this.txtContact1.setRawText(null);
            this.txtNoteContact1.setText(null);
            this.txtPatientRecordNumber.setRawText(null);
            this.txtHealthInsuranceNumber.setText(null);
            this.txtTreatingProfessionnal.setDataObject(null);
            this.txtExpirationCAM.setRawText(null);
        } else {
            boolean isNew = patient.getId() == null;
            this.setEnabled(true);
            Integer idUser = Application.get().getGlobalInstances().getSession().getUser().getId();
            boolean showPatient = patient.hasActiveConsentement(idUser, XConsentement.RIGHT_PATIENT);
            boolean showPatientOther = patient.hasActiveConsentement(idUser, XConsentement.RIGHT_PATIENT_OTHER);
            boolean showAddress = patient.hasActiveConsentement(idUser, XConsentement.RIGHT_ADDRESS);
            boolean showComm = patient.hasActiveConsentement(idUser, XConsentement.RIGHT_COMMUNICATION);
            this.txtHealthInsuranceNumber.setVisible(showPatient);
            this.txtTreatingProfessionnal.setVisible(showPatientOther);
            this.cmbTypeContact1.setVisible(showComm);
            this.txtContact1.setVisible(showComm);
            this.txtNoteContact1.setVisible(showComm);
            this.addressControlCompact.setVisible(showAddress);
            this.lblPatientRecordNumberMoreVisible.setText(this.lblPatientRecordNumberMoreVisible.getData("base") + " " + StringUtils.defaultString((String)patient.getPatientRecordNumber()));
            this.txtLastName.setRawTextKeepSelection(patient.getLastName());
            this.txtFirstName.setRawTextKeepSelection(patient.getFirstName());
            this.txtNote.setTextKeepSelection(patient.getNote());
            this.txtBirthDate.setDate((IPartialDate)patient.getBirthDate());
            this.cmbGender.select((Object)XPerson.Gender.from((String)patient.getGender()));
            this.addressControlCompact.setAddress((IAddress)new SimplePatientAddressAdapter(this.getController()));
            this.addressControlCompact.showCurrentAddress();
            XContactInformation firstContactInformation = patient.getFirstContactInformation();
            Integer type1 = firstContactInformation == null || firstContactInformation.getTypeContact() == null ? XContactInformation.CONTACT_TYPE_PHONE.intValue() : firstContactInformation.getTypeContact().intValue();
            this.setMaskType(type1);
            this.cmbTypeContact1.select((Object)(firstContactInformation == null ? XContactInformation.CONTACT_TYPE_PHONE.intValue() : firstContactInformation.getTypeContact().intValue()));
            this.txtContact1.setTextKeepSelection(patient.getFirstContactInformationContact());
            this.txtNoteContact1.setTextKeepSelection(patient.getFirstContactInformationNote());
            this.txtPatientRecordNumber.setRawTextKeepSelection(patient.getPatientRecordNumber());
            this.txtHealthInsuranceNumber.setTextKeepSelection(patient.getHealthInsuranceNumber() == null ? null : patient.getHealthInsuranceNumber().trim());
            this.txtExpirationCAM.setRawTextKeepSelection(patient.getExpirationCAM());
            this.txtTreatingProfessionnal.setDataObjectId(patient.getTreatingProfessionnal());
            this.txtLastName.setEditable(isNew);
            this.txtFirstName.setEditable(isNew);
        }
    }

    public void setEnabled(boolean enabled) {
        this.txtLastName.setEnabled(enabled);
        this.txtFirstName.setEnabled(enabled);
        this.txtNote.setEnabled(enabled);
        this.txtBirthDate.setEnabled(enabled);
        this.cmbGender.setEnabled(enabled);
        this.addressControlCompact.setEnabled(enabled);
        this.cmbTypeContact1.setEnabled(enabled);
        this.txtContact1.setEnabled(enabled);
        this.txtNoteContact1.setEnabled(enabled);
        this.txtPatientRecordNumber.setEnabled(enabled);
        this.txtHealthInsuranceNumber.setEnabled(enabled);
        this.txtTreatingProfessionnal.setEnabled(enabled);
        this.txtExpirationCAM.setEnabled(enabled);
    }

    protected String getFormatedPatientRecordNumberFromControl() {
        String strZero = "0000000000" + this.txtPatientRecordNumber.getText();
        return strZero.substring(strZero.length() - Application.get().getGlobalInstances().getSession().getClientPreferences().getPatientRecordNumberLength());
    }

    protected void btnSearchTreatingProfessionnalSelected() {
        this.txtTreatingProfessionnal.setData("isTreatingProfessionnal", (Object)true);
        ProfessionnalSearchComposite professionnalSearch = this.getProfessionnalSearch();
        if (professionnalSearch != null) {
            professionnalSearch.setReferenceControl((Object)this.txtTreatingProfessionnal);
            professionnalSearch.setFocus();
        } else {
            IViewPart view = BaseSearchView.openView(ProfessionnalSearchView.class, (Object)this.txtTreatingProfessionnal);
            ((ProfessionnalSearchView)view).setType(null);
        }
    }
}

