/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.appointment.control.AppointmentDateControl;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.ui.appointment.control.BaseDrawer;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.ProviderAR;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ScrollBar;

public class ThermometerDrawer
extends BaseDrawer {
    private static final Logger logger = Logger.getLogger(ThermometerDrawer.class.getName());
    private AppointmentDateControl appointmentControl;
    private boolean showTime = true;

    public ThermometerDrawer(Canvas canvas, ScrollBar scroll) {
        super(canvas, scroll);
        this.ymargin = 0;
        this.drawBorder = true;
        this.drawText = false;
        this.drawReplacement = false;
        this.drawGroup = false;
        this.setAppointmentLabelProvider(new ProviderAR<IAppointment, String>(){

            public String get(IAppointment appointment) {
                return "";
            }
        });
    }

    @Override
    protected void drawPeriodMoveHook(XAppointmentPeriod period, int x, int y, int width, int height) {
    }

    @Override
    public Cursor getCursorForMouseLocation(int x, int y) {
        return null;
    }

    @Override
    public boolean moveTo(int x, int y) {
        return false;
    }

    @Override
    public boolean resizeTo(int x, int y) {
        return false;
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    public void drawControl(GC gc) {
        this.firstDrawOccured = true;
        this.drawingSpaceX = this.canvas.getBounds().width - this.drawingSpaceAjustment;
        this.drawingSpaceY = this.canvas.getBounds().height - this.drawingSpaceAjustment;
        if (this.visualStructure != null && this.visualStructure.isUsable()) {
            this.lineHeight = (float)this.drawingSpaceY / (float)this.visualStructure.getNbLineByDay();
        }
        if (this.lineHeight < 3.0f) {
            this.lineHeight = 3.0f;
        }
        this.borderSelectionMargin = 4;
        this.margin = 0;
        this.appointmentSpace = this.drawingSpaceX - this.margin;
        this.firstVisibleLine = this.scroll.getSelection();
        this.visibleSpace = (int)((float)this.drawingSpaceY / this.lineHeight) - 1;
        this.firstNotVisibleLine = this.firstVisibleLine + this.visibleSpace;
        Image buffer = new Image((Device)this.canvas.getDisplay(), this.drawingSpaceX, this.drawingSpaceY);
        this.gcBuffer = new GC((Drawable)buffer);
        if (this.scroll.getThumb() != this.visibleSpace) {
            this.scroll.setThumb(this.visibleSpace);
        }
        try {
            try {
                if (this.visualStructure != null && this.visualStructure.isUsable()) {
                    int line = this.firstVisibleLine;
                    while (line <= this.firstNotVisibleLine) {
                        if (line < this.visualStructure.getNbLineByDay()) {
                            this.drawPeriod(line);
                        }
                        ++line;
                    }
                    this.drawAppointments();
                    if (this.appointmentControl.getVisualStructure() == this.getVisualStructure()) {
                        this.drawSelection();
                    }
                    if (this.showTime) {
                        line = this.firstVisibleLine;
                        while (line < this.firstNotVisibleLine) {
                            this.drawTime(line);
                            ++line;
                        }
                    } else {
                        this.drawTime(this.firstVisibleLine);
                    }
                    this.drawSelectionCursor();
                    this.drawForeground();
                }
                gc.drawImage(buffer, 0, 0);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to draw thermometer control", e);
                gc.drawImage(buffer, 0, 0);
                this.gcBuffer.dispose();
                buffer.dispose();
            }
        }
        finally {
            gc.drawImage(buffer, 0, 0);
            this.gcBuffer.dispose();
            buffer.dispose();
        }
    }

    @Override
    protected void drawForeground() {
        if (this.appointmentControl != null && this.appointmentControl.getVisualStructure() == this.getVisualStructure()) {
            Color foreground = this.gcBuffer.getForeground();
            int lineWidth = this.gcBuffer.getLineWidth();
            int x = 1;
            int height = (int)((float)(this.appointmentControl.getDrawer().firstNotVisibleLine - this.appointmentControl.getDrawer().firstVisibleLine) * this.lineHeight);
            int y = (int)((float)this.appointmentControl.getDrawer().firstVisibleLine * this.lineHeight);
            int width = this.drawingSpaceX - 2;
            Color colorText = this.getColor(0, 0, 0);
            this.gcBuffer.setForeground(colorText);
            this.gcBuffer.setLineWidth(2);
            this.gcBuffer.drawRectangle(x, y, width, height);
            this.gcBuffer.setForeground(foreground);
            this.gcBuffer.setLineWidth(lineWidth);
        }
    }

    @Override
    protected void drawTime(int line) {
        if (line * this.getVisualStructure().getScale() % 60 == 0) {
            Color foreground = this.gcBuffer.getForeground();
            Color colorText = this.getColor(0, 0, 0);
            this.gcBuffer.setForeground(colorText);
            this.gcBuffer.drawText(this.lineNumberToTimeString(line), 2, (int)((float)(line - this.firstVisibleLine) * this.lineHeight), true);
            this.gcBuffer.setForeground(foreground);
        }
    }

    @Override
    protected String lineNumberToTimeString(int line) {
        String timeString = "";
        int timeInMinute = line * this.visualStructure.getScale() + this.visualStructure.getStartTimeMinute();
        timeString = String.valueOf(timeInMinute / 60) + "h";
        timeString = timeString.length() == 2 ? "0" + timeString : timeString;
        return timeString;
    }

    @Override
    public void setFocus(boolean b) {
    }

    @Override
    public void setSelection(int x, int y) {
        if (this.visualStructure != null && this.visualStructure.isUsable()) {
            AppointmentVisualStructure.VsPoint vsPoint = this.getVSPointFromGCPoint(new Point(x, y));
            if (!this.visualStructure.getSelection().equals(vsPoint)) {
                this.visualStructure.setSelection(vsPoint);
                if (this.appointmentControl != null) {
                    this.appointmentControl.reveal(vsPoint, true);
                    this.redraw();
                }
            }
        }
    }

    public void setAppointmentControl(AppointmentDateControl appointmentControl) {
        this.appointmentControl = appointmentControl;
    }

    public void setShowTime(boolean b) {
        this.showTime = b;
    }

    @Override
    protected void drawPeriod(int line) {
        XAppointmentPeriod period = this.visualStructure.getPeriod(line);
        if (period != null && (line == this.firstVisibleLine || this.visualStructure.getLine(period) == line)) {
            XSite site;
            Color background = this.gcBuffer.getBackground();
            Color foreground = this.gcBuffer.getForeground();
            Font font = this.gcBuffer.getFont();
            int x = this.margin;
            int y = (int)((float)(this.visualStructure.getLine(period) - this.firstVisibleLine) * this.lineHeight);
            int width = this.appointmentSpace;
            int height = (int)((float)this.visualStructure.getHeight(period) * this.lineHeight);
            Color colorTypePeriod = period.isClosed() ? this.getColor(75, 75, 75) : this.getPeriodColor(period.getAppointmentPeriodType());
            this.gcBuffer.setBackground(colorTypePeriod);
            this.gcBuffer.fillRectangle(x, y, width, height);
            if (period.getIdSite() != null && (site = SitePlugin.getDefault().getSite(period.getIdSite())) != null && site.getColor() != null) {
                Color siteColor = this.getColor(site.getColor());
                this.gcBuffer.setBackground(siteColor);
                this.gcBuffer.fillRectangle(x + 1, y + 1, this.siteMarkerWidth, height - 2);
            }
            if (this.drawBorder) {
                Color colorBorder = this.getColor(50, 50, 50);
                this.gcBuffer.setForeground(colorBorder);
                this.gcBuffer.drawRectangle(x, y, width, height);
                Color colorWhitish = this.getColor(240, 240, 240);
                this.gcBuffer.setForeground(colorWhitish);
                this.gcBuffer.drawLine(x + 1, y + height - 1, x + width - 2, y + height - 1);
            }
            this.gcBuffer.setBackground(background);
            this.gcBuffer.setForeground(foreground);
            this.gcBuffer.setFont(font);
        }
    }
}

