/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.gson.IGsonProcessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.appointment.control.AppointmentFormatField;
import ca.infodata.ofys.ui.controls.util.IPreferenceListener;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.util.json.IJsonReader;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public abstract class AppointmentFormatterSettingsBased
implements ProviderAR<IAppointment, String>,
IPreferenceListener {
    private static final String GROUP_OF_X_PTS = Messages.getString((String)"GROUP_OF_X_PTS", (String[])new String[0]);
    public static final String APPOINTMENT_FORMAT_PREF = "appointment/appointment_format_pref";
    public static final String MULTI_PROF_APPOINTMENT_FORMAT_PREF = "appointment/multi_prof_appointment_format_pref";
    private static EnumSet<AppointmentFormatField> defaultFormat = EnumSet.of(AppointmentFormatField.TIME, new AppointmentFormatField[]{AppointmentFormatField.DURATION, AppointmentFormatField.NOTE, AppointmentFormatField.STATUS, AppointmentFormatField.PATIENT_NAME, AppointmentFormatField.PATIENT_STATUS});
    private EnumSet<AppointmentFormatField> format;
    private String preferenceKey;
    private final IGsonProcessor gsonProcessor;

    public AppointmentFormatterSettingsBased(String preferenceKey) {
        this.preferenceKey = preferenceKey;
        this.format = AppointmentFormatterSettingsBased.getFormatFromSettings(this.preferenceKey);
        PreferencesSettings.getInstance().addListener((IPreferenceListener)this);
        this.gsonProcessor = Application.get().getGsonProcessor();
    }

    public void setPreferenceKey(String preferenceKey) {
        this.format = AppointmentFormatterSettingsBased.getFormatFromSettings(preferenceKey);
    }

    public String get(IAppointment appointment) {
        boolean canSeeAndModifyAppointment = this.canSeeAndModifyAppointment(appointment);
        short startTime = appointment.getStartTime();
        short endTime = appointment.getEndTime();
        int hour = startTime / 60;
        int minutes = startTime % 60;
        int length = endTime - startTime;
        IPatient patient = appointment.getPatientOrAdhoc((IJsonReader)this.gsonProcessor);
        XPatientStatus patientStatus = appointment.getPatientStatus();
        XAppointmentStatus status = appointment.getStatus();
        String formattedHour = StringUtils.padLeft((String)String.valueOf(hour), (int)2, (char)'0');
        String formattedMinutes = StringUtils.padLeft((String)String.valueOf(minutes), (int)2, (char)'0');
        String formattedDuration = StringUtils.padLeft((String)String.valueOf(length), (int)2, (char)'0');
        String formattedNote = appointment.getNote();
        String formattedPatientNote = String.valueOf(StringUtils.defaultString((String)appointment.getNotePatient(), (String)"")) + StringUtils.defaultString((String)appointment.getConsultationReason(), (String)"");
        String formattedPatientStatus = (patientStatus == XPatientStatus.ARRIVED || patientStatus == XPatientStatus.ARRIVED_LATE) && appointment.getArrivedTime() != null && appointment.getArrivedTime().intValue() > 0 ? String.valueOf(DateUtil.convertTimeToString((Short)appointment.getArrivedTime(), (Character)Character.valueOf(':'))) + " " + patientStatus.toString() : (patientStatus == XPatientStatus.SEEN && appointment.getSeenTime() != null && appointment.getSeenTime().intValue() > 0 ? String.valueOf(DateUtil.convertTimeToString((Short)appointment.getSeenTime(), (Character)Character.valueOf(':'))) + " " + patientStatus.toString() : (patientStatus != null && patientStatus != XPatientStatus.NONE ? patientStatus.toString() : ""));
        String formattedStatus = status != null && status != XAppointmentStatus.NORMAL ? status.toString() : "";
        StringBuilder s = new StringBuilder();
        if (Application.get().getGlobalInstances().inDebugMode()) {
            String s2 = "v" + appointment.getVersion() + " aid=" + appointment.getId() + " pv=" + (patient == null ? null : patient.getVersion()) + " pid=" + (patient == null ? null : patient.getId());
            s.append(s2).append("").append('\n');
        }
        if (this.contains(AppointmentFormatField.TIME)) {
            s.append(formattedHour).append("h").append(formattedMinutes);
        }
        if (this.contains(AppointmentFormatField.DURATION)) {
            s.append(" (").append(formattedDuration).append("M)");
        }
        if (Boolean.TRUE.equals(appointment.getIsConfidential())) {
            s.append(" CONFIDENTIEL");
        }
        if (canSeeAndModifyAppointment) {
            if (appointment.getPatients().size() > 1) {
                s.append("; ").append(MessageFormat.format(GROUP_OF_X_PTS, appointment.getPatients().size())).append(" :");
                for (IPatient xsp : appointment.getPatients()) {
                    s.append(" [").append(xsp.getNameBirthdateSex()).append("]");
                }
            } else if (patient != null) {
                XBaseProfessionnal prof;
                XContactInformation contact;
                if (this.contains(AppointmentFormatField.PATIENT_NAME_BIRTHDATE_SEX)) {
                    s.append("; ").append(patient.getNameBirthdateSex());
                } else if (this.contains(AppointmentFormatField.PATIENT_NAME)) {
                    s.append("; ").append(patient.getName());
                }
                if (this.contains(AppointmentFormatField.PATIENT_NAM_EXP) && StringUtils.isNotBlank((String)patient.getHealthInsuranceNumber())) {
                    s.append("; ").append(patient.getHealthInsuranceNumber());
                    if (StringUtils.isNotBlank((String)patient.getFormatedExpirationCAM())) {
                        s.append(" ( EXP ").append(patient.getFormatedExpirationCAM()).append(" )");
                    }
                } else if (this.contains(AppointmentFormatField.PATIENT_NAM) && StringUtils.isNotBlank((String)patient.getHealthInsuranceNumber())) {
                    s.append("; ").append(patient.getHealthInsuranceNumber());
                }
                if (this.contains(AppointmentFormatField.PATIENT_NO) && StringUtils.isNotBlank((String)patient.getPatientRecordNumber())) {
                    s.append("; ").append(patient.getPatientRecordNumber());
                }
                if (this.contains(AppointmentFormatField.PATIENT_PHONE1) && patient.getFirstContactInformationContact() != null && (contact = patient.getFirstContactInformation()) != null) {
                    s.append("; ").append(contact.getFormatedContact());
                }
                if (this.contains(AppointmentFormatField.PATIENT_PHONE2) && patient.getSecondContactInformationContact() != null && (contact = patient.getSecondContactInformation()) != null) {
                    s.append("; ").append(contact.getFormatedContact());
                }
                if (this.contains(AppointmentFormatField.PATIENT_STATUS_B2B) && patient.getB2bStatus() != null) {
                    s.append("; ").append(patient.getB2bStatus());
                }
                if (this.contains(AppointmentFormatField.PATIENT_TREATING_PROF) && (prof = PersonUiPlugin.getDefault().getBaseProfessionnal(patient.getTreatingProfessionnal())) != null) {
                    s.append("; MED: ").append(prof.getName());
                }
            }
            if (this.contains(AppointmentFormatField.PATIENT_STATUS) && !StringUtils.isBlank((CharSequence)formattedPatientStatus)) {
                s.append("; (").append(formattedPatientStatus).append(")");
            }
            if (this.contains(AppointmentFormatField.STATUS) && !StringUtils.isBlank((CharSequence)formattedStatus)) {
                s.append("; (").append(formattedStatus).append(")");
            }
            if (this.contains(AppointmentFormatField.NOTE)) {
                StringBuilder sbNote = new StringBuilder();
                if (!StringUtils.isBlank((CharSequence)formattedNote)) {
                    sbNote.append(formattedNote);
                }
                if (!StringUtils.isBlank((CharSequence)formattedPatientNote)) {
                    if (sbNote.length() > 0) {
                        sbNote.append(" | ");
                    }
                    sbNote.append("@").append(formattedPatientNote);
                }
                if (sbNote.length() > 0) {
                    s.append('\n').append("| ").append((CharSequence)sbNote);
                }
            }
        }
        return s.toString();
    }

    protected abstract boolean canSeeAndModifyAppointment(IAppointment var1);

    private boolean contains(AppointmentFormatField e) {
        return this.format.contains((Object)e);
    }

    public void changed(String preferenceId, String oldValue, String newValue) {
        if (this.preferenceKey.equals(preferenceId)) {
            this.format = AppointmentFormatterSettingsBased.getFormatFromSettings(this.preferenceKey);
        }
    }

    public static void setFormatToSettings(String preferenceKey, List<AppointmentFormatField> list) {
        String raw = "";
        if (list != null) {
            JoinList joinList = new JoinList(";");
            for (AppointmentFormatField f : list) {
                if (f == null) continue;
                joinList.add((CharSequence)f.name());
            }
            raw = joinList.toString();
        }
        PreferencesSettings.getInstance().put(preferenceKey, raw);
    }

    public static EnumSet<AppointmentFormatField> getFormatFromSettings(String preferenceKey) {
        String raw = PreferencesSettings.getInstance().get(preferenceKey);
        if (StringUtils.isBlank((CharSequence)raw)) {
            return defaultFormat;
        }
        try {
            String[] split;
            ArrayList<AppointmentFormatField> list = new ArrayList<AppointmentFormatField>();
            String[] stringArray = split = raw.split(";");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                AppointmentFormatField e = AppointmentFormatField.valueOf(s);
                if (e == null) {
                    return defaultFormat;
                }
                list.add(e);
                ++n2;
            }
            if (list.isEmpty()) {
                return defaultFormat;
            }
            return EnumSet.copyOf(list);
        }
        catch (Exception exception) {
            return defaultFormat;
        }
    }

    public void validChange(String preferenceId, String oldValue, String newValue, MultiStatus status) {
    }
}

