/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.ui.appointment.control.BaseDrawer;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.RangeNotation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ScrollBar;

public class AppointmentDrawer
extends BaseDrawer {
    private AppointmentVisualStructure.VsPoint oldMoveToVsPoint;
    private int oldResizeLine;

    public AppointmentDrawer(Canvas canvas, ScrollBar scroll) {
        super(canvas, scroll);
    }

    @Override
    public void setSelection(int x, int y) {
        if (this.visualStructure != null && this.visualStructure.isUsable()) {
            AppointmentVisualStructure.VsPoint vsPoint = this.getVSPointFromGCPoint(new Point(x, y));
            if (!this.visualStructure.getSelection().equals(vsPoint)) {
                this.visualStructure.setSelection(vsPoint);
            }
        }
    }

    @Override
    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    @Override
    public Cursor getCursorForMouseLocation(int x, int y) {
        Cursor cursor = null;
        if (this.firstDrawOccured && this.visualStructure != null && this.visualStructure.isUsable()) {
            IVisualAppointment appointment;
            int column;
            int columnWidth;
            int appointmentRightBorderX;
            int lastColumnIndex;
            int line = (int)((float)((y -= this.ymargin) - this.borderSelectionMargin) / this.lineHeight + (float)this.firstVisibleLine);
            if ((float)y % this.lineHeight < (float)this.borderSelectionMargin || (float)y % this.lineHeight > this.lineHeight - (float)this.borderSelectionMargin) {
                int t;
                int column2;
                IVisualAppointment appointment2;
                int lastColumnIndex2;
                if (line < this.visualStructure.getNbLineByDay() && line > -1 && (lastColumnIndex2 = this.visualStructure.getLastColumnIndex(line)) > -1 && (appointment2 = this.visualStructure.getAppointment(column2 = (t = this.appointmentSpace / (lastColumnIndex2 + 1)) == 0 ? 1 : (x - this.margin) / t, line)) != null && appointment2 instanceof IAppointment && this.visualStructure.getLine(appointment2) + this.visualStructure.getHeight(appointment2) - 1 == line) {
                    cursor = this.CURSOR_RESIZE;
                }
            } else if ((float)y % this.lineHeight < this.lineHeight / 2.0f && line < this.visualStructure.getNbLineByDay() && (lastColumnIndex = this.visualStructure.getLastColumnIndex(line)) > -1 && RangeNotation.CLOSED.inRange(x, (appointmentRightBorderX = this.margin + (columnWidth = this.appointmentSpace / (lastColumnIndex + 1)) * ((column = (x - this.margin) / (this.appointmentSpace / (lastColumnIndex + 1))) + 1)) - 10, appointmentRightBorderX) && (appointment = this.visualStructure.getAppointment(column, line)) != null && appointment instanceof IAppointment && this.visualStructure.getLine(appointment) == line) {
                cursor = this.CURSOR_MOVE;
            }
        }
        return cursor;
    }

    @Override
    public boolean resizeTo(int x, int y) {
        int resizingMargin;
        int line;
        boolean resized = false;
        if (this.visualStructure != null && this.visualStructure.isUsable() && ((float)(y -= this.ymargin) % this.lineHeight < (float)this.borderSelectionMargin || (float)y % this.lineHeight > this.lineHeight - (float)this.borderSelectionMargin) && (line = (int)((float)(y + (resizingMargin = 16)) / this.lineHeight + (float)this.firstVisibleLine)) != this.oldResizeLine) {
            this.oldResizeLine = line;
            IVisualAppointment appointment = this.visualStructure.getSelectedAppointment();
            if (appointment != null) {
                resized = this.visualStructure.resize(appointment, line);
            }
        }
        return resized;
    }

    @Override
    public boolean moveTo(int x, int y) {
        AppointmentVisualStructure.VsPoint vsPoint;
        boolean moved = false;
        if (this.visualStructure != null && this.visualStructure.isUsable() && (float)y % this.lineHeight < this.lineHeight / 2.0f && !(vsPoint = this.getVSPointFromGCPoint(new Point(x, y))).equals(this.oldMoveToVsPoint)) {
            this.oldMoveToVsPoint = vsPoint;
            IVisualAppointment selectedAppointment = this.visualStructure.getSelectedAppointment();
            if (selectedAppointment != null) {
                moved = this.visualStructure.move(selectedAppointment, this.oldMoveToVsPoint.line);
            }
        }
        return moved;
    }

    @Override
    protected void drawPeriodMoveHook(XAppointmentPeriod period, int x, int y, int width, int height) {
    }

    @Override
    protected void drawForeground() {
    }

    @Override
    protected void drawPeriod(int line) {
        XAppointmentPeriod period = this.visualStructure.getPeriod(line);
        if (period != null) {
            XSite site;
            int periodSectionHeight;
            int startLine = this.visualStructure.getLine(period);
            if ((line - startLine) % (periodSectionHeight = period.getDefaultLength() / this.visualStructure.getScale()) != 0) {
                return;
            }
            Color background = this.gcBuffer.getBackground();
            Color foreground = this.gcBuffer.getForeground();
            Font font = this.gcBuffer.getFont();
            int x = this.margin;
            int y = (int)((float)(line - this.firstVisibleLine) * this.lineHeight) + this.ymargin;
            int width = this.appointmentSpace;
            int height = (int)this.lineHeight * periodSectionHeight;
            Color colorTypePeriod = period.isClosed() ? this.getColor(75, 75, 75) : this.getPeriodColor(period.getAppointmentPeriodType());
            this.gcBuffer.setBackground(colorTypePeriod);
            this.gcBuffer.fillRectangle(x, y, width, height);
            if (period.getIdSite() != null && (site = SitePlugin.getDefault().getSite(period.getIdSite())) != null && site.getColor() != null) {
                Color siteColor = this.getColor(site.getColor());
                this.gcBuffer.setBackground(siteColor);
                this.gcBuffer.fillRectangle(x + 1, y + 1, this.siteMarkerWidth, height - 2);
            }
            if (this.drawText) {
                Color colorText = period.isClosed() ? this.getColor(255, 255, 255) : this.getColor(50, 50, 50);
                this.gcBuffer.setFont(this.fontNormal);
                this.gcBuffer.setForeground(colorText);
                this.gcBuffer.drawText((String)this.getPeriodLabelProvider().get((Object)period), x + 4 + this.siteMarkerWidth, y + 6, true);
            }
            if (this.drawBorder) {
                Color colorBorder = this.getColor(50, 50, 50);
                Color colorWhitish = this.getColor(200, 200, 200);
                this.gcBuffer.setForeground(colorBorder);
                this.gcBuffer.drawRectangle(x, y, width, height);
                this.gcBuffer.setForeground(colorBorder);
                this.gcBuffer.drawLine(x, y, x + width, y);
                this.gcBuffer.setForeground(colorWhitish);
                this.gcBuffer.drawLine(x + 1, y - 1, x + width - 2, y - 1);
            } else {
                this.gcBuffer.drawRectangle(x - 1, y - 1, width + 1, height + 1);
            }
            this.drawPeriodMoveHook(period, x, y, width, height);
            this.gcBuffer.setBackground(background);
            this.gcBuffer.setForeground(foreground);
            this.gcBuffer.setFont(font);
        }
    }
}

