/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarCell;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarGridData2;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarSelection;
import ca.infodata.ofys.ui.controls.calendar.grid.ICalendarGridData;
import ca.infodata.ofys.ui.controls.calendar.grid.MonthCell;
import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.GridDataListener;
import ca.infodata.ofys.ui.controls.grid.Selection;
import ca.infodata.util1.date.LocalDate;

public class AppointmentCalendarGridData
implements ICalendarGridData,
GridDataListener {
    private CalendarGridData2 calendarGridData;
    private AppointmentMainController controller;

    public AppointmentCalendarGridData(AppointmentMainController controller) {
        this.controller = controller;
        int nbMonthToPush = 3;
        LocalDate start = LocalDate.today().withDay(1);
        LocalDate end = LocalDate.today().plusMonth(nbMonthToPush).withDayEndOfMonth();
        this.calendarGridData = new CalendarGridData2(start, end, nbMonthToPush);
        this.calendarGridData.addListener((GridDataListener)this);
    }

    public void linePushed(boolean startLine, boolean endLine) {
        LocalDate first = this.calendarGridData.getAbsoluteStartDate();
        this.controller.getBaseAppointmentDate(first);
    }

    public void columnPushed(boolean startColumn, boolean endColumn) {
    }

    public XBaseAppointmentDate getStatistic(LocalDate date) {
        if (date != null && this.getController().isUsable()) {
            XBaseAppointmentDate xdate = this.getController().getBaseAppointmentDate(date);
            return xdate;
        }
        return null;
    }

    public boolean isLoaded(LocalDate date) {
        if (date != null && this.getController().isUsable()) {
            return this.getController().isBaseAppointmentDateInCache(date);
        }
        return false;
    }

    public void addListener(GridDataListener listener) {
        this.calendarGridData.addListener(listener);
    }

    public int getAbsoluteEndColumn() {
        return this.calendarGridData.getAbsoluteEndColumn();
    }

    public int getAbsoluteEndLine() {
        return this.calendarGridData.getAbsoluteEndLine();
    }

    public int getAbsoluteStartColumn() {
        return this.calendarGridData.getAbsoluteStartColumn();
    }

    public int getAbsoluteStartLine() {
        return this.calendarGridData.getAbsoluteStartLine();
    }

    public Cell getCell(int column, int line) {
        return this.calendarGridData.getCell(column, line);
    }

    public CalendarCell getCell(LocalDate date) {
        return this.calendarGridData.getCell(date);
    }

    public int getColumnWidth(int column) {
        return this.calendarGridData.getColumnWidth(column);
    }

    public LocalDate getDate(int column, int line) {
        return this.calendarGridData.getDate(column, line);
    }

    public int getLineHeigth(int line) {
        return this.calendarGridData.getLineHeigth(line);
    }

    public MonthCell getMonthCell(LocalDate date) {
        return this.calendarGridData.getMonthCell(date);
    }

    public LocalDate getStartDate() {
        return this.calendarGridData.getStartDate();
    }

    public boolean isMonthCellLine(int line) {
        return this.calendarGridData.isMonthCellLine(line);
    }

    public void removeListener(GridDataListener listener) {
        this.calendarGridData.removeListener(listener);
    }

    public int getSumColumnWidth(int startColumn, int endColumn) {
        return this.calendarGridData.getSumColumnWidth(startColumn, endColumn);
    }

    public int getSumLineHeigth(int startLine, int endLine) {
        return this.calendarGridData.getSumLineHeigth(startLine, endLine);
    }

    public AppointmentMainController getController() {
        return this.controller;
    }

    public void setController(AppointmentMainController controller) {
        if (controller == null) {
            throw new IllegalArgumentException();
        }
        this.controller = controller;
    }

    public void dispose() {
        this.controller = null;
        this.calendarGridData = null;
    }

    public Selection<Cell> getSelection() {
        return this.calendarGridData.getSelection();
    }

    public CalendarSelection getCalendarSelection() {
        return this.calendarGridData.getCalendarSelection();
    }

    public LocalDate getAbsoluteStartDate() {
        return this.calendarGridData.getAbsoluteStartDate();
    }

    public LocalDate getAbsoluteEndDate() {
        return this.calendarGridData.getAbsoluteEndDate();
    }

    public void pushStartLine() {
        this.calendarGridData.pushStartLine();
    }

    public void pushEndLine() {
        this.calendarGridData.pushEndLine();
    }

    public void pushStartColumn() {
        this.calendarGridData.pushStartColumn();
    }

    public void pushEndColumn() {
        this.calendarGridData.pushEndColumn();
    }

    public boolean contains(Cell cell) {
        return this.calendarGridData.contains(cell);
    }
}

